/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeConversionTasksRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeConversionTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeConversionTasksRequest> {
    private ListWithAutoConstructFlag<Filter> filters;
    private ListWithAutoConstructFlag<String> conversionTaskIds;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeConversionTasksRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeConversionTasksRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public List<String> getConversionTaskIds() {
        if (this.conversionTaskIds == null) {
            this.conversionTaskIds = new ListWithAutoConstructFlag();
            this.conversionTaskIds.setAutoConstruct(true);
        }
        return this.conversionTaskIds;
    }

    public void setConversionTaskIds(Collection<String> conversionTaskIds) {
        if (conversionTaskIds == null) {
            this.conversionTaskIds = null;
            return;
        }
        ListWithAutoConstructFlag conversionTaskIdsCopy = new ListWithAutoConstructFlag(conversionTaskIds.size());
        conversionTaskIdsCopy.addAll(conversionTaskIds);
        this.conversionTaskIds = conversionTaskIdsCopy;
    }

    public DescribeConversionTasksRequest withConversionTaskIds(String ... conversionTaskIds) {
        if (this.getConversionTaskIds() == null) {
            this.setConversionTaskIds(new ArrayList<String>(conversionTaskIds.length));
        }
        for (String value : conversionTaskIds) {
            this.getConversionTaskIds().add(value);
        }
        return this;
    }

    public DescribeConversionTasksRequest withConversionTaskIds(Collection<String> conversionTaskIds) {
        if (conversionTaskIds == null) {
            this.conversionTaskIds = null;
        } else {
            ListWithAutoConstructFlag conversionTaskIdsCopy = new ListWithAutoConstructFlag(conversionTaskIds.size());
            conversionTaskIdsCopy.addAll(conversionTaskIds);
            this.conversionTaskIds = conversionTaskIdsCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeConversionTasksRequest> getDryRunRequest() {
        Request<DescribeConversionTasksRequest> request = new DescribeConversionTasksRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getConversionTaskIds() != null) {
            sb.append("ConversionTaskIds: " + this.getConversionTaskIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getConversionTaskIds() == null ? 0 : this.getConversionTaskIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksRequest)) {
            return false;
        }
        DescribeConversionTasksRequest other = (DescribeConversionTasksRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getConversionTaskIds() == null ^ this.getConversionTaskIds() == null) {
            return false;
        }
        return other.getConversionTaskIds() == null || other.getConversionTaskIds().equals(this.getConversionTaskIds());
    }

    @Override
    public DescribeConversionTasksRequest clone() {
        return (DescribeConversionTasksRequest)super.clone();
    }
}

