/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    @Override
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RequestSpotFleetRequest> request = new DefaultRequest<RequestSpotFleetRequest>(requestSpotFleetRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2015-04-15");
        SpotFleetRequestConfigData spotFleetRequestConfigDataSpotFleetRequestConfig = requestSpotFleetRequest.getSpotFleetRequestConfig();
        if (spotFleetRequestConfigDataSpotFleetRequestConfig != null) {
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getClientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString(spotFleetRequestConfigDataSpotFleetRequestConfig.getClientToken()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getSpotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString(spotFleetRequestConfigDataSpotFleetRequestConfig.getSpotPrice()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger(spotFleetRequestConfigDataSpotFleetRequestConfig.getTargetCapacity()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getValidFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate(spotFleetRequestConfigDataSpotFleetRequestConfig.getValidFrom()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getValidUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate(spotFleetRequestConfigDataSpotFleetRequestConfig.getValidUntil()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.isTerminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean(spotFleetRequestConfigDataSpotFleetRequestConfig.isTerminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getIamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString(spotFleetRequestConfigDataSpotFleetRequestConfig.getIamFleetRole()));
            }
            List<SpotFleetLaunchSpecification> launchSpecificationsList = spotFleetRequestConfigDataSpotFleetRequestConfig.getLaunchSpecifications();
            int launchSpecificationsListIndex = 1;
            for (SpotFleetLaunchSpecification launchSpecificationsListValue : launchSpecificationsList) {
                SpotFleetLaunchSpecification spotFleetLaunchSpecificationMember = launchSpecificationsListValue;
                if (spotFleetLaunchSpecificationMember != null) {
                    SpotPlacement spotPlacementPlacement;
                    if (spotFleetLaunchSpecificationMember.getImageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString(spotFleetLaunchSpecificationMember.getImageId()));
                    }
                    if (spotFleetLaunchSpecificationMember.getKeyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString(spotFleetLaunchSpecificationMember.getKeyName()));
                    }
                    List<GroupIdentifier> securityGroupsList = spotFleetLaunchSpecificationMember.getSecurityGroups();
                    int securityGroupsListIndex = 1;
                    for (GroupIdentifier securityGroupsListValue : securityGroupsList) {
                        GroupIdentifier groupIdentifierMember = securityGroupsListValue;
                        if (groupIdentifierMember != null) {
                            if (groupIdentifierMember.getGroupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString(groupIdentifierMember.getGroupName()));
                            }
                            if (groupIdentifierMember.getGroupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString(groupIdentifierMember.getGroupId()));
                            }
                        }
                        ++securityGroupsListIndex;
                    }
                    if (spotFleetLaunchSpecificationMember.getUserData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString(spotFleetLaunchSpecificationMember.getUserData()));
                    }
                    if (spotFleetLaunchSpecificationMember.getAddressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString(spotFleetLaunchSpecificationMember.getAddressingType()));
                    }
                    if (spotFleetLaunchSpecificationMember.getInstanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString(spotFleetLaunchSpecificationMember.getInstanceType()));
                    }
                    if ((spotPlacementPlacement = spotFleetLaunchSpecificationMember.getPlacement()) != null) {
                        if (spotPlacementPlacement.getAvailabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString(spotPlacementPlacement.getAvailabilityZone()));
                        }
                        if (spotPlacementPlacement.getGroupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString(spotPlacementPlacement.getGroupName()));
                        }
                    }
                    if (spotFleetLaunchSpecificationMember.getKernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString(spotFleetLaunchSpecificationMember.getKernelId()));
                    }
                    if (spotFleetLaunchSpecificationMember.getRamdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString(spotFleetLaunchSpecificationMember.getRamdiskId()));
                    }
                    List<BlockDeviceMapping> blockDeviceMappingsList = spotFleetLaunchSpecificationMember.getBlockDeviceMappings();
                    int blockDeviceMappingsListIndex = 1;
                    for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                        BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingsListValue;
                        if (blockDeviceMappingMember != null) {
                            EbsBlockDevice ebsBlockDeviceEbs;
                            if (blockDeviceMappingMember.getVirtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(blockDeviceMappingMember.getVirtualName()));
                            }
                            if (blockDeviceMappingMember.getDeviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(blockDeviceMappingMember.getDeviceName()));
                            }
                            if ((ebsBlockDeviceEbs = blockDeviceMappingMember.getEbs()) != null) {
                                if (ebsBlockDeviceEbs.getSnapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebsBlockDeviceEbs.getSnapshotId()));
                                }
                                if (ebsBlockDeviceEbs.getVolumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebsBlockDeviceEbs.getVolumeSize()));
                                }
                                if (ebsBlockDeviceEbs.isDeleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebsBlockDeviceEbs.isDeleteOnTermination()));
                                }
                                if (ebsBlockDeviceEbs.getVolumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebsBlockDeviceEbs.getVolumeType()));
                                }
                                if (ebsBlockDeviceEbs.getIops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebsBlockDeviceEbs.getIops()));
                                }
                                if (ebsBlockDeviceEbs.isEncrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebsBlockDeviceEbs.isEncrypted()));
                                }
                            }
                            if (blockDeviceMappingMember.getNoDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(blockDeviceMappingMember.getNoDevice()));
                            }
                        }
                        ++blockDeviceMappingsListIndex;
                    }
                    SpotFleetMonitoring spotFleetMonitoringMonitoring = spotFleetLaunchSpecificationMember.getMonitoring();
                    if (spotFleetMonitoringMonitoring != null && spotFleetMonitoringMonitoring.isEnabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean(spotFleetMonitoringMonitoring.isEnabled()));
                    }
                    if (spotFleetLaunchSpecificationMember.getSubnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString(spotFleetLaunchSpecificationMember.getSubnetId()));
                    }
                    List<InstanceNetworkInterfaceSpecification> networkInterfacesList = spotFleetLaunchSpecificationMember.getNetworkInterfaces();
                    int networkInterfacesListIndex = 1;
                    for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
                        InstanceNetworkInterfaceSpecification instanceNetworkInterfaceSpecificationMember = networkInterfacesListValue;
                        if (instanceNetworkInterfaceSpecificationMember != null) {
                            if (instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getDeviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(instanceNetworkInterfaceSpecificationMember.getDeviceIndex()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(instanceNetworkInterfaceSpecificationMember.getSubnetId()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getDescription() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString(instanceNetworkInterfaceSpecificationMember.getDescription()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress()));
                            }
                            List<String> groupsList = instanceNetworkInterfaceSpecificationMember.getGroups();
                            int groupsListIndex = 1;
                            for (String groupsListValue : groupsList) {
                                if (groupsListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString(groupsListValue));
                                }
                                ++groupsListIndex;
                            }
                            if (instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination()));
                            }
                            List<PrivateIpAddressSpecification> privateIpAddressesList = instanceNetworkInterfaceSpecificationMember.getPrivateIpAddresses();
                            int privateIpAddressesListIndex = 1;
                            for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
                                PrivateIpAddressSpecification privateIpAddressSpecificationMember = privateIpAddressesListValue;
                                if (privateIpAddressSpecificationMember != null) {
                                    if (privateIpAddressSpecificationMember.getPrivateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(privateIpAddressSpecificationMember.getPrivateIpAddress()));
                                    }
                                    if (privateIpAddressSpecificationMember.isPrimary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(privateIpAddressSpecificationMember.isPrimary()));
                                    }
                                }
                                ++privateIpAddressesListIndex;
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress()));
                            }
                        }
                        ++networkInterfacesListIndex;
                    }
                    IamInstanceProfileSpecification iamInstanceProfileSpecificationIamInstanceProfile = spotFleetLaunchSpecificationMember.getIamInstanceProfile();
                    if (iamInstanceProfileSpecificationIamInstanceProfile != null) {
                        if (iamInstanceProfileSpecificationIamInstanceProfile.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfileSpecificationIamInstanceProfile.getArn()));
                        }
                        if (iamInstanceProfileSpecificationIamInstanceProfile.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfileSpecificationIamInstanceProfile.getName()));
                        }
                    }
                    if (spotFleetLaunchSpecificationMember.isEbsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean(spotFleetLaunchSpecificationMember.isEbsOptimized()));
                    }
                }
                ++launchSpecificationsListIndex;
            }
        }
        return request;
    }
}

