/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class SubmitContainerStateChangeRequestMarshaller
implements Marshaller<Request<SubmitContainerStateChangeRequest>, SubmitContainerStateChangeRequest> {
    @Override
    public Request<SubmitContainerStateChangeRequest> marshall(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        if (submitContainerStateChangeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubmitContainerStateChangeRequest> request = new DefaultRequest<SubmitContainerStateChangeRequest>(submitContainerStateChangeRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.SubmitContainerStateChange";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag networkBindingsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (submitContainerStateChangeRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(submitContainerStateChangeRequest.getCluster());
            }
            if (submitContainerStateChangeRequest.getTask() != null) {
                jsonWriter.key("task").value(submitContainerStateChangeRequest.getTask());
            }
            if (submitContainerStateChangeRequest.getContainerName() != null) {
                jsonWriter.key("containerName").value(submitContainerStateChangeRequest.getContainerName());
            }
            if (submitContainerStateChangeRequest.getStatus() != null) {
                jsonWriter.key("status").value(submitContainerStateChangeRequest.getStatus());
            }
            if (submitContainerStateChangeRequest.getExitCode() != null) {
                jsonWriter.key("exitCode").value(submitContainerStateChangeRequest.getExitCode());
            }
            if (submitContainerStateChangeRequest.getReason() != null) {
                jsonWriter.key("reason").value(submitContainerStateChangeRequest.getReason());
            }
            if (!((networkBindingsList = (ListWithAutoConstructFlag)submitContainerStateChangeRequest.getNetworkBindings()) == null || networkBindingsList.isAutoConstruct() && networkBindingsList.isEmpty())) {
                jsonWriter.key("networkBindings");
                jsonWriter.array();
                for (NetworkBinding networkBindingsListValue : networkBindingsList) {
                    if (networkBindingsListValue == null) continue;
                    jsonWriter.object();
                    if (networkBindingsListValue.getBindIP() != null) {
                        jsonWriter.key("bindIP").value(networkBindingsListValue.getBindIP());
                    }
                    if (networkBindingsListValue.getContainerPort() != null) {
                        jsonWriter.key("containerPort").value(networkBindingsListValue.getContainerPort());
                    }
                    if (networkBindingsListValue.getHostPort() != null) {
                        jsonWriter.key("hostPort").value(networkBindingsListValue.getHostPort());
                    }
                    if (networkBindingsListValue.getProtocol() != null) {
                        jsonWriter.key("protocol").value(networkBindingsListValue.getProtocol());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

