/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.internal;

import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import java.util.Arrays;
import java.util.List;

public class GlacierRequestHandler
extends AbstractRequestHandler {
    private static final List<String> PARAMETERS = Arrays.asList("vaults");

    @Override
    public void beforeRequest(Request<?> request) {
        String resourcePath;
        if (!this.startsWithUserId(request)) {
            resourcePath = request.getResourcePath();
            request.setResourcePath(resourcePath.replaceFirst("/", "/-/"));
        }
        request.addHeader("x-amz-glacier-version", "2012-06-01");
        request.addHeader("x-amz-content-sha256", "required");
        if (request.getOriginalRequest() instanceof UploadArchiveRequest) {
            String contentLength = request.getHeaders().remove("x-amz-content-length");
            if (contentLength != null) {
                request.getHeaders().put("Content-Length", contentLength);
            }
        } else if (request.getOriginalRequest() instanceof UploadMultipartPartRequest) {
            String range = request.getHeaders().get("Content-Range");
            if (range.startsWith("bytes=")) {
                range = range.substring(6);
            }
            if (range.startsWith("bytes ")) {
                range = range.substring(6);
            }
            if (range != null) {
                String start = range.substring(0, range.indexOf(45));
                String end = range.substring(range.indexOf(45) + 1);
                if (end.contains("/")) {
                    end = end.substring(0, end.indexOf("/"));
                }
                long contentLength = Long.parseLong(end) - Long.parseLong(start) + 1L;
                request.getHeaders().put("Content-Length", Long.toString(contentLength));
            }
        } else if ((request.getOriginalRequest() instanceof GetJobOutputRequest || request.getOriginalRequest() instanceof DescribeJobRequest) && (resourcePath = request.getResourcePath()) != null) {
            String newResourcePath = resourcePath.replace("{jobType}", "archive-retrievals");
            request.setResourcePath(newResourcePath);
        }
    }

    private boolean startsWithUserId(Request<?> request) {
        for (String parameter : PARAMETERS) {
            if (!request.getResourcePath().startsWith("/" + parameter)) continue;
            return false;
        }
        return true;
    }
}

