/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.CompleteVaultLockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CompleteVaultLockRequestMarshaller
implements Marshaller<Request<CompleteVaultLockRequest>, CompleteVaultLockRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<CompleteVaultLockRequest> marshall(CompleteVaultLockRequest completeVaultLockRequest) {
        String value;
        String name;
        if (completeVaultLockRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CompleteVaultLockRequest> request = new DefaultRequest<CompleteVaultLockRequest>(completeVaultLockRequest, "AmazonGlacier");
        String target = "Glacier.CompleteVaultLock";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = completeVaultLockRequest.getAccountId() == null ? null : StringUtils.fromString(completeVaultLockRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", completeVaultLockRequest.getAccountId() == null ? "" : StringUtils.fromString(completeVaultLockRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = completeVaultLockRequest.getVaultName() == null ? null : StringUtils.fromString(completeVaultLockRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", completeVaultLockRequest.getVaultName() == null ? "" : StringUtils.fromString(completeVaultLockRequest.getVaultName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("lockId")) {
            name = DYNAMIC_QUERY_PARAMS.get("lockId");
            String string = value = completeVaultLockRequest.getLockId() == null ? null : StringUtils.fromString(completeVaultLockRequest.getLockId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{lockId}", completeVaultLockRequest.getLockId() == null ? "" : StringUtils.fromString(completeVaultLockRequest.getLockId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

