/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.PolicyGroup;
import com.amazonaws.services.identitymanagement.model.PolicyRole;
import com.amazonaws.services.identitymanagement.model.PolicyUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEntitiesForPolicyResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<PolicyGroup> policyGroups;
    private ListWithAutoConstructFlag<PolicyUser> policyUsers;
    private ListWithAutoConstructFlag<PolicyRole> policyRoles;
    private Boolean isTruncated;
    private String marker;

    public List<PolicyGroup> getPolicyGroups() {
        if (this.policyGroups == null) {
            this.policyGroups = new ListWithAutoConstructFlag();
            this.policyGroups.setAutoConstruct(true);
        }
        return this.policyGroups;
    }

    public void setPolicyGroups(Collection<PolicyGroup> policyGroups) {
        if (policyGroups == null) {
            this.policyGroups = null;
            return;
        }
        ListWithAutoConstructFlag policyGroupsCopy = new ListWithAutoConstructFlag(policyGroups.size());
        policyGroupsCopy.addAll(policyGroups);
        this.policyGroups = policyGroupsCopy;
    }

    public ListEntitiesForPolicyResult withPolicyGroups(PolicyGroup ... policyGroups) {
        if (this.getPolicyGroups() == null) {
            this.setPolicyGroups(new ArrayList<PolicyGroup>(policyGroups.length));
        }
        for (PolicyGroup value : policyGroups) {
            this.getPolicyGroups().add(value);
        }
        return this;
    }

    public ListEntitiesForPolicyResult withPolicyGroups(Collection<PolicyGroup> policyGroups) {
        if (policyGroups == null) {
            this.policyGroups = null;
        } else {
            ListWithAutoConstructFlag policyGroupsCopy = new ListWithAutoConstructFlag(policyGroups.size());
            policyGroupsCopy.addAll(policyGroups);
            this.policyGroups = policyGroupsCopy;
        }
        return this;
    }

    public List<PolicyUser> getPolicyUsers() {
        if (this.policyUsers == null) {
            this.policyUsers = new ListWithAutoConstructFlag();
            this.policyUsers.setAutoConstruct(true);
        }
        return this.policyUsers;
    }

    public void setPolicyUsers(Collection<PolicyUser> policyUsers) {
        if (policyUsers == null) {
            this.policyUsers = null;
            return;
        }
        ListWithAutoConstructFlag policyUsersCopy = new ListWithAutoConstructFlag(policyUsers.size());
        policyUsersCopy.addAll(policyUsers);
        this.policyUsers = policyUsersCopy;
    }

    public ListEntitiesForPolicyResult withPolicyUsers(PolicyUser ... policyUsers) {
        if (this.getPolicyUsers() == null) {
            this.setPolicyUsers(new ArrayList<PolicyUser>(policyUsers.length));
        }
        for (PolicyUser value : policyUsers) {
            this.getPolicyUsers().add(value);
        }
        return this;
    }

    public ListEntitiesForPolicyResult withPolicyUsers(Collection<PolicyUser> policyUsers) {
        if (policyUsers == null) {
            this.policyUsers = null;
        } else {
            ListWithAutoConstructFlag policyUsersCopy = new ListWithAutoConstructFlag(policyUsers.size());
            policyUsersCopy.addAll(policyUsers);
            this.policyUsers = policyUsersCopy;
        }
        return this;
    }

    public List<PolicyRole> getPolicyRoles() {
        if (this.policyRoles == null) {
            this.policyRoles = new ListWithAutoConstructFlag();
            this.policyRoles.setAutoConstruct(true);
        }
        return this.policyRoles;
    }

    public void setPolicyRoles(Collection<PolicyRole> policyRoles) {
        if (policyRoles == null) {
            this.policyRoles = null;
            return;
        }
        ListWithAutoConstructFlag policyRolesCopy = new ListWithAutoConstructFlag(policyRoles.size());
        policyRolesCopy.addAll(policyRoles);
        this.policyRoles = policyRolesCopy;
    }

    public ListEntitiesForPolicyResult withPolicyRoles(PolicyRole ... policyRoles) {
        if (this.getPolicyRoles() == null) {
            this.setPolicyRoles(new ArrayList<PolicyRole>(policyRoles.length));
        }
        for (PolicyRole value : policyRoles) {
            this.getPolicyRoles().add(value);
        }
        return this;
    }

    public ListEntitiesForPolicyResult withPolicyRoles(Collection<PolicyRole> policyRoles) {
        if (policyRoles == null) {
            this.policyRoles = null;
        } else {
            ListWithAutoConstructFlag policyRolesCopy = new ListWithAutoConstructFlag(policyRoles.size());
            policyRolesCopy.addAll(policyRoles);
            this.policyRoles = policyRolesCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListEntitiesForPolicyResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListEntitiesForPolicyResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyGroups() != null) {
            sb.append("PolicyGroups: " + this.getPolicyGroups() + ",");
        }
        if (this.getPolicyUsers() != null) {
            sb.append("PolicyUsers: " + this.getPolicyUsers() + ",");
        }
        if (this.getPolicyRoles() != null) {
            sb.append("PolicyRoles: " + this.getPolicyRoles() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyGroups() == null ? 0 : this.getPolicyGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyUsers() == null ? 0 : this.getPolicyUsers().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyRoles() == null ? 0 : this.getPolicyRoles().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResult)) {
            return false;
        }
        ListEntitiesForPolicyResult other = (ListEntitiesForPolicyResult)obj;
        if (other.getPolicyGroups() == null ^ this.getPolicyGroups() == null) {
            return false;
        }
        if (other.getPolicyGroups() != null && !other.getPolicyGroups().equals(this.getPolicyGroups())) {
            return false;
        }
        if (other.getPolicyUsers() == null ^ this.getPolicyUsers() == null) {
            return false;
        }
        if (other.getPolicyUsers() != null && !other.getPolicyUsers().equals(this.getPolicyUsers())) {
            return false;
        }
        if (other.getPolicyRoles() == null ^ this.getPolicyRoles() == null) {
            return false;
        }
        if (other.getPolicyRoles() != null && !other.getPolicyRoles().equals(this.getPolicyRoles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListEntitiesForPolicyResult clone() {
        try {
            return (ListEntitiesForPolicyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

