/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeLogStreamsRequestMarshaller
implements Marshaller<Request<DescribeLogStreamsRequest>, DescribeLogStreamsRequest> {
    @Override
    public Request<DescribeLogStreamsRequest> marshall(DescribeLogStreamsRequest describeLogStreamsRequest) {
        if (describeLogStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLogStreamsRequest> request = new DefaultRequest<DescribeLogStreamsRequest>(describeLogStreamsRequest, "AWSLogs");
        String target = "Logs_20140328.DescribeLogStreams";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeLogStreamsRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(describeLogStreamsRequest.getLogGroupName());
            }
            if (describeLogStreamsRequest.getLogStreamNamePrefix() != null) {
                jsonWriter.key("logStreamNamePrefix").value(describeLogStreamsRequest.getLogStreamNamePrefix());
            }
            if (describeLogStreamsRequest.getOrderBy() != null) {
                jsonWriter.key("orderBy").value(describeLogStreamsRequest.getOrderBy());
            }
            if (describeLogStreamsRequest.isDescending() != null) {
                jsonWriter.key("descending").value(describeLogStreamsRequest.isDescending());
            }
            if (describeLogStreamsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(describeLogStreamsRequest.getNextToken());
            }
            if (describeLogStreamsRequest.getLimit() != null) {
                jsonWriter.key("limit").value(describeLogStreamsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

