/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.RedshiftDataSpec;
import com.amazonaws.services.machinelearning.model.RedshiftDatabase;
import com.amazonaws.services.machinelearning.model.RedshiftDatabaseCredentials;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDataSourceFromRedshiftRequestMarshaller
implements Marshaller<Request<CreateDataSourceFromRedshiftRequest>, CreateDataSourceFromRedshiftRequest> {
    @Override
    public Request<CreateDataSourceFromRedshiftRequest> marshall(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        if (createDataSourceFromRedshiftRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDataSourceFromRedshiftRequest> request = new DefaultRequest<CreateDataSourceFromRedshiftRequest>(createDataSourceFromRedshiftRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.CreateDataSourceFromRedshift";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RedshiftDataSpec dataSpec;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDataSourceFromRedshiftRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value(createDataSourceFromRedshiftRequest.getDataSourceId());
            }
            if (createDataSourceFromRedshiftRequest.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value(createDataSourceFromRedshiftRequest.getDataSourceName());
            }
            if ((dataSpec = createDataSourceFromRedshiftRequest.getDataSpec()) != null) {
                RedshiftDatabaseCredentials databaseCredentials;
                jsonWriter.key("DataSpec");
                jsonWriter.object();
                RedshiftDatabase databaseInformation = dataSpec.getDatabaseInformation();
                if (databaseInformation != null) {
                    jsonWriter.key("DatabaseInformation");
                    jsonWriter.object();
                    if (databaseInformation.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value(databaseInformation.getDatabaseName());
                    }
                    if (databaseInformation.getClusterIdentifier() != null) {
                        jsonWriter.key("ClusterIdentifier").value(databaseInformation.getClusterIdentifier());
                    }
                    jsonWriter.endObject();
                }
                if (dataSpec.getSelectSqlQuery() != null) {
                    jsonWriter.key("SelectSqlQuery").value(dataSpec.getSelectSqlQuery());
                }
                if ((databaseCredentials = dataSpec.getDatabaseCredentials()) != null) {
                    jsonWriter.key("DatabaseCredentials");
                    jsonWriter.object();
                    if (databaseCredentials.getUsername() != null) {
                        jsonWriter.key("Username").value(databaseCredentials.getUsername());
                    }
                    if (databaseCredentials.getPassword() != null) {
                        jsonWriter.key("Password").value(databaseCredentials.getPassword());
                    }
                    jsonWriter.endObject();
                }
                if (dataSpec.getS3StagingLocation() != null) {
                    jsonWriter.key("S3StagingLocation").value(dataSpec.getS3StagingLocation());
                }
                if (dataSpec.getDataRearrangement() != null) {
                    jsonWriter.key("DataRearrangement").value(dataSpec.getDataRearrangement());
                }
                if (dataSpec.getDataSchema() != null) {
                    jsonWriter.key("DataSchema").value(dataSpec.getDataSchema());
                }
                if (dataSpec.getDataSchemaUri() != null) {
                    jsonWriter.key("DataSchemaUri").value(dataSpec.getDataSchemaUri());
                }
                jsonWriter.endObject();
            }
            if (createDataSourceFromRedshiftRequest.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(createDataSourceFromRedshiftRequest.getRoleARN());
            }
            if (createDataSourceFromRedshiftRequest.isComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value(createDataSourceFromRedshiftRequest.isComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

