/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class PredictRequestMarshaller
implements Marshaller<Request<PredictRequest>, PredictRequest> {
    @Override
    public Request<PredictRequest> marshall(PredictRequest predictRequest) {
        if (predictRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PredictRequest> request = new DefaultRequest<PredictRequest>(predictRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.Predict";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (predictRequest.getMLModelId() != null) {
                jsonWriter.key("MLModelId").value(predictRequest.getMLModelId());
            }
            if (predictRequest.getRecord() != null) {
                jsonWriter.key("Record");
                jsonWriter.object();
                for (Map.Entry<String, String> recordListValue : predictRequest.getRecord().entrySet()) {
                    if (recordListValue.getValue() == null) continue;
                    jsonWriter.key(recordListValue.getKey());
                    jsonWriter.value(recordListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (predictRequest.getPredictEndpoint() != null) {
                jsonWriter.key("PredictEndpoint").value(predictRequest.getPredictEndpoint());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

