/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.LifecycleEventConfiguration;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateLayerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String layerId;
    private String name;
    private String shortname;
    private Map<String, String> attributes;
    private String customInstanceProfileArn;
    private String customJson;
    private ListWithAutoConstructFlag<String> customSecurityGroupIds;
    private ListWithAutoConstructFlag<String> packages;
    private ListWithAutoConstructFlag<VolumeConfiguration> volumeConfigurations;
    private Boolean enableAutoHealing;
    private Boolean autoAssignElasticIps;
    private Boolean autoAssignPublicIps;
    private Recipes customRecipes;
    private Boolean installUpdatesOnBoot;
    private Boolean useEbsOptimizedInstances;
    private LifecycleEventConfiguration lifecycleEventConfiguration;

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public UpdateLayerRequest withLayerId(String layerId) {
        this.layerId = layerId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateLayerRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public UpdateLayerRequest withShortname(String shortname) {
        this.shortname = shortname;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public UpdateLayerRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public UpdateLayerRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public UpdateLayerRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String getCustomInstanceProfileArn() {
        return this.customInstanceProfileArn;
    }

    public void setCustomInstanceProfileArn(String customInstanceProfileArn) {
        this.customInstanceProfileArn = customInstanceProfileArn;
    }

    public UpdateLayerRequest withCustomInstanceProfileArn(String customInstanceProfileArn) {
        this.customInstanceProfileArn = customInstanceProfileArn;
        return this;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public UpdateLayerRequest withCustomJson(String customJson) {
        this.customJson = customJson;
        return this;
    }

    public List<String> getCustomSecurityGroupIds() {
        if (this.customSecurityGroupIds == null) {
            this.customSecurityGroupIds = new ListWithAutoConstructFlag();
            this.customSecurityGroupIds.setAutoConstruct(true);
        }
        return this.customSecurityGroupIds;
    }

    public void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
        if (customSecurityGroupIds == null) {
            this.customSecurityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag customSecurityGroupIdsCopy = new ListWithAutoConstructFlag(customSecurityGroupIds.size());
        customSecurityGroupIdsCopy.addAll(customSecurityGroupIds);
        this.customSecurityGroupIds = customSecurityGroupIdsCopy;
    }

    public UpdateLayerRequest withCustomSecurityGroupIds(String ... customSecurityGroupIds) {
        if (this.getCustomSecurityGroupIds() == null) {
            this.setCustomSecurityGroupIds(new ArrayList<String>(customSecurityGroupIds.length));
        }
        for (String value : customSecurityGroupIds) {
            this.getCustomSecurityGroupIds().add(value);
        }
        return this;
    }

    public UpdateLayerRequest withCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
        if (customSecurityGroupIds == null) {
            this.customSecurityGroupIds = null;
        } else {
            ListWithAutoConstructFlag customSecurityGroupIdsCopy = new ListWithAutoConstructFlag(customSecurityGroupIds.size());
            customSecurityGroupIdsCopy.addAll(customSecurityGroupIds);
            this.customSecurityGroupIds = customSecurityGroupIdsCopy;
        }
        return this;
    }

    public List<String> getPackages() {
        if (this.packages == null) {
            this.packages = new ListWithAutoConstructFlag();
            this.packages.setAutoConstruct(true);
        }
        return this.packages;
    }

    public void setPackages(Collection<String> packages) {
        if (packages == null) {
            this.packages = null;
            return;
        }
        ListWithAutoConstructFlag packagesCopy = new ListWithAutoConstructFlag(packages.size());
        packagesCopy.addAll(packages);
        this.packages = packagesCopy;
    }

    public UpdateLayerRequest withPackages(String ... packages) {
        if (this.getPackages() == null) {
            this.setPackages(new ArrayList<String>(packages.length));
        }
        for (String value : packages) {
            this.getPackages().add(value);
        }
        return this;
    }

    public UpdateLayerRequest withPackages(Collection<String> packages) {
        if (packages == null) {
            this.packages = null;
        } else {
            ListWithAutoConstructFlag packagesCopy = new ListWithAutoConstructFlag(packages.size());
            packagesCopy.addAll(packages);
            this.packages = packagesCopy;
        }
        return this;
    }

    public List<VolumeConfiguration> getVolumeConfigurations() {
        if (this.volumeConfigurations == null) {
            this.volumeConfigurations = new ListWithAutoConstructFlag();
            this.volumeConfigurations.setAutoConstruct(true);
        }
        return this.volumeConfigurations;
    }

    public void setVolumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
        if (volumeConfigurations == null) {
            this.volumeConfigurations = null;
            return;
        }
        ListWithAutoConstructFlag volumeConfigurationsCopy = new ListWithAutoConstructFlag(volumeConfigurations.size());
        volumeConfigurationsCopy.addAll(volumeConfigurations);
        this.volumeConfigurations = volumeConfigurationsCopy;
    }

    public UpdateLayerRequest withVolumeConfigurations(VolumeConfiguration ... volumeConfigurations) {
        if (this.getVolumeConfigurations() == null) {
            this.setVolumeConfigurations(new ArrayList<VolumeConfiguration>(volumeConfigurations.length));
        }
        for (VolumeConfiguration value : volumeConfigurations) {
            this.getVolumeConfigurations().add(value);
        }
        return this;
    }

    public UpdateLayerRequest withVolumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
        if (volumeConfigurations == null) {
            this.volumeConfigurations = null;
        } else {
            ListWithAutoConstructFlag volumeConfigurationsCopy = new ListWithAutoConstructFlag(volumeConfigurations.size());
            volumeConfigurationsCopy.addAll(volumeConfigurations);
            this.volumeConfigurations = volumeConfigurationsCopy;
        }
        return this;
    }

    public Boolean isEnableAutoHealing() {
        return this.enableAutoHealing;
    }

    public void setEnableAutoHealing(Boolean enableAutoHealing) {
        this.enableAutoHealing = enableAutoHealing;
    }

    public UpdateLayerRequest withEnableAutoHealing(Boolean enableAutoHealing) {
        this.enableAutoHealing = enableAutoHealing;
        return this;
    }

    public Boolean getEnableAutoHealing() {
        return this.enableAutoHealing;
    }

    public Boolean isAutoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
        this.autoAssignElasticIps = autoAssignElasticIps;
    }

    public UpdateLayerRequest withAutoAssignElasticIps(Boolean autoAssignElasticIps) {
        this.autoAssignElasticIps = autoAssignElasticIps;
        return this;
    }

    public Boolean getAutoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public Boolean isAutoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
        this.autoAssignPublicIps = autoAssignPublicIps;
    }

    public UpdateLayerRequest withAutoAssignPublicIps(Boolean autoAssignPublicIps) {
        this.autoAssignPublicIps = autoAssignPublicIps;
        return this;
    }

    public Boolean getAutoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public Recipes getCustomRecipes() {
        return this.customRecipes;
    }

    public void setCustomRecipes(Recipes customRecipes) {
        this.customRecipes = customRecipes;
    }

    public UpdateLayerRequest withCustomRecipes(Recipes customRecipes) {
        this.customRecipes = customRecipes;
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public UpdateLayerRequest withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
        return this;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean isUseEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
        this.useEbsOptimizedInstances = useEbsOptimizedInstances;
    }

    public UpdateLayerRequest withUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
        this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        return this;
    }

    public Boolean getUseEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public LifecycleEventConfiguration getLifecycleEventConfiguration() {
        return this.lifecycleEventConfiguration;
    }

    public void setLifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
        this.lifecycleEventConfiguration = lifecycleEventConfiguration;
    }

    public UpdateLayerRequest withLifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
        this.lifecycleEventConfiguration = lifecycleEventConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLayerId() != null) {
            sb.append("LayerId: " + this.getLayerId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getShortname() != null) {
            sb.append("Shortname: " + this.getShortname() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getCustomInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: " + this.getCustomInstanceProfileArn() + ",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: " + this.getCustomJson() + ",");
        }
        if (this.getCustomSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: " + this.getCustomSecurityGroupIds() + ",");
        }
        if (this.getPackages() != null) {
            sb.append("Packages: " + this.getPackages() + ",");
        }
        if (this.getVolumeConfigurations() != null) {
            sb.append("VolumeConfigurations: " + this.getVolumeConfigurations() + ",");
        }
        if (this.isEnableAutoHealing() != null) {
            sb.append("EnableAutoHealing: " + this.isEnableAutoHealing() + ",");
        }
        if (this.isAutoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: " + this.isAutoAssignElasticIps() + ",");
        }
        if (this.isAutoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: " + this.isAutoAssignPublicIps() + ",");
        }
        if (this.getCustomRecipes() != null) {
            sb.append("CustomRecipes: " + this.getCustomRecipes() + ",");
        }
        if (this.isInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: " + this.isInstallUpdatesOnBoot() + ",");
        }
        if (this.isUseEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: " + this.isUseEbsOptimizedInstances() + ",");
        }
        if (this.getLifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: " + this.getLifecycleEventConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLayerId() == null ? 0 : this.getLayerId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getShortname() == null ? 0 : this.getShortname().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCustomInstanceProfileArn() == null ? 0 : this.getCustomInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        hashCode = 31 * hashCode + (this.getCustomSecurityGroupIds() == null ? 0 : this.getCustomSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPackages() == null ? 0 : this.getPackages().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeConfigurations() == null ? 0 : this.getVolumeConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.isEnableAutoHealing() == null ? 0 : this.isEnableAutoHealing().hashCode());
        hashCode = 31 * hashCode + (this.isAutoAssignElasticIps() == null ? 0 : this.isAutoAssignElasticIps().hashCode());
        hashCode = 31 * hashCode + (this.isAutoAssignPublicIps() == null ? 0 : this.isAutoAssignPublicIps().hashCode());
        hashCode = 31 * hashCode + (this.getCustomRecipes() == null ? 0 : this.getCustomRecipes().hashCode());
        hashCode = 31 * hashCode + (this.isInstallUpdatesOnBoot() == null ? 0 : this.isInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.isUseEbsOptimizedInstances() == null ? 0 : this.isUseEbsOptimizedInstances().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleEventConfiguration() == null ? 0 : this.getLifecycleEventConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLayerRequest)) {
            return false;
        }
        UpdateLayerRequest other = (UpdateLayerRequest)obj;
        if (other.getLayerId() == null ^ this.getLayerId() == null) {
            return false;
        }
        if (other.getLayerId() != null && !other.getLayerId().equals(this.getLayerId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getShortname() == null ^ this.getShortname() == null) {
            return false;
        }
        if (other.getShortname() != null && !other.getShortname().equals(this.getShortname())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getCustomInstanceProfileArn() == null ^ this.getCustomInstanceProfileArn() == null) {
            return false;
        }
        if (other.getCustomInstanceProfileArn() != null && !other.getCustomInstanceProfileArn().equals(this.getCustomInstanceProfileArn())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        if (other.getCustomJson() != null && !other.getCustomJson().equals(this.getCustomJson())) {
            return false;
        }
        if (other.getCustomSecurityGroupIds() == null ^ this.getCustomSecurityGroupIds() == null) {
            return false;
        }
        if (other.getCustomSecurityGroupIds() != null && !other.getCustomSecurityGroupIds().equals(this.getCustomSecurityGroupIds())) {
            return false;
        }
        if (other.getPackages() == null ^ this.getPackages() == null) {
            return false;
        }
        if (other.getPackages() != null && !other.getPackages().equals(this.getPackages())) {
            return false;
        }
        if (other.getVolumeConfigurations() == null ^ this.getVolumeConfigurations() == null) {
            return false;
        }
        if (other.getVolumeConfigurations() != null && !other.getVolumeConfigurations().equals(this.getVolumeConfigurations())) {
            return false;
        }
        if (other.isEnableAutoHealing() == null ^ this.isEnableAutoHealing() == null) {
            return false;
        }
        if (other.isEnableAutoHealing() != null && !other.isEnableAutoHealing().equals(this.isEnableAutoHealing())) {
            return false;
        }
        if (other.isAutoAssignElasticIps() == null ^ this.isAutoAssignElasticIps() == null) {
            return false;
        }
        if (other.isAutoAssignElasticIps() != null && !other.isAutoAssignElasticIps().equals(this.isAutoAssignElasticIps())) {
            return false;
        }
        if (other.isAutoAssignPublicIps() == null ^ this.isAutoAssignPublicIps() == null) {
            return false;
        }
        if (other.isAutoAssignPublicIps() != null && !other.isAutoAssignPublicIps().equals(this.isAutoAssignPublicIps())) {
            return false;
        }
        if (other.getCustomRecipes() == null ^ this.getCustomRecipes() == null) {
            return false;
        }
        if (other.getCustomRecipes() != null && !other.getCustomRecipes().equals(this.getCustomRecipes())) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() == null ^ this.isInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() != null && !other.isInstallUpdatesOnBoot().equals(this.isInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.isUseEbsOptimizedInstances() == null ^ this.isUseEbsOptimizedInstances() == null) {
            return false;
        }
        if (other.isUseEbsOptimizedInstances() != null && !other.isUseEbsOptimizedInstances().equals(this.isUseEbsOptimizedInstances())) {
            return false;
        }
        if (other.getLifecycleEventConfiguration() == null ^ this.getLifecycleEventConfiguration() == null) {
            return false;
        }
        return other.getLifecycleEventConfiguration() == null || other.getLifecycleEventConfiguration().equals(this.getLifecycleEventConfiguration());
    }

    @Override
    public UpdateLayerRequest clone() {
        return (UpdateLayerRequest)super.clone();
    }
}

