/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.CreateDeploymentRequest;
import com.amazonaws.services.opsworks.model.DeploymentCommand;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    @Override
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentRequest> request = new DefaultRequest<CreateDeploymentRequest>(createDeploymentRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateDeployment";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            DeploymentCommand command;
            ListWithAutoConstructFlag instanceIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDeploymentRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createDeploymentRequest.getStackId());
            }
            if (createDeploymentRequest.getAppId() != null) {
                jsonWriter.key("AppId").value(createDeploymentRequest.getAppId());
            }
            if (!((instanceIdsList = (ListWithAutoConstructFlag)createDeploymentRequest.getInstanceIds()) == null || instanceIdsList.isAutoConstruct() && instanceIdsList.isEmpty())) {
                jsonWriter.key("InstanceIds");
                jsonWriter.array();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonWriter.value(instanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if ((command = createDeploymentRequest.getCommand()) != null) {
                jsonWriter.key("Command");
                jsonWriter.object();
                if (command.getName() != null) {
                    jsonWriter.key("Name").value(command.getName());
                }
                if (command.getArgs() != null) {
                    jsonWriter.key("Args");
                    jsonWriter.object();
                    for (Map.Entry<String, List<String>> argsListValue : command.getArgs().entrySet()) {
                        if (argsListValue.getValue() == null) continue;
                        jsonWriter.key(argsListValue.getKey());
                        jsonWriter.array();
                        for (String valueListValue : argsListValue.getValue()) {
                            if (valueListValue == null) continue;
                            jsonWriter.value(valueListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (createDeploymentRequest.getComment() != null) {
                jsonWriter.key("Comment").value(createDeploymentRequest.getComment());
            }
            if (createDeploymentRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value(createDeploymentRequest.getCustomJson());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

