/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.InstanceIdentity;
import com.amazonaws.services.opsworks.model.RegisterInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RegisterInstanceRequestMarshaller
implements Marshaller<Request<RegisterInstanceRequest>, RegisterInstanceRequest> {
    @Override
    public Request<RegisterInstanceRequest> marshall(RegisterInstanceRequest registerInstanceRequest) {
        if (registerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterInstanceRequest> request = new DefaultRequest<RegisterInstanceRequest>(registerInstanceRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.RegisterInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            InstanceIdentity instanceIdentity;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (registerInstanceRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(registerInstanceRequest.getStackId());
            }
            if (registerInstanceRequest.getHostname() != null) {
                jsonWriter.key("Hostname").value(registerInstanceRequest.getHostname());
            }
            if (registerInstanceRequest.getPublicIp() != null) {
                jsonWriter.key("PublicIp").value(registerInstanceRequest.getPublicIp());
            }
            if (registerInstanceRequest.getPrivateIp() != null) {
                jsonWriter.key("PrivateIp").value(registerInstanceRequest.getPrivateIp());
            }
            if (registerInstanceRequest.getRsaPublicKey() != null) {
                jsonWriter.key("RsaPublicKey").value(registerInstanceRequest.getRsaPublicKey());
            }
            if (registerInstanceRequest.getRsaPublicKeyFingerprint() != null) {
                jsonWriter.key("RsaPublicKeyFingerprint").value(registerInstanceRequest.getRsaPublicKeyFingerprint());
            }
            if ((instanceIdentity = registerInstanceRequest.getInstanceIdentity()) != null) {
                jsonWriter.key("InstanceIdentity");
                jsonWriter.object();
                if (instanceIdentity.getDocument() != null) {
                    jsonWriter.key("Document").value(instanceIdentity.getDocument());
                }
                if (instanceIdentity.getSignature() != null) {
                    jsonWriter.key("Signature").value(instanceIdentity.getSignature());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

