/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.DescribeDBLogFilesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDBLogFilesRequestMarshaller
implements Marshaller<Request<DescribeDBLogFilesRequest>, DescribeDBLogFilesRequest> {
    @Override
    public Request<DescribeDBLogFilesRequest> marshall(DescribeDBLogFilesRequest describeDBLogFilesRequest) {
        if (describeDBLogFilesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDBLogFilesRequest> request = new DefaultRequest<DescribeDBLogFilesRequest>(describeDBLogFilesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBLogFiles");
        request.addParameter("Version", "2014-10-31");
        if (describeDBLogFilesRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(describeDBLogFilesRequest.getDBInstanceIdentifier()));
        }
        if (describeDBLogFilesRequest.getFilenameContains() != null) {
            request.addParameter("FilenameContains", StringUtils.fromString(describeDBLogFilesRequest.getFilenameContains()));
        }
        if (describeDBLogFilesRequest.getFileLastWritten() != null) {
            request.addParameter("FileLastWritten", StringUtils.fromLong(describeDBLogFilesRequest.getFileLastWritten()));
        }
        if (describeDBLogFilesRequest.getFileSize() != null) {
            request.addParameter("FileSize", StringUtils.fromLong(describeDBLogFilesRequest.getFileSize()));
        }
        List<Filter> filtersList = describeDBLogFilesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeDBLogFilesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeDBLogFilesRequest.getMaxRecords()));
        }
        if (describeDBLogFilesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeDBLogFilesRequest.getMarker()));
        }
        return request;
    }
}

