/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDocumentsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<DocumentIdentifier> documentIdentifiers;
    private String nextToken;

    public List<DocumentIdentifier> getDocumentIdentifiers() {
        if (this.documentIdentifiers == null) {
            this.documentIdentifiers = new ListWithAutoConstructFlag();
            this.documentIdentifiers.setAutoConstruct(true);
        }
        return this.documentIdentifiers;
    }

    public void setDocumentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
        if (documentIdentifiers == null) {
            this.documentIdentifiers = null;
            return;
        }
        ListWithAutoConstructFlag documentIdentifiersCopy = new ListWithAutoConstructFlag(documentIdentifiers.size());
        documentIdentifiersCopy.addAll(documentIdentifiers);
        this.documentIdentifiers = documentIdentifiersCopy;
    }

    public ListDocumentsResult withDocumentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
        if (this.getDocumentIdentifiers() == null) {
            this.setDocumentIdentifiers(new ArrayList<DocumentIdentifier>(documentIdentifiers.length));
        }
        for (DocumentIdentifier value : documentIdentifiers) {
            this.getDocumentIdentifiers().add(value);
        }
        return this;
    }

    public ListDocumentsResult withDocumentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
        if (documentIdentifiers == null) {
            this.documentIdentifiers = null;
        } else {
            ListWithAutoConstructFlag documentIdentifiersCopy = new ListWithAutoConstructFlag(documentIdentifiers.size());
            documentIdentifiersCopy.addAll(documentIdentifiers);
            this.documentIdentifiers = documentIdentifiersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDocumentsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentIdentifiers() != null) {
            sb.append("DocumentIdentifiers: " + this.getDocumentIdentifiers() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentIdentifiers() == null ? 0 : this.getDocumentIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResult)) {
            return false;
        }
        ListDocumentsResult other = (ListDocumentsResult)obj;
        if (other.getDocumentIdentifiers() == null ^ this.getDocumentIdentifiers() == null) {
            return false;
        }
        if (other.getDocumentIdentifiers() != null && !other.getDocumentIdentifiers().equals(this.getDocumentIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListDocumentsResult clone() {
        try {
            return (ListDocumentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

