/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClientExternalImpl;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;

public abstract class WorkflowClientExternalBase
implements WorkflowClientExternal {
    private static boolean BOOLEAN_DEFAULT = false;
    private static byte BYTE_DEFAULT = 0;
    private static char CHARACTER_DEFAULT = '\u0000';
    private static short SHORT_DEFAULT = 0;
    private static int INTEGER_DEFAULT = 0;
    private static long LONG_DEFAULT = 0L;
    private static float FLOAT_DEFAULT = 0.0f;
    private static double DOUBLE_DEFAULT = 0.0;
    protected final DynamicWorkflowClientExternal dynamicWorkflowClient;

    public WorkflowClientExternalBase(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options, DataConverter dataConverter, GenericWorkflowClientExternal genericClient) {
        this.dynamicWorkflowClient = new DynamicWorkflowClientExternalImpl(workflowExecution, workflowType, options, dataConverter, genericClient);
    }

    @Override
    public void requestCancelWorkflowExecution() {
        this.dynamicWorkflowClient.requestCancelWorkflowExecution();
    }

    @Override
    public void terminateWorkflowExecution(String reason, String details, ChildPolicy childPolicy) {
        this.dynamicWorkflowClient.terminateWorkflowExecution(reason, details, childPolicy);
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dynamicWorkflowClient.getDataConverter();
    }

    @Override
    public StartWorkflowOptions getSchedulingOptions() {
        return this.dynamicWorkflowClient.getSchedulingOptions();
    }

    @Override
    public GenericWorkflowClientExternal getGenericClient() {
        return this.dynamicWorkflowClient.getGenericClient();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.dynamicWorkflowClient.getWorkflowExecution();
    }

    protected void startWorkflowExecution(Object[] arguments, StartWorkflowOptions startOptionsOverride) {
        this.dynamicWorkflowClient.startWorkflowExecution(arguments, startOptionsOverride);
    }

    protected void startWorkflowExecution(Object[] arguments) {
        this.dynamicWorkflowClient.startWorkflowExecution(arguments);
    }

    protected void signalWorkflowExecution(String signalName, Object[] arguments) {
        this.dynamicWorkflowClient.signalWorkflowExecution(signalName, arguments);
    }

    protected <T> T defaultPrimitiveValue(Class<T> clazz) {
        Comparable<Boolean> returnValue = null;
        if (clazz.equals(Boolean.TYPE)) {
            returnValue = BOOLEAN_DEFAULT;
        } else if (clazz.equals(Byte.TYPE)) {
            returnValue = BYTE_DEFAULT;
        } else if (clazz.equals(Character.TYPE)) {
            returnValue = Character.valueOf(CHARACTER_DEFAULT);
        } else if (clazz.equals(Short.TYPE)) {
            returnValue = SHORT_DEFAULT;
        } else if (clazz.equals(Integer.TYPE)) {
            returnValue = INTEGER_DEFAULT;
        } else if (clazz.equals(Long.TYPE)) {
            returnValue = LONG_DEFAULT;
        } else if (clazz.equals(Float.TYPE)) {
            returnValue = Float.valueOf(FLOAT_DEFAULT);
        } else if (clazz.equals(Double.TYPE)) {
            returnValue = DOUBLE_DEFAULT;
        } else {
            throw new IllegalArgumentException("Type not supported: " + clazz);
        }
        return (T)returnValue;
    }
}

