/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.auth.policy.conditions.ConditionFactory;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.HashMap;
import java.util.Map;

public class Topics {
    public static String subscribeQueue(AmazonSNS sns, AmazonSQS sqs, String snsTopicArn, String sqsQueueUrl) throws AmazonClientException, AmazonServiceException {
        Map<String, String> queueAttributes = sqs.getQueueAttributes(new GetQueueAttributesRequest(sqsQueueUrl).withAttributeNames(QueueAttributeName.QueueArn.toString())).getAttributes();
        String sqsQueueArn = queueAttributes.get(QueueAttributeName.QueueArn.toString());
        Policy policy = new Policy().withStatements(new Statement(Statement.Effect.Allow).withId("topic-subscription-" + snsTopicArn).withPrincipals(Principal.AllUsers).withActions(SQSActions.SendMessage).withResources(new Resource(sqsQueueArn)).withConditions(ConditionFactory.newSourceArnCondition(snsTopicArn)));
        System.out.println("Policy: " + policy.toJson());
        queueAttributes = new HashMap<String, String>();
        queueAttributes.put(QueueAttributeName.Policy.toString(), policy.toJson());
        sqs.setQueueAttributes(new SetQueueAttributesRequest(sqsQueueUrl, queueAttributes));
        SubscribeResult subscribeResult = sns.subscribe(new SubscribeRequest().withEndpoint(sqsQueueArn).withProtocol("sqs").withTopicArn(snsTopicArn));
        return subscribeResult.getSubscriptionArn();
    }
}

