/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.Workspace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeWorkspacesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Workspace> workspaces;
    private String nextToken;

    public List<Workspace> getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new ListWithAutoConstructFlag();
            this.workspaces.setAutoConstruct(true);
        }
        return this.workspaces;
    }

    public void setWorkspaces(Collection<Workspace> workspaces) {
        if (workspaces == null) {
            this.workspaces = null;
            return;
        }
        ListWithAutoConstructFlag workspacesCopy = new ListWithAutoConstructFlag(workspaces.size());
        workspacesCopy.addAll(workspaces);
        this.workspaces = workspacesCopy;
    }

    public DescribeWorkspacesResult withWorkspaces(Workspace ... workspaces) {
        if (this.getWorkspaces() == null) {
            this.setWorkspaces(new ArrayList<Workspace>(workspaces.length));
        }
        for (Workspace value : workspaces) {
            this.getWorkspaces().add(value);
        }
        return this;
    }

    public DescribeWorkspacesResult withWorkspaces(Collection<Workspace> workspaces) {
        if (workspaces == null) {
            this.workspaces = null;
        } else {
            ListWithAutoConstructFlag workspacesCopy = new ListWithAutoConstructFlag(workspaces.size());
            workspacesCopy.addAll(workspaces);
            this.workspaces = workspacesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeWorkspacesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaces() != null) {
            sb.append("Workspaces: " + this.getWorkspaces() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaces() == null ? 0 : this.getWorkspaces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesResult)) {
            return false;
        }
        DescribeWorkspacesResult other = (DescribeWorkspacesResult)obj;
        if (other.getWorkspaces() == null ^ this.getWorkspaces() == null) {
            return false;
        }
        if (other.getWorkspaces() != null && !other.getWorkspaces().equals(this.getWorkspaces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeWorkspacesResult clone() {
        try {
            return (DescribeWorkspacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

