/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.ui.ActiveBatchTable;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.CompletedBatchTable;
import org.apache.spark.streaming.ui.MillisecondsStatUIData;
import org.apache.spark.streaming.ui.RecordRateUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.streaming.ui.StreamingPage$;
import org.apache.spark.streaming.ui.StreamingTab;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.ui.GraphUIData;
import org.apache.spark.ui.GraphUIData$;
import org.apache.spark.ui.JsCollector;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\re!\u0002\u000e\u001c\u0001m)\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000b]\u0002A\u0011\u0001\u001d\t\u000fm\u0002!\u0019!C\u0005y!1\u0001\t\u0001Q\u0001\nuBQ!\u0011\u0001\u0005\n\tCQ!\u0013\u0001\u0005\u0002)CQ!\u001b\u0001\u0005\n)DQ\u0001\u001c\u0001\u0005\n5DQA\u001c\u0001\u0005\n5DQa\u001c\u0001\u0005\nADQ\u0001\u001e\u0001\u0005\nUDQa\u001e\u0001\u0005\n5DQ\u0001\u001f\u0001\u0005\neDq!!\u0006\u0001\t\u0013\t9\u0002\u0003\u0004\u0002:\u0001!I!\\\u0004\t\u0003wY\u0002\u0012A\u000e\u0002>\u00199!d\u0007E\u00017\u0005}\u0002BB\u001c\u0012\t\u0003\t9\u0005C\u0005\u0002JE\u0011\r\u0011\"\u0001\u0002L!A\u0011QL\t!\u0002\u0013\ti\u0005C\u0005\u0002`E\u0011\r\u0011\"\u0001\u0002L!A\u0011\u0011M\t!\u0002\u0013\ti\u0005C\u0005\u0002dE\u0011\r\u0011\"\u0001\u0002L!A\u0011QM\t!\u0002\u0013\ti\u0005C\u0004\u0002hE!\t!!\u001b\u0003\u001bM#(/Z1nS:<\u0007+Y4f\u0015\taR$\u0001\u0002vS*\u0011adH\u0001\ngR\u0014X-Y7j]\u001eT!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\n\u0004\u0001\u0019Z\u0003CA\u0014*\u001b\u0005A#B\u0001\u000f \u0013\tQ\u0003FA\u0005XK\n,\u0016\nU1hKB\u0011AfL\u0007\u0002[)\u0011afH\u0001\tS:$XM\u001d8bY&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0001\u0018M]3oi\u000e\u0001\u0001C\u0001\u001b6\u001b\u0005Y\u0012B\u0001\u001c\u001c\u00051\u0019FO]3b[&tw\rV1c\u0003\u0019a\u0014N\\5u}Q\u0011\u0011H\u000f\t\u0003i\u0001AQ!\r\u0002A\u0002M\n\u0001\u0002\\5ti\u0016tWM]\u000b\u0002{A\u0011AGP\u0005\u0003\u007fm\u0011Ad\u0015;sK\u0006l\u0017N\\4K_\n\u0004&o\\4sKN\u001cH*[:uK:,'/A\u0005mSN$XM\\3sA\u0005I1\u000f^1siRKW.Z\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n!Aj\u001c8h\u0003\u0019\u0011XM\u001c3feR\u00111*\u0018\t\u0004\u0019R;fBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001&'\u0001\u0004=e>|GOP\u0005\u0002\r&\u00111+R\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!aU#\u0011\u0005a[V\"A-\u000b\u0005i+\u0015a\u0001=nY&\u0011A,\u0017\u0002\u0005\u001d>$W\rC\u0003_\r\u0001\u0007q,A\u0004sKF,Xm\u001d;\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00025uiBT!\u0001Z3\u0002\u000fM,'O\u001e7fi*\ta-A\u0003kCZ\f\u00070\u0003\u0002iC\n\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0003U9WM\\3sCR,Gj\\1e%\u0016\u001cx.\u001e:dKN$\"aS6\t\u000by;\u0001\u0019A0\u0002?\u001d,g.\u001a:bi\u0016|en\u00117jG.$\u0016.\\3mS:,g)\u001e8di&|g\u000eF\u0001L\u0003E9WM\\3sCR,')Y:jG&sgm\\\u0001\u0010O\u0016tWM]1uKRKW.Z'baR\u00111*\u001d\u0005\u0006e*\u0001\ra]\u0001\u0006i&lWm\u001d\t\u0004\u0019R\u001b\u0015AF4f]\u0016\u0014\u0018\r^3US6,G+\u001b9TiJLgnZ:\u0015\u0005-3\b\"\u0002:\f\u0001\u0004\u0019\u0018!E4f]\u0016\u0014\u0018\r^3Ti\u0006$H+\u00192mK\u0006Qr-\u001a8fe\u0006$X-\u00138qkR$5\u000b\u001e:fC6\u001cH+\u00192mKRI1J_@\u0002\u0004\u0005\u001d\u0011\u0011\u0003\u0005\u0006w6\u0001\r\u0001`\u0001\fUN\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002({&\u0011a\u0010\u000b\u0002\f\u0015N\u001cu\u000e\u001c7fGR|'\u000f\u0003\u0004\u0002\u00025\u0001\raQ\u0001\u0005[&t\u0007\f\u0003\u0004\u0002\u00065\u0001\raQ\u0001\u0005[\u0006D\b\fC\u0004\u0002\n5\u0001\r!a\u0003\u0002\t5Lg.\u0017\t\u0004\t\u00065\u0011bAA\b\u000b\n1Ai\\;cY\u0016Dq!a\u0005\u000e\u0001\u0004\tY!\u0001\u0003nCbL\u0016aF4f]\u0016\u0014\u0018\r^3J]B,H\u000fR*ue\u0016\fWNU8x)=Y\u0015\u0011DA\u000e\u0003K\t\t$a\r\u00026\u0005]\u0002\"B>\u000f\u0001\u0004a\bbBA\u000f\u001d\u0001\u0007\u0011qD\u0001\tgR\u0014X-Y7JIB\u0019A)!\t\n\u0007\u0005\rRIA\u0002J]RDq!a\n\u000f\u0001\u0004\tI#A\u0006sK\u000e|'\u000f\u001a*bi\u0016\u001c\b\u0003\u0002'U\u0003W\u0001b\u0001RA\u0017\u0007\u0006-\u0011bAA\u0018\u000b\n1A+\u001e9mKJBa!!\u0001\u000f\u0001\u0004\u0019\u0005BBA\u0003\u001d\u0001\u00071\tC\u0004\u0002\n9\u0001\r!a\u0003\t\u000f\u0005Ma\u00021\u0001\u0002\f\u00059r-\u001a8fe\u0006$XMQ1uG\"d\u0015n\u001d;UC\ndWm]\u0001\u000e'R\u0014X-Y7j]\u001e\u0004\u0016mZ3\u0011\u0005Q\n2cA\t\u0002BA\u0019A)a\u0011\n\u0007\u0005\u0015SI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003{\t\u0011D\u0011'B\u0007.{&+S$I)~#&+S!O\u000f2+u\f\u0013+N\u0019V\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002R\t11\u000b\u001e:j]\u001e\f!D\u0011'B\u0007.{&+S$I)~#&+S!O\u000f2+u\f\u0013+N\u0019\u0002\n\u0001D\u0011'B\u0007.{FiT,O?R\u0013\u0016*\u0011(H\u0019\u0016{\u0006\nV'M\u0003e\u0011E*Q\"L?\u0012{uKT0U%&\u000bej\u0012'F?\"#V\n\u0014\u0011\u0002\u0013\u0015l\u0007\u000f^=DK2d\u0017AC3naRL8)\u001a7mA\u0005!bm\u001c:nCR$UO]1uS>tw\n\u001d;j_:$B!a\u001b\u0002zA!\u0011QNA;\u001d\u0011\ty'!\u001d\u0011\u00059+\u0015bAA:\u000b\u00061\u0001K]3eK\u001aLA!a\u0017\u0002x)\u0019\u00111O#\t\u000f\u0005m\u0014\u00041\u0001\u0002~\u0005AQn](qi&|g\u000e\u0005\u0003E\u0003\u007f\u001a\u0015bAAA\u000b\n1q\n\u001d;j_:\u0004")
public class StreamingPage
extends WebUIPage
implements Logging {
    private final StreamingTab parent;
    private final StreamingJobProgressListener listener;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String formatDurationOption(Option<Object> option) {
        return StreamingPage$.MODULE$.formatDurationOption(option);
    }

    public static String emptyCell() {
        return StreamingPage$.MODULE$.emptyCell();
    }

    public static String BLACK_DOWN_TRIANGLE_HTML() {
        return StreamingPage$.MODULE$.BLACK_DOWN_TRIANGLE_HTML();
    }

    public static String BLACK_RIGHT_TRIANGLE_HTML() {
        return StreamingPage$.MODULE$.BLACK_RIGHT_TRIANGLE_HTML();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StreamingJobProgressListener listener() {
        return this.listener;
    }

    private long startTime() {
        return this.listener().startTime();
    }

    public Seq<Node> render(HttpServletRequest request) {
        Seq seq;
        Seq<Node> resources = this.generateLoadResources(request);
        Seq<Node> onClickTimelineFunc = this.generateOnClickTimelineFunction();
        Seq<Node> basicInfo = this.generateBasicInfo();
        StreamingJobProgressListener streamingJobProgressListener = this.listener();
        synchronized (streamingJobProgressListener) {
            seq = (Seq)this.generateStatTable().$plus$plus(this.generateBatchListTables(), Seq$.MODULE$.canBuildFrom());
        }
        Seq content = (Seq)((TraversableLike)((TraversableLike)resources.$plus$plus(onClickTimelineFunc, Seq$.MODULE$.canBuildFrom())).$plus$plus(basicInfo, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)seq, Seq$.MODULE$.canBuildFrom());
        return org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Streaming Statistics", (Function0 & Serializable & scala.Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateLoadResources(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/d3.min.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.css", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateOnClickTimelineFunction() {
        void var2_2;
        String js = "onClickTimeline = getOnClickTimelineFunction();";
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateBasicInfo() {
        void var3_2;
        long timeSinceStart = System.currentTimeMillis() - this.startTime();
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Running batches of\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(this.listener().batchDuration()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      for\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      since\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n      ("));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalCompletedBatches()));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf2.$amp$plus((Object)new Text("\n      completed batches, "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalReceivedRecords()));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf2.$amp$plus((Object)new Text(" records)\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateTimeMap(Seq<Object> times) {
        void var3_3;
        String js = new StringBuilder(21).append("var timeFormat = {};\n").append(((TraversableOnce)times.map((Function1 & Serializable & scala.Serializable)time -> StreamingPage.$anonfun$generateTimeMap$1(this, BoxesRunTime.unboxToLong((Object)time)), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> generateTimeTipStrings(Seq<Object> times) {
        void var3_3;
        String js = new StringBuilder(25).append("var timeTipStrings = {};\n").append(((TraversableOnce)times.map((Function1 & Serializable & scala.Serializable)time -> StreamingPage.$anonfun$generateTimeTipStrings$1(BoxesRunTime.unboxToLong((Object)time)), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Seq<Node> generateStatTable() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Elem elem;
        Seq<BatchUIData> batches = this.listener().retainedBatches();
        Seq batchTimes = (Seq)batches.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateStatTable$1(x$6)), Seq$.MODULE$.canBuildFrom());
        long minBatchTime = batchTimes.isEmpty() ? this.startTime() : BoxesRunTime.unboxToLong((Object)batchTimes.min((Ordering)Ordering.Long$.MODULE$));
        long maxBatchTime = batchTimes.isEmpty() ? this.startTime() : BoxesRunTime.unboxToLong((Object)batchTimes.max((Ordering)Ordering.Long$.MODULE$));
        RecordRateUIData recordRateForAllStreams = new RecordRateUIData((Seq<Tuple2<Object, Object>>)((Seq)batches.map((Function1 & Serializable & scala.Serializable)batchInfo -> new Tuple2.mcJD.sp(batchInfo.batchTime().milliseconds(), (double)batchInfo.numRecords() * 1000.0 / (double)this.listener().batchDuration()), Seq$.MODULE$.canBuildFrom())));
        MillisecondsStatUIData schedulingDelay = new MillisecondsStatUIData((Seq<Tuple2<Object, Object>>)((Seq)batches.flatMap((Function1 & Serializable & scala.Serializable)batchInfo -> Option$.MODULE$.option2Iterable(batchInfo.schedulingDelay().map((Function1 & Serializable & scala.Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$7))))), Seq$.MODULE$.canBuildFrom())));
        MillisecondsStatUIData processingTime = new MillisecondsStatUIData((Seq<Tuple2<Object, Object>>)((Seq)batches.flatMap((Function1 & Serializable & scala.Serializable)batchInfo -> Option$.MODULE$.option2Iterable(batchInfo.processingDelay().map((Function1 & Serializable & scala.Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$8))))), Seq$.MODULE$.canBuildFrom())));
        MillisecondsStatUIData totalDelay = new MillisecondsStatUIData((Seq<Tuple2<Object, Object>>)((Seq)batches.flatMap((Function1 & Serializable & scala.Serializable)batchInfo -> Option$.MODULE$.option2Iterable(batchInfo.totalDelay().map((Function1 & Serializable & scala.Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$9))))), Seq$.MODULE$.canBuildFrom())));
        long _maxTime = BoxesRunTime.unboxToLong((Object)schedulingDelay.max().flatMap((Function1 & Serializable & scala.Serializable)m1 -> StreamingPage.$anonfun$generateStatTable$9(processingTime, totalDelay, BoxesRunTime.unboxToLong((Object)m1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        long minTime = 0L;
        Tuple2<Object, TimeUnit> tuple2 = UIUtils$.MODULE$.normalizeDuration(_maxTime);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double maxTime = tuple2._1$mcD$sp();
        TimeUnit normalizedUnit = (TimeUnit)((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)maxTime), (Object)normalizedUnit);
        Tuple2 tuple23 = tuple22;
        double maxTime2 = tuple23._1$mcD$sp();
        TimeUnit normalizedUnit2 = (TimeUnit)((Object)tuple23._2());
        String formattedUnit = UIUtils$.MODULE$.shortTimeUnitString(normalizedUnit2);
        long maxRecordRate = BoxesRunTime.unboxToLong((Object)recordRateForAllStreams.max().map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$11 -> (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(x$11))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        long minRecordRate = 0L;
        double batchInterval = UIUtils$.MODULE$.convertToTimeUnit(this.listener().batchDuration(), normalizedUnit2);
        JsCollector jsCollector = new JsCollector();
        GraphUIData graphUIDataForRecordRateOfAllStreams = new GraphUIData("all-stream-records-timeline", "all-stream-records-histogram", recordRateForAllStreams.data(), minBatchTime, maxBatchTime, (double)minRecordRate, (double)maxRecordRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForRecordRateOfAllStreams.generateDataJs(jsCollector);
        GraphUIData graphUIDataForSchedulingDelay = new GraphUIData("scheduling-delay-timeline", "scheduling-delay-histogram", schedulingDelay.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForSchedulingDelay.generateDataJs(jsCollector);
        GraphUIData graphUIDataForProcessingTime = new GraphUIData("processing-time-timeline", "processing-time-histogram", processingTime.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)batchInterval)));
        graphUIDataForProcessingTime.generateDataJs(jsCollector);
        GraphUIData graphUIDataForTotalDelay = new GraphUIData("total-delay-timeline", "total-delay-histogram", totalDelay.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForTotalDelay.generateDataJs(jsCollector);
        boolean hasStream = this.listener().streamIds().nonEmpty();
        int numCompletedBatches = this.listener().retainedCompletedBatches().size();
        int numActiveBatches = batchTimes.length() - numCompletedBatches;
        int numReceivers = this.listener().numInactiveReceivers() + this.listener().numActiveReceivers();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("stat-table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 492px;"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Timelines (Last "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)batchTimes.length()));
        $buf4.$amp$plus((Object)new Text(" batches, "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numActiveBatches));
        $buf4.$amp$plus((Object)new Text(" active, "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numCompletedBatches));
        $buf4.$amp$plus((Object)new Text(" completed)"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 350px;"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Histograms"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        if (hasStream) {
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("expand-input-rate"), (MetaData)$md7);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n                    "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("expand-input-rate-arrow arrow-closed"), (MetaData)$md8);
            $buf11.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf11.$amp$plus((Object)new Text("\n                    "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("title", (Seq)new Text("Show/hide details of each receiver"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md9);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n                      "));
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("Input Rate"));
            $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
            $buf12.$amp$plus((Object)new Text("\n                    "));
            $buf11.$amp$plus((Object)new Elem(null, "a", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
            $buf11.$amp$plus((Object)new Text("\n                  "));
            Elem elem2 = new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11);
            elem = elem2;
        } else {
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Input Rate"));
            Elem elem3 = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14);
            elem = elem3;
        }
        $buf10.$amp$plus((Object)elem);
        $buf10.$amp$plus((Object)new Text("\n              "));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n              "));
        if (numReceivers > 0) {
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("Receivers: "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.listener().numActiveReceivers()));
            $buf15.$amp$plus((Object)new Text(" / "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numReceivers));
            $buf15.$amp$plus((Object)new Text(" active"));
            Elem elem4 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
            boxedUnit2 = elem4;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf9.$amp$plus((Object)boxedUnit2);
        $buf9.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("Avg: "));
        $buf16.$amp$plus((Object)recordRateForAllStreams.formattedAvg());
        $buf16.$amp$plus((Object)new Text(" records/sec"));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md10);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)graphUIDataForRecordRateOfAllStreams.generateTimelineHtml(jsCollector));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md11);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)graphUIDataForRecordRateOfAllStreams.generateHistogramHtml(jsCollector));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n      "));
        if (hasStream) {
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("style", (Seq)new Text("display: none;"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("inputs-table"), (MetaData)$md12);
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n          "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("colspan", (Seq)new Text("3"), (MetaData)$md13);
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("\n            "));
            $buf20.$amp$plus(this.generateInputDStreamsTable(jsCollector, minBatchTime, maxBatchTime, minRecordRate, maxRecordRate));
            $buf20.$amp$plus((Object)new Text("\n          "));
            $buf19.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
            $buf19.$amp$plus((Object)new Text("\n        "));
            Elem elem5 = new Elem(null, "tr", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19);
            boxedUnit = elem5;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf6.$amp$plus((Object)boxedUnit);
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md14);
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n            "));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md15);
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf24 = new NodeBuffer();
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("Scheduling Delay "));
        $buf25.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken by Streaming scheduler to submit jobs of a batch", "top"));
        $buf24.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
        $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
        $buf23.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)new Text("Avg: "));
        $buf26.$amp$plus((Object)schedulingDelay.formattedAvg());
        $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
        $buf23.$amp$plus((Object)new Text("\n            "));
        $buf22.$amp$plus((Object)new Elem(null, "div", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
        $buf22.$amp$plus((Object)new Text("\n          "));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22));
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md16);
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)graphUIDataForSchedulingDelay.generateTimelineHtml(jsCollector));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md17);
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)graphUIDataForSchedulingDelay.generateHistogramHtml(jsCollector));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
        $buf21.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md18);
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)new Text("\n            "));
        Null$ $md19 = Null$.MODULE$;
        $md19 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md19);
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf32 = new NodeBuffer();
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("Processing Time "));
        $buf33.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken to process all jobs of a batch", "top"));
        $buf32.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf33));
        $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf32));
        $buf31.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("Avg: "));
        $buf34.$amp$plus((Object)processingTime.formattedAvg());
        $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf34));
        $buf31.$amp$plus((Object)new Text("\n            "));
        $buf30.$amp$plus((Object)new Elem(null, "div", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf31));
        $buf30.$amp$plus((Object)new Text("\n          "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf30));
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md20 = Null$.MODULE$;
        $md20 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md20);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)graphUIDataForProcessingTime.generateTimelineHtml(jsCollector));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf35));
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md21 = Null$.MODULE$;
        $md21 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md21);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)graphUIDataForProcessingTime.generateHistogramHtml(jsCollector));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf36));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md22 = Null$.MODULE$;
        $md22 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md22);
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n            "));
        Null$ $md23 = Null$.MODULE$;
        $md23 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md23);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf40 = new NodeBuffer();
        NodeBuffer $buf41 = new NodeBuffer();
        $buf41.$amp$plus((Object)new Text("Total Delay "));
        $buf41.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Total time taken to handle a batch", "top"));
        $buf40.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf41));
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf40));
        $buf39.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf42 = new NodeBuffer();
        $buf42.$amp$plus((Object)new Text("Avg: "));
        $buf42.$amp$plus((Object)totalDelay.formattedAvg());
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf42));
        $buf39.$amp$plus((Object)new Text("\n            "));
        $buf38.$amp$plus((Object)new Elem(null, "div", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf39));
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf38));
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md24 = Null$.MODULE$;
        $md24 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md24);
        NodeBuffer $buf43 = new NodeBuffer();
        $buf43.$amp$plus((Object)graphUIDataForTotalDelay.generateTimelineHtml(jsCollector));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md24, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf43));
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md25 = Null$.MODULE$;
        $md25 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md25);
        NodeBuffer $buf44 = new NodeBuffer();
        $buf44.$amp$plus((Object)graphUIDataForTotalDelay.generateHistogramHtml(jsCollector));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md25, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf44));
        $buf37.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf37));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem table = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        return (Seq)((TraversableLike)((TraversableLike)this.generateTimeMap((Seq<Object>)batchTimes).$plus$plus(this.generateTimeTipStrings((Seq<Object>)batchTimes), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)table, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)jsCollector.toHtml(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Node> generateInputDStreamsTable(JsCollector jsCollector, long minX, long maxX, double minY, double maxY) {
        long maxYCalculated = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.listener().receivedRecordRateWithBatchTime().values().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Seq seq2 = (Seq)seq.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)StreamingPage.$anonfun$generateInputDStreamsTable$2(x0$2)), Seq$.MODULE$.canBuildFrom());
            return seq2;
        }, Iterable$.MODULE$.canBuildFrom())).reduceOption((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.max(x, y)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$12 -> (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Seq content = (Seq)((List)this.listener().receivedRecordRateWithBatchTime().toList().sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int streamId = tuple2._1$mcI$sp();
            Seq recordRates = (Seq)tuple2._2();
            Seq<Node> seq = this.generateInputDStreamRow(jsCollector, streamId, (Seq<Tuple2<Object, Object>>)recordRates, minX, maxX, minY, maxYCalculated);
            return seq;
        }, List$.MODULE$.canBuildFrom());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 151px;"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 167px; padding: 8px 0 8px 0"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Status"));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("width: 167px; padding: 8px 0 8px 0"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md6);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Executor ID / Host"));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", (Seq)new Text("width: 166px; padding: 8px 0 8px 0"), (MetaData)$md7);
        NodeBuffer $buf8 = new NodeBuffer();
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md8);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Last Error Time"));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Last Error Message"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)content);
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> generateInputDStreamRow(JsCollector jsCollector, int streamId, Seq<Tuple2<Object, Object>> recordRates, long minX, long maxX, double minY, double maxY) {
        Option<ReceiverInfo> receiverInfo = this.listener().receiverInfo(streamId);
        String receiverName = (String)receiverInfo.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name()).orElse((Function0 & Serializable & scala.Serializable)() -> this.listener().streamName(streamId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Stream-").append(streamId).toString());
        String receiverActive = (String)receiverInfo.map((Function1 & Serializable & scala.Serializable)info -> info.active() ? "ACTIVE" : "INACTIVE").getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLocation = (String)receiverInfo.map((Function1 & Serializable & scala.Serializable)info -> {
            String executorId = info.executorId().isEmpty() ? StreamingPage$.MODULE$.emptyCell() : info.executorId();
            String location = info.location().isEmpty() ? StreamingPage$.MODULE$.emptyCell() : info.location();
            return new StringBuilder(3).append(executorId).append(" / ").append(location).toString();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLastError = (String)receiverInfo.map((Function1 & Serializable & scala.Serializable)info -> {
            void var1_1;
            String msg = new StringBuilder(3).append(info.lastErrorMessage()).append(" - ").append(info.lastError()).toString();
            return msg.length() > 100 ? new StringBuilder(3).append((String)new StringOps(Predef$.MODULE$.augmentString(msg)).take(97)).append("...").toString() : var1_1;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLastErrorTime = (String)receiverInfo.map((Function1 & Serializable & scala.Serializable)r -> r.lastErrorTime() < 0L ? "-" : org.apache.spark.ui.UIUtils$.MODULE$.formatDate(r.lastErrorTime())).getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        RecordRateUIData receivedRecords = new RecordRateUIData(recordRates);
        GraphUIData graphUIDataForRecordRate = new GraphUIData(new StringBuilder(24).append("stream-").append(streamId).append("-records-timeline").toString(), new StringBuilder(25).append("stream-").append(streamId).append("-records-histogram").toString(), receivedRecords.data(), minX, maxX, minY, maxY, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForRecordRate.generateDataJs(jsCollector);
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle; width: 151px;"), (MetaData)$md);
        $md = new UnprefixedAttribute("rowspan", (Seq)new Text("2"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 151px;"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("word-wrap: break-word;"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)receiverName);
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Avg: "));
        $buf7.$amp$plus((Object)receivedRecords.formattedAvg());
        $buf7.$amp$plus((Object)new Text(" records/sec"));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)receiverActive);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)receiverLocation);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)receiverLastErrorTime);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 342px;"), (MetaData)$md4);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)receiverLastError);
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("colspan", (Seq)new Text("3"), (MetaData)$md5);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n        "));
        $buf14.$amp$plus((Object)graphUIDataForRecordRate.generateTimelineHtml(jsCollector));
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf13.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md6);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)graphUIDataForRecordRate.generateHistogramHtml(jsCollector));
        $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf13.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        return $buf;
    }

    private Seq<Node> generateBatchListTables() {
        Seq runningBatches = (Seq)((SeqLike)this.listener().runningBatches().sortBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$1(x$15)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        Seq waitingBatches = (Seq)((SeqLike)this.listener().waitingBatches().sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$2(x$16)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        Seq completedBatches = (Seq)((SeqLike)this.listener().retainedCompletedBatches().sortBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$3(x$17)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeBatches',\n                'aggregated-activeBatches')"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeBatches collapse-table"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("activeBatches"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n              "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md4);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf4.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Active Batches ("));
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(runningBatches.size() + waitingBatches.size())));
        $buf5.$amp$plus((Object)new Text(")"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeBatches collapsible-table"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus(new ActiveBatchTable((Seq<BatchUIData>)runningBatches, (Seq<BatchUIData>)waitingBatches, this.listener().batchDuration()).toNodeSeq());
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem activeBatchesContent = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md6);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md7);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedBatches',\n                'aggregated-completedBatches')"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedBatches collapse-table"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("completedBatches"), (MetaData)$md8);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md9);
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf10.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("Completed Batches (last "));
        $buf11.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedBatches.size()));
        $buf11.$amp$plus((Object)new Text("\n                out of "));
        $buf11.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalCompletedBatches()));
        $buf11.$amp$plus((Object)new Text(")"));
        $buf10.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedBatches collapsible-table"), (MetaData)$md10);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus(new CompletedBatchTable((Seq<BatchUIData>)completedBatches, this.listener().batchDuration()).toNodeSeq());
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Elem completedBatchesContent = new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7);
        return (Seq)activeBatchesContent.$plus$plus((GenTraversableOnce)completedBatchesContent, NodeSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$generateTimeMap$1(StreamingPage $this, long time) {
        String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, $this.listener().batchDuration(), false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
        return new StringBuilder(18).append("timeFormat[").append(time).append("] = '").append(formattedTime).append("';").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTimeTipStrings$1(long time) {
        return new StringBuilder(32).append("timeTipStrings[").append(time).append("] = timeFormat[").append(time).append("];").toString();
    }

    public static final /* synthetic */ long $anonfun$generateStatTable$1(BatchUIData x$6) {
        return x$6.batchTime().milliseconds();
    }

    public static final /* synthetic */ Option $anonfun$generateStatTable$10(MillisecondsStatUIData totalDelay$1, long m1$1, long m2) {
        return totalDelay$1.max().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)m3 -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(m1$1), m2)), m3));
    }

    public static final /* synthetic */ Option $anonfun$generateStatTable$9(MillisecondsStatUIData processingTime$1, MillisecondsStatUIData totalDelay$1, long m1) {
        return processingTime$1.max().flatMap((Function1 & Serializable & scala.Serializable)m2 -> StreamingPage.$anonfun$generateStatTable$10(totalDelay$1, m1, BoxesRunTime.unboxToLong((Object)m2)));
    }

    public static final /* synthetic */ double $anonfun$generateInputDStreamsTable$2(Tuple2 x0$2) {
        double recordRate;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = recordRate = tuple2._2$mcD$sp();
        return d;
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$1(BatchUIData x$15) {
        return x$15.batchTime().milliseconds();
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$2(BatchUIData x$16) {
        return x$16.batchTime().milliseconds();
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$3(BatchUIData x$17) {
        return x$17.batchTime().milliseconds();
    }

    public StreamingPage(StreamingTab parent) {
        this.parent = parent;
        super("");
        Logging.$init$((Logging)this);
        this.listener = parent.listener();
    }
}

