/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyString
extends LazyPrimitive<LazyStringObjectInspector, Text> {
    public LazyString(LazyStringObjectInspector oi) {
        super(oi);
        this.data = new Text();
    }

    public LazyString(LazyString copy) {
        super(copy);
        this.data = new Text((Text)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (((LazyStringObjectInspector)this.oi).isEscaped()) {
            byte escapeChar = ((LazyStringObjectInspector)this.oi).getEscapeChar();
            byte[] inputBytes = bytes.getData();
            LazyUtils.copyAndEscapeStringDataToText(inputBytes, start, length, escapeChar, (Text)this.data);
        } else {
            ((Text)this.data).set(bytes.getData(), start, length);
        }
        this.isNull = false;
    }
}

