/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DispatchReaper
extends Thread {
    private static Logger gLogger = Logger.getLogger(DispatchReaper.class);
    protected FileSystem _fs;
    protected Path _hdfsDispatch;
    protected File _localDipatch;

    public DispatchReaper(FileSystem fs, Path hdfsDispatch, File localDispatch) {
        this._fs = fs;
        this._hdfsDispatch = hdfsDispatch;
        this._localDipatch = localDispatch;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        DispatchReaper.yield();
        gLogger.info((Object)("Starting. Settings: hdfs.path=" + this._hdfsDispatch + ", local.path=" + this._localDipatch));
        int deleted = 0;
        int total = 0;
        int error = 0;
        try {
            if (!this._fs.exists(this._hdfsDispatch)) {
                gLogger.info((Object)("Skip dispatch reaping, top level HDFS dispatch dir=" + this._hdfsDispatch.toString() + " does not exist."));
                return;
            }
            FileStatus[] dirs = this._fs.listStatus(this._hdfsDispatch);
            if (dirs == null || dirs.length == 0) {
                return;
            }
            for (FileStatus f : dirs) {
                ++total;
                File localFile = new File(this._localDipatch, f.getPath().getName());
                if (localFile.isDirectory()) continue;
                try {
                    this._fs.delete(f.getPath(), true);
                    ++deleted;
                    gLogger.info((Object)("Deleted HDFS dispatch dir=" + f.getPath() + ", local dispatch dir=" + localFile + " does not exist"));
                    DispatchReaper.yield();
                }
                catch (Exception ex) {
                    ++error;
                }
            }
        }
        catch (IOException e) {
            gLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        gLogger.info((Object)("Finished, scanned=" + total + ", deleted=" + deleted + ", errors=" + error));
    }

    public static void cleanupLocalDispatchDir(File localDispatch, long maxDirMtime) {
        File[] dirs;
        if (maxDirMtime == 0L) {
            maxDirMtime = System.currentTimeMillis() - 86400000L;
        }
        if ((dirs = localDispatch.listFiles()) == null || dirs.length == 0) {
            return;
        }
        for (File dispatchDir : dirs) {
            if (dispatchDir.lastModified() > maxDirMtime) continue;
            try {
                FileUtil.fullyDelete((File)dispatchDir);
                gLogger.info((Object)("Deleted local dispatch dir=" + dispatchDir));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

