/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.datamodel.DataModelCreator;
import com.splunk.fs.FSUtil;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.BundleReplicationCommandHandler;
import com.splunk.mr.DispatchReaper;
import com.splunk.mr.SetupCommandHandler;
import com.splunk.mr.SplunkBaseMapper;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.SplunkdProcess;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.input.TimeRange;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.mr.input.VixInputSplit;
import com.splunk.util.StrUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SplunkSearchMapper
extends SplunkBaseMapper {
    private static Logger gLogger = Logger.getLogger(SplunkSearchMapper.class);
    protected static boolean _setupDone = false;
    protected SplunkdProcess _splunkProcess = null;
    protected String _searchId = null;

    private static synchronized void ensureSplunkdEnv(Configuration conf) throws IOException, InterruptedException {
        if (_setupDone) {
            return;
        }
        SetupCommandHandler.setupSplunk(conf);
        BundleReplicationCommandHandler.setupBundle(conf);
        _setupDone = true;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        gLogger.setLevel(Level.INFO);
        long startTime = System.currentTimeMillis();
        Configuration conf = context.getConfiguration();
        if (SplunkMR.useProxy(conf)) {
            File localJobDir = SplunkMR.getLocalJobDir(context);
            File splunkHome = new File(localJobDir, SplunkMR.getProductName(conf));
            gLogger.info((Object)("local job dir=" + localJobDir.getAbsolutePath() + " SPLUNK_HOME=" + splunkHome.getAbsolutePath()));
            conf.set(SplunkMR.CONF_DN_HOME, splunkHome.getAbsolutePath());
        }
        gLogger.info((Object)("CONF_DN_HOME is set to " + conf.get(SplunkMR.CONF_DN_HOME)));
        SplunkSearchMapper.ensureSplunkdEnv(conf);
        gLogger.info((Object)("Ensuring Hunk is setup correctly took elapsed_ms=" + (System.currentTimeMillis() - startTime)));
    }

    public static String getSearchToRun(Configuration conf, InputSplit inputSplit) {
        String vixName;
        VirtualIndex vix;
        String search2run = conf.get(SplunkMR.CONF_SEARCH_MAP);
        if (!(inputSplit instanceof VixInputSplit)) {
            return search2run;
        }
        VixInputSplit vixSplit = (VixInputSplit)inputSplit;
        if (vixSplit.getFields().containsKey("index") && (vix = VirtualIndex.parseIndex(conf, vixName = vixSplit.getFields().get("index"))) != null && vix.getSearch() != null) {
            search2run = vix.getSearch();
        }
        if ((search2run = search2run.trim()).startsWith("search * |")) {
            search2run = search2run.substring(10);
        }
        if (vixSplit.isDmaSplit()) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("DMA Split found (" + vixSplit.getSplitId() + ") ... modifying search query"));
            }
            String tstatsFilter = conf.get(SplunkMR.CONF_DATAMODEL_SEARCH_FILTER);
            String tstatsAggregate = conf.get(SplunkMR.CONF_DATAMODEL_SEARCH_AGGREGATE);
            if (tstatsFilter != null || tstatsAggregate != null) {
                Map<String, Object> searchInfo;
                String normalizedSearch;
                int streamingPortionIndex;
                search2run = "";
                if (tstatsFilter != null) {
                    if (StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_READ), false)) {
                        tstatsFilter = tstatsFilter.replaceFirst("nodename\\s*=", "nodename{}=");
                    }
                    search2run = "search " + tstatsFilter;
                }
                if (tstatsAggregate != null) {
                    search2run = search2run.isEmpty() ? conf.get(SplunkMR.CONF_DATAMODEL_SEARCH_AGGREGATE).substring(1) : search2run + conf.get(SplunkMR.CONF_DATAMODEL_SEARCH_AGGREGATE);
                }
                if ((streamingPortionIndex = (normalizedSearch = (String)(searchInfo = VirtualIndex.getSearchInfo(conf)).get("_normalized_search")).indexOf("|")) != -1) {
                    String streamingSearch = normalizedSearch.substring(streamingPortionIndex);
                    search2run = search2run + streamingSearch;
                }
            }
        }
        search2run = "stdin | " + search2run;
        return search2run;
    }

    private static String csvEscape(String str) {
        if (str.indexOf(44) > -1 || str.indexOf(34) > -1) {
            return "\"" + str.replaceAll("\"", "\"\"") + "\"";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> writeInfoCsv(Configuration conf, File path, String search) {
        Map<String, Object> search_info = VirtualIndex.getSearchInfo(conf);
        if (search_info == null) {
            return null;
        }
        path.getParentFile().mkdirs();
        search_info.remove("_splunkd_port");
        search_info.remove("_splunkd_protocol");
        search_info.remove("_splunkd_uri");
        search_info.remove("_query_finished");
        search_info.remove("_auth_token");
        search_info.remove("_remote_search");
        search_info.remove("_timestamp");
        search_info.put("_sid", this._searchId);
        search_info.put("_search", search);
        search_info.put("_ppc.bs", BundleReplicationCommandHandler.getDNBundlePath(conf));
        if (StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_READ), false) && conf.get(SplunkMR.CONF_SEARCH_REDUCE) != null) {
            search_info.put("_reduce_search", conf.get(SplunkMR.CONF_SEARCH_REDUCE));
        }
        if (StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_WRITE), false)) {
            search_info.put("_api_lt", Long.MAX_VALUE);
            search_info.put("_search_lt", Long.MAX_VALUE);
            search_info.put("_endTime", Long.MAX_VALUE);
        }
        PrintStream bos = null;
        try {
            bos = new PrintStream(new FileOutputStream(path));
            boolean first = true;
            for (String key : search_info.keySet()) {
                if (!first) {
                    bos.print(",");
                }
                bos.print(SplunkSearchMapper.csvEscape(key));
                first = false;
            }
            bos.println();
            first = true;
            for (Object val : search_info.values()) {
                if (!first) {
                    bos.print(",");
                }
                bos.print(SplunkSearchMapper.csvEscape(val.toString()));
                first = false;
            }
        }
        catch (FileNotFoundException e) {
            try {
                gLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)bos);
        }
        IOUtils.closeQuietly((OutputStream)bos);
        return search_info;
    }

    protected void startSplunkProcess(Mapper.Context context, Writer stdout, Writer stderr, boolean closeWriter) throws IOException {
        this._searchId = "SplunkMR_" + context.getTaskAttemptID().toString();
        Configuration conf = context.getConfiguration();
        String search2run = SplunkSearchMapper.getSearchToRun(conf, (VixInputSplit)context.getInputSplit());
        String reduceSearch = conf.get(SplunkMR.CONF_SEARCH_REDUCE);
        if (((VixInputSplit)context.getInputSplit()).isDmaSplit() && StrUtil.parseBoolean(conf.get(SplunkMR.CONF_DATAMODEL_READ), false) && reduceSearch != null) {
            Pattern reduceSearchPattern = Pattern.compile("((?:\\w+(?:\\.\\w+)*)(?:\\s:::\\s(?:\\w+(?:\\.\\w+)*))+)");
            Matcher m = reduceSearchPattern.matcher(reduceSearch);
            if (m.find()) {
                String match = m.group(1);
                reduceSearch = reduceSearch.replace(match, "\"" + match + "\"");
            }
            conf.set(SplunkMR.CONF_SEARCH_REDUCE, reduceSearch);
        }
        String splunk_home = SplunkMR.getDNSplunkHome(conf).toString();
        gLogger.info((Object)("search2run::" + search2run));
        gLogger.info((Object)("reduceSearch::" + reduceSearch));
        Map<String, Object> info = this.writeInfoCsv(conf, new File(SplunkdProcess.getDispatchDir(splunk_home, this._searchId), "info.csv"), search2run);
        ArrayList<String> args = new ArrayList<String>(10);
        args.add("search");
        args.add("--streaming");
        if (reduceSearch != null) {
            args.add("--runReduce=true");
        }
        args.add("--annotateMessages=true");
        args.add("--outCsv");
        args.add("--pro");
        args.add("--user=" + info.get("_ppc.user"));
        args.add("--app=" + info.get("_ppc.app"));
        args.add("--roles=admin");
        args.add("--maxout=0");
        args.add("--maxbuckets=0");
        args.add("--id=" + this._searchId);
        Random random = new Random();
        if (random.nextDouble() < 0.05) {
            DispatchReaper.cleanupLocalDispatchDir(SplunkdProcess.getDispatchDir(splunk_home, ""), 0L);
            SetupCommandHandler.cleanupToDeleteDnHomeDirs(SplunkMR.getDNSplunkHome(conf).getParentFile());
        }
        this._splunkProcess = new SplunkdProcess(splunk_home, stdout, stderr, closeWriter, args.toArray(new String[0]));
    }

    @Override
    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        boolean collect;
        if (this._splunkProcess == null) {
            return;
        }
        Configuration conf = context.getConfiguration();
        this._splunkProcess.destroy();
        boolean bl = collect = this._splunkProcess.getExitCode() != 0 || StrUtil.parseBoolean(conf.get(SplunkMR.CONF_SEARCH_DEBUG), false);
        if (collect) {
            Path dispatchDirs;
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (!fs.exists(dispatchDirs = new Path(SplunkMR.getHDFSDispatchHome(conf), "dispatch_dirs"))) {
                fs.mkdirs(dispatchDirs);
            }
            try {
                FSUtil.copy(this._splunkProcess.getDispatchDir(this._searchId), fs, dispatchDirs, conf, true);
            }
            catch (Exception e) {
                gLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this._splunkProcess.cleanupDispatchDir(this._searchId);
        super.cleanup(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl(Mapper.Context context) throws IOException, InterruptedException {
        ResultPaths paths;
        VixInputSplit inputsplit;
        block31: {
            FileSystem fs;
            block30: {
                GZIPInputStream in;
                DataModelCreator resultReader;
                block28: {
                    int tmp;
                    Configuration conf = context.getConfiguration();
                    inputsplit = (VixInputSplit)context.getInputSplit();
                    fs = FileSystem.get((Configuration)conf);
                    MapCache cache = MapCache.create(SplunkMR.getCacheFs(fs, conf, SplunkMR.getTopLevelCacheDir(conf)), SplunkMR.getHDFSCacheDir(conf, inputsplit));
                    paths = new ResultPaths(conf, context.getTaskAttemptID());
                    boolean writeToCache = SplunkMR.writeToCache(conf);
                    boolean readFromCache = false;
                    boolean writeToDM = SplunkMR.writeToDataModel(conf);
                    boolean debug = StrUtil.parseBoolean(conf.get(SplunkMR.CONF_SEARCH_DEBUG), false);
                    if (readFromCache) break block30;
                    long time = System.currentTimeMillis();
                    short replication = (short)conf.getInt("splunk.search.mr.mapper.output.replication", 3);
                    if (replication < 1 || replication > 100) {
                        replication = 3;
                    }
                    if ((tmp = conf.getInt("splunk.search.mr.mapper.output.gzlevel", 2)) < 0 || tmp > 9) {
                        tmp = 2;
                    }
                    final int compressionLevel = tmp;
                    PipedInputStream pin = null;
                    OutputStream out = null;
                    DataModelCreator.PipedStreamFlags flags = new DataModelCreator.PipedStreamFlags();
                    resultReader = null;
                    if (writeToDM && !debug) {
                        pin = new PipedInputStream(8192);
                        out = new PipedOutputStream(pin);
                        resultReader = new DataModelCreator(pin, conf, inputsplit, fs, flags, context);
                        resultReader.start();
                    } else {
                        out = new GZIPOutputStream((OutputStream)fs.create(paths.resultPathTmp, replication), 65535){
                            {
                                super(x0, x1);
                                this.def.setLevel(compressionLevel);
                            }
                        };
                    }
                    OutputStreamWriter searchStdout = new OutputStreamWriter(out);
                    OutputStreamWriter searchStderr = new OutputStreamWriter((OutputStream)fs.create(paths.errorPathTmp, replication));
                    try {
                        if (!writeToDM) {
                            searchStdout.write(inputsplit.getSplitId() + "\n");
                        }
                        this.startSplunkProcess(context, searchStdout, searchStderr, writeToDM && !debug);
                        gLogger.info((Object)("_splunkProcess.getStdin()=" + this._splunkProcess.getStdin()));
                        SearchOutputStream chunkedOut = new SearchOutputStream(this._splunkProcess.getStdin());
                        if (inputsplit.getRecordReader().getOutputDataFormat().equalsIgnoreCase("journal")) {
                            gLogger.info((Object)"changing stream_type to journal");
                            chunkedOut.setStreamType("journal");
                        }
                        this.setPipedStreamFlags(flags);
                        this.setOutputStream(chunkedOut);
                        this.setStreamExceptionHandler(new AbsorbExceptionIfGracefulSplunkdTermination());
                        super.runImpl(context);
                        int rv = this._splunkProcess.waitFor();
                        gLogger.info((Object)String.format("Processed records=%d, bytes=%d, return_code=%d, elapsed_ms=%d", this._stats.records, this._stats.bytes, rv, System.currentTimeMillis() - time));
                        gLogger.info((Object)String.format("Bytes Output by Splunkd process=%d", this._splunkProcess.getStdoutBytesCopied()));
                        IOUtils.closeQuietly((Writer)searchStdout);
                        IOUtils.closeQuietly((Writer)searchStderr);
                        if (rv != 0 && !flags.stopWriter) {
                            throw new IOException(String.format("Search process failed to exit cleanly. Return code=%d", rv) + ".");
                        }
                        if (resultReader != null) {
                            flags.stopReader = true;
                            resultReader.join();
                            if (resultReader.getException() != null) {
                                throw resultReader.getException();
                            }
                        }
                        if (this._splunkProcess.hasStdoutError()) {
                            throw this._splunkProcess.getStdoutError();
                        }
                        fs.rename(paths.resultPathTmp, paths.resultPath);
                        TimeRange searchTimeRange = TimeRange.createSearchTimeRange(conf);
                        if (writeToCache && inputsplit.isWithinTimeRange(searchTimeRange)) {
                            long now = System.currentTimeMillis();
                            SplunkMR.writeCacheResult(cache, inputsplit, conf, paths.resultPath);
                            chunkedOut.addMetric("cache.write.bytes", System.currentTimeMillis() - now, 1L);
                            chunkedOut.addCountMetric("cache.write.bytes", this._stats.bytes, this._stats.bytes);
                        }
                    }
                    catch (IOException e) {
                        gLogger.error((Object)"Mapper exception caught!!", (Throwable)e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        gLogger.error((Object)"Mapper exception caught!!", (Throwable)e);
                        throw e;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)pin);
                        IOUtils.closeQuietly((Writer)searchStdout);
                        IOUtils.closeQuietly((Writer)searchStderr);
                        if (resultReader != null) {
                            resultReader.destroy();
                        }
                        if (this._splunkProcess != null && this._splunkProcess.getStderrBytesCopied() == 0L && !this._splunkProcess.hasStderrError()) {
                            fs.delete(paths.errorPathTmp, false);
                        } else {
                            fs.rename(paths.errorPathTmp, paths.errorPath);
                        }
                    }
                    if (!writeToDM || !debug) break block31;
                    in = null;
                    try {
                        flags.stopReader = true;
                        in = new GZIPInputStream((InputStream)fs.open(paths.resultPath), 4096);
                        resultReader = new DataModelCreator(in, conf, inputsplit, fs, flags, context);
                        resultReader.start();
                        resultReader.join();
                        if (resultReader.getException() == null) break block28;
                        throw resultReader.getException();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        if (resultReader != null) {
                            resultReader.destroy();
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                if (resultReader != null) {
                    resultReader.destroy();
                }
                break block31;
            }
            FSDataOutputStream created = null;
            InputStream in = null;
            try {
                created = fs.create(paths.resultPathTmp, true);
                IOUtils.copyLarge(in, (OutputStream)created);
                fs.rename(paths.resultPathTmp, paths.resultPath);
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)created);
            }
            gLogger.info((Object)("Cache HIT, for split=" + (Object)((Object)inputsplit)));
        }
        Text val = new Text(paths.resultPath.toString());
        Text key = new Text(inputsplit.getSplitId());
        context.write((Object)key, (Object)val);
    }

    private class AbsorbExceptionIfGracefulSplunkdTermination
    implements SplunkBaseMapper.StreamExceptionHandler {
        private AbsorbExceptionIfGracefulSplunkdTermination() {
        }

        @Override
        public void handle(IOException e) throws InterruptedException, IOException {
            boolean gracefulTermination;
            int exitCode = SplunkSearchMapper.this._splunkProcess.waitFor();
            boolean bl = gracefulTermination = exitCode == 0;
            if (!gracefulTermination) {
                throw e;
            }
        }
    }

    public static class ResultPaths {
        public final Path resultPath;
        public final Path errorPath;
        public final Path resultPathTmp;
        public final Path errorPathTmp;

        public ResultPaths(Configuration conf, TaskAttemptID taskId) {
            int tid = taskId.getTaskID().getId();
            Path outputPath = SplunkMR.getHDFSDispatchHome(conf);
            this.resultPath = new Path(outputPath, SplunkMR.getJobFilename("m", tid));
            this.errorPath = new Path(outputPath, SplunkMR.getJobFilename("err-m", tid));
            this.resultPathTmp = new Path(this.resultPath.getParent(), this.resultPath.getName() + "." + taskId.getId() + ".tmp");
            this.errorPathTmp = new Path(this.errorPath.getParent(), this.errorPath.getName() + "." + taskId.getId() + ".tmp");
        }
    }
}

