/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reader;

import com.splunk.mr.cache.Cache;
import com.splunk.mr.cache.CacheReference;
import java.io.IOException;
import org.apache.hadoop.fs.Path;

public class GetsTransitionedPath {
    private final CacheReference cacheRef;
    private Cache cache = null;

    public GetsTransitionedPath(CacheReference cacheRef) {
        this.cacheRef = cacheRef;
    }

    public Transition getTransition(Path cachePath) throws IOException {
        return this.getLatestPath(cachePath, this.cacheRef.deref());
    }

    public void clearCache() {
        this.cache = null;
    }

    public Transition getTransitionCached(Path cachePath) throws IOException {
        if (this.cache == null) {
            this.cache = this.cacheRef.deref();
        }
        return this.getLatestPath(cachePath, this.cache);
    }

    private Transition getLatestPath(Path cachePath, Cache latest) throws IOException {
        String latestPath = null;
        long offset = 0L;
        String path = cachePath.toUri().getPath();
        while (latest.getTransitions().containsKey(path)) {
            latestPath = latest.getTransitions().get(path);
            offset += latest.getOffsets().get(path).longValue();
            path = latestPath;
        }
        if (latestPath == null) {
            return this.retry(cachePath, latest);
        }
        if (latestPath.equals("deleted")) {
            return new DeletedTransition();
        }
        return new Transition(latestPath, offset);
    }

    private Transition retry(Path cachePath, Cache latest) throws IOException {
        this.cache = this.cacheRef.deref();
        Cache c = this.cache;
        if (c.getId() > latest.getId()) {
            return this.getLatestPath(cachePath, c);
        }
        throw new RuntimeException("Hash(" + cachePath + ") was did not exist in cache(" + latest.getId() + ") transitions.");
    }

    public static class DeletedTransition
    extends Transition {
        public DeletedTransition() {
            super(null, -1L);
        }

        @Override
        public boolean isDeleted() {
            return true;
        }
    }

    public static class Transition {
        private final String path;
        private final long offset;

        public Transition(String path, long offset) {
            this.path = path;
            this.offset = offset;
        }

        public String getRawPath() {
            return this.path;
        }

        public Path getPath() {
            return new Path(this.path);
        }

        public long getOffset() {
            return this.offset;
        }

        public boolean isDeleted() {
            return false;
        }
    }
}

