/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.search.processors;

import com.splunk.datamodel.DataModelBuckets;
import com.splunk.datamodel.DataModelCreator;
import com.splunk.mr.OutputProcessor;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.cache.CompactionMetadata;
import com.splunk.mr.cache.MapCache;
import com.splunk.mr.cache.MapCaches;
import com.splunk.mr.cache.delete.GroupedDeletionProcessor;
import com.splunk.mr.cache.reporting.Report;
import com.splunk.mr.input.ObjectAcceptor;
import com.splunk.mr.input.VixSplitGenerator;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.search.SearchProcessor;
import com.splunk.search.SearchResults;
import com.splunk.util.HdfsUtil;
import com.splunk.util.StrUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class SummarizeProcessor
extends SearchProcessor {
    public static final String DELETED_PATH = "deleted_path";
    public static final String DELETED_BYTES = "deleted_bytes";
    private static final Logger gLogger = Logger.getLogger(SummarizeProcessor.class);
    protected boolean done = false;
    protected ExecutorService _pipeModePool = null;
    protected FileSystem _fs = null;
    protected Configuration _conf = null;
    protected MapCaches _mapCaches = null;
    protected VixSplitGenerator _tif = null;
    protected Set<String> _indexes = null;
    protected boolean _use_norm_id = true;
    private static final int CSV_SUMMARY_ID_IDX = 0;
    private static final int CSV_EARLIEST_TIME_IDX = 1;
    private static final int CSV_NORM_SUMMARY_ID_IDX = 3;

    public SummarizeProcessor(FileSystem fs, Configuration conf, MapCaches caches, VixSplitGenerator tif, Set<String> indexes) {
        this._fs = fs;
        this._conf = conf;
        this._mapCaches = caches;
        this._tif = tif;
        this._indexes = indexes;
        this._use_norm_id = SplunkMR.useNormSummaryId(this._conf);
    }

    @Override
    public boolean isGenerating() {
        return true;
    }

    @Override
    public void aboutToExecute() {
        super.aboutToExecute();
        this._pipeModePool = SplunkMR.getDaemonThreadPool("pipe-mode-pool", OutputProcessor.getThreadCount(this._conf));
    }

    private void shutdownExecutor() {
        if (this._pipeModePool != null) {
            this._pipeModePool.shutdownNow();
        }
    }

    protected void executeImpl(SearchResults srs) throws IOException {
        boolean isTstats = SplunkMR.isDataModelSummarizeSearch(this._conf);
        String action = this.getOption("action");
        String maintain = this.getOption("maintain");
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("isTstats=" + isTstats + ", action=" + action + ", maintain=" + maintain));
        }
        if ("probe".equalsIgnoreCase(action)) {
            SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this._conf);
            String id = this.getOption("id");
            String normid = this.getOption("normid");
            if (isTstats) {
                gLogger.warn((Object)"Summarize tstats probe should be handled by ExternalResultProvider");
                return;
            }
            for (Report report : this._mapCaches.probe(id, normid)) {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("report path:" + report.get("bucket_path")));
                }
                SearchResults.Result res = srs.addNewResult();
                for (String key : report.keySet()) {
                    res.set(key, report.get(key));
                }
            }
        } else if ("delete".equalsIgnoreCase(action)) {
            if (isTstats) {
                String id = this.getOption("id");
                SplunkMR.setDataModelSummaryId(this._conf, id);
                String appAndDMName = id.split("_DM_")[1];
                if (!DataModelBuckets.deleteKVStoreEntry(this._conf, appAndDMName)) {
                    gLogger.warn((Object)("Could not delete collection on KV Store for " + appAndDMName + ".. Manual cleanup might be needed"));
                }
                if (!DataModelBuckets.deleteDMMetadata(this._conf, appAndDMName)) {
                    gLogger.warn((Object)("Could not delete metadata pertaining to " + appAndDMName + " in KV Store.. Manual cleanup might be needed"));
                }
                for (String indexName : this._indexes) {
                    Path p = DataModelCreator.getDataModelBaseDir(this._conf, indexName);
                    long size = this._fs.getContentSummary(p).getLength();
                    this._fs.delete(p, true);
                    this.reportDeletedPath(srs, p.toUri().getPath(), size);
                }
                DataModelBuckets.deleteKVStoreSummaryStatEntry(this._conf, id);
                return;
            }
            String summaryId = this.getOption(this._use_norm_id ? "normid" : "id");
            for (String indexName : this._indexes) {
                Path hdfsCacheDir = SplunkMR.getHDFSCacheDir(this._conf, indexName, summaryId, "foo").getParent();
                long pathSize = this._fs.getContentSummary(hdfsCacheDir).getLength();
                this._fs.delete(hdfsCacheDir, true);
                this.reportDeletedPath(srs, hdfsCacheDir.toUri().getPath(), pathSize);
            }
        } else if (maintain != null) {
            if (isTstats) {
                List<IdTimePair> idTimePairs = SummarizeProcessor.parseTstatsMaintainString(maintain);
                List<String> existingDataModelDirs = DataModelCreator.getExistingDataModelDirs(this._conf);
                SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(this._conf);
                ObjectMapper objectMapper = new ObjectMapper();
                for (IdTimePair p : idTimePairs) {
                    if (gLogger.isDebugEnabled()) {
                        gLogger.debug((Object)("Performing maintenance for datamodel with Summary Id: " + p.id));
                    }
                    existingDataModelDirs.remove(p.id);
                    SplunkMR.setDataModelSummaryId(this._conf, p.id);
                    ObjectNode queryNode = objectMapper.createObjectNode();
                    queryNode.put("summaryId", p.id);
                    ObjectNode ltCondNode = objectMapper.createObjectNode();
                    ltCondNode.put("$lt", p.et);
                    queryNode.put("latestTime", (JsonNode)ltCondNode);
                    try {
                        SplunkMiniSDK.SplunkResponse sr = sdk.get("/servicesNS/nobody/search/storage/collections/data/hunk_dma_" + p.id.split("_DM_")[1], "query", queryNode.toString());
                        if (sr.raw() == null) continue;
                        ArrayNode resultsNode = (ArrayNode)sr.raw();
                        Iterator nodeIterator = resultsNode.iterator();
                        boolean resultsFound = false;
                        while (nodeIterator.hasNext()) {
                            resultsFound = true;
                            ObjectNode node = (ObjectNode)nodeIterator.next();
                            Path path = new Path(DataModelCreator.getDataModelDir(this._conf, node.get("index").getTextValue(), node.get("bucketId").getTextValue()), node.get("path").getTextValue());
                            if (this._fs.delete(path, false)) {
                                gLogger.info((Object)("Path " + path.toString() + " deleted as part of maintenance"));
                            } else {
                                gLogger.warn((Object)("Path " + path.toString() + " deleted failed!!"));
                            }
                            this.reportDeletedPath(srs, node.get("path").getTextValue(), node.get("length").getLongValue());
                        }
                        if (!resultsFound) continue;
                        sdk.delete("/servicesNS/nobody/search/storage/collections/data/hunk_dma_" + p.id.split("_DM_")[1], "query", queryNode.toString());
                    }
                    catch (SplunkMiniSDK.SplunkResponseException sre) {
                        gLogger.error((Object)"Exception caught while querying DMA KV Store collection.", (Throwable)sre);
                        gLogger.error((Object)sre.getResponse().toString());
                    }
                }
                String summaryprefix = this.getOption("summaryprefix");
                assert (summaryprefix != null);
                for (String dataModelDir : existingDataModelDirs) {
                    Path path;
                    String[] splitByDM = dataModelDir.split("_DM_");
                    String dataModelSHGuid = splitByDM[0];
                    if (!summaryprefix.equals(dataModelSHGuid)) continue;
                    gLogger.info((Object)("Deleting datamodel: " + dataModelDir));
                    String appAndDMName = splitByDM[1];
                    if (!DataModelBuckets.deleteKVStoreEntry(this._conf, appAndDMName)) {
                        gLogger.error((Object)("Could not delete collection on KV Store for " + appAndDMName + ".. Manual cleanup might be needed"));
                    }
                    if (!DataModelBuckets.deleteDMMetadata(this._conf, appAndDMName)) {
                        gLogger.error((Object)("Could not delete metadata pertaining to " + appAndDMName + " in KV Store.. Manual cleanup might be needed"));
                    }
                    if (this._fs.delete(path = DataModelCreator.getDataModelDirForSummaryId(this._conf, dataModelDir), true)) {
                        gLogger.info((Object)("Path " + path.toString() + " deleted as part of maintenance"));
                        continue;
                    }
                    gLogger.error((Object)("Path " + path.toString() + " deleted failed!! Manual cleanup might be needed"));
                }
                return;
            }
            if (maintain.isEmpty()) {
                this.deleteCacheDirsChildren(srs);
            } else {
                this.maintainCacheCompactions(srs, maintain);
            }
        } else {
            throw new IllegalArgumentException("Unknown action=" + action);
        }
    }

    private void maintainCacheCompactions(SearchResults srs, String maintain) throws IOException {
        List<IdTimePair> idTimePairs = SummarizeProcessor.parseMaintainString(maintain);
        this.maintainCacheWithParsedMaintainString(idTimePairs, srs);
    }

    private void maintainCacheWithParsedMaintainString(List<IdTimePair> idTimePairs, final SearchResults srs) throws IOException {
        final HashMap<String, Long> summaryIdMd5sToKeep = new HashMap<String, Long>();
        for (IdTimePair p : idTimePairs) {
            summaryIdMd5sToKeep.put(SplunkMR.md5SummaryId(p.id), p.et);
            summaryIdMd5sToKeep.put(SplunkMR.md5SummaryId(p.normId), p.et);
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("deleting whole caches which does not match the following md5(summary_id)s: " + summaryIdMd5sToKeep.keySet()));
        }
        SummarizeProcessor.forEveryMD5SummaryIdCachePath(this._fs, new ObjectAcceptor<Path>(){

            @Override
            public boolean accept(Path md5SummaryIdPath) {
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("Got cache md5(summary_id) path=" + md5SummaryIdPath));
                }
                try {
                    if (summaryIdMd5sToKeep.containsKey(md5SummaryIdPath.getName())) {
                        long maintainEt = (Long)summaryIdMd5sToKeep.get(md5SummaryIdPath.getName());
                        this.maintainCachesCompactions(md5SummaryIdPath, maintainEt);
                    } else {
                        long pathSize = SummarizeProcessor.this._fs.getContentSummary(md5SummaryIdPath).getLength();
                        SummarizeProcessor.this._fs.delete(md5SummaryIdPath, true);
                        SummarizeProcessor.this.reportDeletedPath(srs, md5SummaryIdPath.toUri().getPath(), pathSize);
                        if (gLogger.isDebugEnabled()) {
                            gLogger.debug((Object)("deleting cache path: " + md5SummaryIdPath));
                        }
                    }
                }
                catch (IOException e) {
                    gLogger.warn((Object)("Exception when deleting cache_path=" + md5SummaryIdPath));
                }
                return true;
            }

            private void maintainCachesCompactions(Path md5SummaryIdPath, long maintainEt) throws IOException {
                for (FileStatus bucketId : SummarizeProcessor.this.hdfsLs(md5SummaryIdPath, new MapCaches.DirFilter(SummarizeProcessor.this._fs))) {
                    try {
                        this.doMaintainCachesCompactions(maintainEt, bucketId.getPath());
                    }
                    catch (Exception e) {
                        gLogger.debug((Object)("Exception=" + e + ", when deleting cache paths"));
                    }
                }
            }

            private void doMaintainCachesCompactions(long maintainEt, Path cachePath) throws IOException {
                HashSet<String> expiredCompactions = new HashSet<String>();
                expiredCompactions.addAll(this.getExpiredCompactions(MapCache.getCompactsDir(cachePath), maintainEt));
                expiredCompactions.addAll(this.getExpiredCompactions(MapCache.getStablesDir(cachePath), maintainEt));
                if (!expiredCompactions.isEmpty()) {
                    if (gLogger.isDebugEnabled()) {
                        gLogger.debug((Object)("Deleting compactions: " + expiredCompactions));
                    }
                    HashMap<String, Long> compactionSizes = new HashMap<String, Long>();
                    for (String compactionPath : expiredCompactions) {
                        compactionSizes.put(compactionPath, SummarizeProcessor.this._fs.getContentSummary(new Path(compactionPath)).getLength());
                    }
                    GroupedDeletionProcessor.createCacheMerger(SummarizeProcessor.this._fs, cachePath).deletePaths(expiredCompactions);
                    for (String compactionPath : expiredCompactions) {
                        SummarizeProcessor.this.reportDeletedPath(srs, compactionPath, (Long)compactionSizes.get(compactionPath));
                    }
                }
            }

            private Set<String> getExpiredCompactions(Path compactionsDir, long maintainEt) throws IOException {
                HashSet<String> oldCompactions = new HashSet<String>();
                for (FileStatus compaction : SummarizeProcessor.this.hdfsLs(compactionsDir, new MapCaches.DirFilter(SummarizeProcessor.this._fs))) {
                    Path compactionPath = compaction.getPath();
                    try {
                        Date expirationDate = MapCache.getCompactionLatestTime(SummarizeProcessor.this._fs, compactionPath);
                        long expirationInSecs = TimeUnit.SECONDS.convert(expirationDate.getTime(), TimeUnit.MILLISECONDS);
                        if (maintainEt <= expirationInSecs) continue;
                        oldCompactions.add(compactionPath.toUri().getPath());
                    }
                    catch (CompactionMetadata.CompactionLtNotFoundException e) {
                        gLogger.debug((Object)("Found compaction with no latest time. Will maintain compaction=" + compactionPath));
                        oldCompactions.add(compactionPath.toUri().getPath());
                    }
                }
                return oldCompactions;
            }
        });
    }

    private FileStatus[] hdfsLs(Path p) throws IOException {
        return HdfsUtil.ls(this._fs, p);
    }

    private FileStatus[] hdfsLs(Path p, PathFilter filter) throws IOException {
        return HdfsUtil.ls(this._fs, p, filter);
    }

    static void forEveryMD5SummaryIdCachePath(FileSystem fs, ObjectAcceptor<Path> cacheInfoFileAcceptor) throws IOException {
        MapCaches.DirFilter dirFilter = new MapCaches.DirFilter(fs);
        Path topLevelCachePath = SplunkMR.getTopLevelCacheDir(fs.getConf());
        for (FileStatus index : HdfsUtil.ls(fs, topLevelCachePath, dirFilter)) {
            for (FileStatus summaryId : HdfsUtil.ls(fs, index.getPath(), dirFilter)) {
                cacheInfoFileAcceptor.accept(summaryId.getPath());
            }
        }
    }

    private void deleteCacheDirsChildren(SearchResults srs) throws IOException {
        Path cacheDir = SplunkMR.getTopLevelCacheDir(this._conf);
        FileStatus[] cacheDirChildren = this.hdfsLs(cacheDir);
        if (cacheDirChildren != null) {
            for (FileStatus f : cacheDirChildren) {
                this._fs.delete(f.getPath(), true);
                this.reportDeletedPath(srs, f.getPath().toUri().getPath(), f.getLen());
            }
        }
    }

    private void reportDeletedPath(SearchResults srs, String path, long size) {
        SearchResults.Result result = srs.addNewResult();
        result.set(DELETED_PATH, (Object)path);
        result.set(DELETED_BYTES, (Object)size);
    }

    static List<IdTimePair> parseMaintainString(String maintain) {
        try {
            return SummarizeProcessor.parseMaintainStringV2(maintain);
        }
        catch (Exception e) {
            gLogger.debug((Object)("Tried parsing maintain string with version 2. Got exception: " + e + ". Trying to parse maintain string version 1."));
            return SummarizeProcessor.parseMaintainStringV1(maintain);
        }
    }

    static List<IdTimePair> parseTstatsMaintainString(String maintain) {
        ArrayList<IdTimePair> pairs = new ArrayList<IdTimePair>();
        if (!maintain.equals("")) {
            for (String tuple : maintain.split(";")) {
                LinkedList<String> fields = new LinkedList<String>(Arrays.asList(tuple.split(",")));
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("fields: " + fields + "Name:" + fields.get(0) + ", ET:" + fields.get(1)));
                }
                pairs.add(new IdTimePair(fields.get(0), fields.get(0), Long.parseLong(fields.get(1))));
            }
        }
        return pairs;
    }

    private static List<IdTimePair> parseMaintainStringV2(String maintain) throws IOException {
        String csvLine;
        ArrayList<IdTimePair> pairs = new ArrayList<IdTimePair>();
        String csvString = URLDecoder.decode(maintain, "UTF-8");
        BufferedReader lineReader = new BufferedReader(new StringReader(csvString));
        String[] header = lineReader.readLine().split(",");
        if (!SummarizeProcessor.validateV2Header(header)) {
            throw new RuntimeException("Maintain string was not version 2. Maintain:=" + maintain);
        }
        while ((csvLine = lineReader.readLine()) != null) {
            String[] parsedCsvLine = StrUtil.parseCSVLine(csvLine, header.length, ',', '\"', '\"');
            String id = parsedCsvLine[0];
            String normId = parsedCsvLine[3];
            long et = Long.parseLong(parsedCsvLine[1]);
            pairs.add(new IdTimePair(id, normId, et));
        }
        return pairs;
    }

    private static boolean validateV2Header(String[] header) {
        return header[0].contains("SUMMARY_ID") && header[1].contains("EARLIEST_TIME") && header[3].contains("NORM_SUMMARY_ID");
    }

    static List<IdTimePair> parseMaintainStringV1(String maintain) {
        ArrayList<IdTimePair> pairs = new ArrayList<IdTimePair>();
        LinkedList<String> fields = new LinkedList<String>(Arrays.asList(maintain.split(",")));
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("fields: " + fields));
        }
        while (!fields.isEmpty()) {
            boolean isMixedWithNextId;
            String summaryId = fields.poll();
            String et = fields.poll();
            String remoteSearch = fields.poll();
            String normSummaryId = fields.poll();
            String normSearch = fields.poll();
            boolean bl = isMixedWithNextId = normSearch != null && !normSearch.endsWith(";");
            if (isMixedWithNextId) {
                String nextId = new LinkedList<String>(Arrays.asList(normSearch.split(";"))).getLast();
                fields.addFirst(nextId);
            }
            pairs.add(new IdTimePair(summaryId, normSummaryId, Long.parseLong(et)));
        }
        return pairs;
    }

    @Override
    public boolean execute(SearchResults srs) {
        if (this.done) {
            return this.done;
        }
        this.done = true;
        try {
            this.executeImpl(srs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownExecutor();
        }
        return this.done;
    }

    public static SummarizeProcessor create(MapCaches mapCaches, VixSplitGenerator tif, Set<String> indexNames) {
        FileSystem fs = mapCaches.getFileSystem();
        return new SummarizeProcessor(fs, fs.getConf(), mapCaches, tif, indexNames);
    }

    public static class IdTimePair {
        public final String id;
        public final String normId;
        public final long et;

        public IdTimePair(String id, String normId, long et) {
            this.id = id;
            this.normId = normId;
            this.et = et;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.et ^ this.et >>> 32);
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdTimePair other = (IdTimePair)obj;
            if (this.et != other.et) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

