/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.RollTransfer;
import com.splunk.roll.RollValidator;
import com.splunk.util.HdfsUtil;
import com.splunk.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.MD5Hash;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class RollReceipt {
    private static final Logger gLogger = Logger.getLogger(RollValidator.class);
    public static final long RECEIPT_VERSION = 1L;
    public static final String NAME_PREFIX = "archive.";
    public static final String NAME_SUFFIX = ".receipt";
    public static final String NAME_KV_DELIM = "_";
    public static final String NAME_KV_CONTENT_MD5 = "content-md5";
    private final Configuration conf;
    private final ObjectMapper jsonMapper;

    public RollReceipt(Configuration conf) {
        this.conf = conf;
        this.jsonMapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReceipt(Path path, JsonNode receipt) throws IOException {
        FileSystem fs = path.getFileSystem(this.conf);
        final String receiptString = this.jsonMapper.writeValueAsString(this.jsonMapper.treeToValue(receipt, Map.class));
        String name = RollReceipt.getReceiptName((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(RollReceipt.NAME_KV_CONTENT_MD5, MD5Hash.digest((String)receiptString).toString());
            }
        });
        FSDataOutputStream created = null;
        try {
            created = fs.create(new Path(path, name), true);
            IOUtils.write((String)receiptString, (OutputStream)created);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(created);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)created);
    }

    static String getReceiptName(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME_PREFIX);
        ArrayList<String> kvs = new ArrayList<String>();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            RollReceipt.validateEntry(e);
            kvs.add(e.getKey());
            kvs.add(e.getValue());
        }
        sb.append(StringUtils.join(kvs, (String)NAME_KV_DELIM));
        sb.append(NAME_SUFFIX);
        return sb.toString();
    }

    private static void validateEntry(Map.Entry<String, String> e) {
        if (e.getKey().contains(NAME_KV_DELIM) || e.getValue().contains(NAME_KV_DELIM)) {
            throw new IllegalArgumentException("Roll receipt cannot contain KV delimiter: _");
        }
    }

    static Map<String, String> getReceiptNameProperties(String receiptName) {
        HashMap<String, String> m = new HashMap<String, String>();
        String[] kvs = StringUtils.split((String)RollReceipt.stripPreAndSuffixFromName(receiptName), (String)NAME_KV_DELIM);
        for (int i = 0; i < kvs.length; i += 2) {
            m.put(kvs[i], kvs[i + 1]);
        }
        return m;
    }

    private static String stripPreAndSuffixFromName(String receiptName) {
        return StringUtils.substringBetween((String)receiptName, (String)NAME_PREFIX, (String)NAME_SUFFIX);
    }

    public JsonNode createReceipt(Path root, List<RollTransfer> transfers) throws IOException {
        return JsonUtil.valueToTree(this.jsonMapper, RollReceipt.createReceiptMap(root, transfers));
    }

    private static Map createReceiptMap(final Path root, final List<RollTransfer> transfers) throws IOException {
        return new HashMap<String, Object>(){
            {
                this.put("version", 1L);
                this.put("data", new HashMap<String, Object>(){
                    {
                        ArrayList<1> paths = new ArrayList<1>();
                        this.put("files", paths);
                        for (final RollTransfer transfer : transfers) {
                            paths.add(new HashMap<String, String>(){
                                {
                                    this.put("path", RollReceipt.getRelativePath(root, transfer.path));
                                    this.put("size", String.valueOf(transfer.size));
                                }
                            });
                        }
                    }
                });
            }
        };
    }

    private static String getRelativePath(Path root, Path path) {
        String relativePath = StringUtils.removeStart((String)path.toUri().getPath(), (String)root.toUri().getPath());
        if (relativePath.startsWith("/")) {
            return StringUtils.removeStart((String)relativePath, (String)"/");
        }
        return relativePath;
    }

    public boolean validatePath(Path root, boolean deleteInvalidReceipts) throws IOException {
        FileSystem fs = root.getFileSystem(this.conf);
        List<FileStatus> receipts = RollReceipt.getReceipts(this.conf, root);
        for (FileStatus receipt : receipts) {
            Path receiptPath = receipt.getPath();
            String receiptString = this.fileToString(fs, receiptPath);
            if (this.isValidReceipt(receiptString, receiptPath) && this.verifyFilesInPath(root, this.jsonMapper.readTree(receiptString))) {
                return true;
            }
            if (!deleteInvalidReceipts) continue;
            fs.delete(receiptPath, false);
        }
        return false;
    }

    private boolean isValidReceipt(String receiptString, Path receiptPath) throws IOException {
        MD5Hash jsonMD5 = MD5Hash.digest((String)receiptString);
        Map<String, String> properties = RollReceipt.getReceiptNameProperties(receiptPath.getName());
        String nameMD5 = properties.get(NAME_KV_CONTENT_MD5);
        return jsonMD5.toString().equals(nameMD5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileToString(FileSystem fs, Path path) throws IOException {
        FSDataInputStream in = null;
        try {
            in = fs.open(path);
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    static List<FileStatus> getReceipts(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        return Arrays.asList(HdfsUtil.ls(fs, path, new PathFilter(){

            public boolean accept(Path path) {
                String filename = path.getName();
                return filename.startsWith(RollReceipt.NAME_PREFIX) && filename.endsWith(RollReceipt.NAME_SUFFIX);
            }
        }));
    }

    private boolean verifyFilesInPath(Path root, JsonNode receipt) throws IOException {
        FileSystem fs = root.getFileSystem(this.conf);
        try {
            Iterator files = receipt.path("data").path("files").iterator();
            if (!files.hasNext()) {
                return false;
            }
            while (files.hasNext()) {
                JsonNode file = (JsonNode)files.next();
                Path p = new Path(root, file.path("path").getValueAsText());
                FileStatus fileStatus = fs.getFileStatus(p);
                if (fileStatus.getLen() == Long.parseLong(file.path("size").getValueAsText())) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            gLogger.debug((Object)("Validation failed because of exception: " + e));
            return false;
        }
    }
}

