/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.metrics;

import com.splunk.logging.HttpEventCollectorSender;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.TaskInfo;
import scala.Function0;
import scala.collection.Seq;
import scala.runtime.AbstractFunction0;

public class SparkMetricsListener
extends SparkListener {
    private Map<Integer, Integer> stageToJob = new HashMap<Integer, Integer>();
    private Map<Integer, String> stageNames = new HashMap<Integer, String>();
    private Map<Integer, Long> jobStartTimes = new HashMap<Integer, Long>();
    private String appId;
    private String appName;
    private final String SEQUENTIAL_SEND_MODE = "sequential";
    private final String DEFAULT_CHANNEL = "";
    private final String DEFAULT_EVENT_TYPE = "";
    private final HttpEventCollectorSender splunkSender;
    Function0<Long> longValue = new AbstractFunction0<Long>(){

        public Long apply() {
            return 0L;
        }
    };

    public SparkMetricsListener(SparkConf conf) {
        this.splunkSender = new HttpEventCollectorSender(conf.get("spark.metrics.conf.*.sink.splunk.url"), conf.get("spark.metrics.conf.*.sink.splunk.token"), "", "", 10000L, 10L, 10240L, "sequential", this.getMetadata());
        this.splunkSender.disableCertificateValidation();
    }

    public void onJobStart(SparkListenerJobStart event) {
        this.stageToJob.clear();
        this.stageNames.clear();
        int jobId = event.jobId();
        Seq stageIds = event.stageIds();
        this.jobStartTimes.put(jobId, event.time());
    }

    public void onJobEnd(SparkListenerJobEnd event) {
        int jobId = event.jobId();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("appId", this.appId);
        fields.put("appName", this.appName);
        fields.put("jobId", String.valueOf(jobId));
        fields.put("launchTime", Long.toString(this.jobStartTimes.get(jobId)));
        fields.put("completionTime", Long.toString(event.time()));
        fields.put("duration", Long.toString(event.time() - this.jobStartTimes.get(jobId)));
        this.splunkSender.send("", "Job", "", "", fields, "", (Serializable)((Object)""));
        this.splunkSender.flush();
    }

    public void onApplicationStart(SparkListenerApplicationStart event) {
        this.appId = (String)event.appId().getOrElse((Function0)new AbstractFunction0<String>(){

            public String apply() {
                return "missing";
            }
        });
        this.appName = event.appName();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("appId", this.appId);
        fields.put("appName", this.appName);
        fields.put("launchTime", Long.toString(event.time()));
        this.splunkSender.send("", "ApplicationStart", "", "", fields, "", (Serializable)((Object)""));
        this.splunkSender.flush();
    }

    public void onApplicationEnd(SparkListenerApplicationEnd event) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("appId", this.appId);
        fields.put("appName", this.appName);
        fields.put("completionTime", Long.toString(event.time()));
        this.splunkSender.send("", "ApplicationEnd", "", "", fields, "", (Serializable)((Object)""));
        this.splunkSender.flush();
    }

    public void onStageCompleted(SparkListenerStageCompleted event) {
        StageInfo stageInfo = event.stageInfo();
        this.stageNames.put(stageInfo.stageId(), stageInfo.name());
        this.reportStageMetricsToSplunk(stageInfo, "Stage");
    }

    public void onTaskEnd(SparkListenerTaskEnd event) {
        TaskInfo taskInfo = event.taskInfo();
        TaskMetrics taskMetrics = event.taskMetrics();
        int stageId = event.stageId();
        int jobId = this.stageToJob.get(stageId);
        String stageName = this.stageNames.get(stageId);
        this.reportTaskMetricsToSplunk(jobId, stageId, stageName, "Task", taskInfo, taskMetrics);
    }

    private void reportStageMetricsToSplunk(StageInfo stageInfo, String eventName) {
        TaskMetrics taskMetrics = stageInfo.taskMetrics();
        int stageId = stageInfo.stageId();
        int jobId = this.stageToJob.get(stageId);
        String stageName = stageInfo.name();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("appId", this.appId);
        fields.put("appName", this.appName);
        fields.put("stageName", stageName);
        fields.put("jobId", Integer.toString(jobId));
        fields.put("stageId", Integer.toString(stageId));
        fields.put("numTasks", Integer.toString(stageInfo.numTasks()));
        fields.put("launchTime", Long.toString((Long)stageInfo.submissionTime().getOrElse(this.longValue)));
        fields.put("completionTime", Long.toString((Long)stageInfo.completionTime().getOrElse(this.longValue)));
        fields.put("duration", Long.toString((Long)stageInfo.completionTime().getOrElse(this.longValue) - (Long)stageInfo.submissionTime().getOrElse(this.longValue)));
        this.addTaskMetrics(fields, taskMetrics);
        this.splunkSender.send("", eventName, "", "", fields, "", (Serializable)((Object)""));
        this.splunkSender.flush();
    }

    private void reportTaskMetricsToSplunk(int jobId, int stageId, String stageName, String eventName, TaskInfo taskInfo, TaskMetrics taskMetrics) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("appId", this.appId);
        fields.put("appName", this.appName);
        fields.put("stageName", stageName);
        fields.put("jobId", Integer.toString(jobId));
        fields.put("stageId", Integer.toString(stageId));
        fields.put("taskId", Long.toString(taskInfo.taskId()));
        fields.put("launchTime", Long.toString(taskInfo.launchTime()));
        fields.put("completionTime", Long.toString(taskInfo.finishTime()));
        fields.put("failed", Boolean.toString(taskInfo.failed()));
        fields.put("finished", Boolean.toString(taskInfo.finished()));
        fields.put("executorId", taskInfo.executorId());
        fields.put("hostId", taskInfo.host());
        fields.put("id", taskInfo.id());
        fields.put("status", taskInfo.status());
        fields.put("duration", Long.toString(taskInfo.duration()));
        fields.put("speculative", Boolean.toString(taskInfo.speculative()));
        fields.put("successful", Boolean.toString(taskInfo.successful()));
        fields.put("running", Boolean.toString(taskInfo.running()));
        fields.put("killed", Boolean.toString(taskInfo.killed()));
        fields.put("locality", taskInfo.taskLocality().toString());
        this.addTaskMetrics(fields, taskMetrics);
        this.splunkSender.send("", eventName, "", "", fields, "", (Serializable)((Object)""));
        this.splunkSender.flush();
    }

    private void addTaskMetrics(HashMap<String, String> fields, TaskMetrics tm) {
        fields.put("executorRunTime", Long.toString(tm.executorRunTime()));
        fields.put("executorCpuTime", Long.toString(tm.executorCpuTime()));
        fields.put("executorDeserializeCpuTime", Long.toString(tm.executorDeserializeCpuTime()));
        fields.put("executorDeserializeTime", Long.toString(tm.executorDeserializeTime()));
        fields.put("resultSize", Long.toString(tm.resultSize()));
        fields.put("resultSerializationTime", Long.toString(tm.resultSerializationTime()));
        fields.put("jvmGCTime", Long.toString(tm.jvmGCTime()));
        fields.put("diskBytesSpilled", Long.toString(tm.diskBytesSpilled()));
        fields.put("memoryBytesSpilled", Long.toString(tm.memoryBytesSpilled()));
        fields.put("peakExecutionMemory", Long.toString(tm.peakExecutionMemory()));
        fields.put("recordsRead", Long.toString(tm.inputMetrics().recordsRead()));
        fields.put("bytesRead", Long.toString(tm.inputMetrics().bytesRead()));
        fields.put("recordsWritten", Long.toString(tm.outputMetrics().recordsWritten()));
        fields.put("bytesWritten", Long.toString(tm.outputMetrics().bytesWritten()));
        fields.put("shuffleFetchWaitTime", Long.toString(tm.shuffleReadMetrics().fetchWaitTime()));
        fields.put("shuffleLocalBytesRead", Long.toString(tm.shuffleReadMetrics().localBytesRead()));
        fields.put("shuffleRemoteBytesRead", Long.toString(tm.shuffleReadMetrics().remoteBytesRead()));
        fields.put("shuffleTotalBytesRead", Long.toString(tm.shuffleReadMetrics().totalBytesRead()));
        fields.put("shuffleLocalBlocksFetched", Long.toString(tm.shuffleReadMetrics().localBlocksFetched()));
        fields.put("shuffleRemoteBlocksFetched", Long.toString(tm.shuffleReadMetrics().remoteBlocksFetched()));
        fields.put("shuffleTotalBlocksFetched", Long.toString(tm.shuffleReadMetrics().totalBlocksFetched()));
        fields.put("shuffleBytesWritten", Long.toString(tm.shuffleWriteMetrics().bytesWritten()));
        fields.put("shuffleRecordsWritten", Long.toString(tm.shuffleWriteMetrics().recordsWritten()));
        fields.put("shuffleWriteTime", Long.toString(tm.shuffleWriteMetrics().writeTime()));
    }

    private Hashtable<String, String> getMetadata() {
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        try {
            String host = InetAddress.getLocalHost().getHostName();
            metadata.put("host", host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metadata;
    }
}

