/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.metrics;

import com.codahale.metrics.MetricRegistry;
import com.splunk.df.metrics.SplunkReporter;
import com.splunk.logging.HttpEventCollectorSender;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.sink.Sink;

public class SplunkSink
implements Sink {
    private final String url;
    private final String token;
    private final long pollPeriod;
    private final TimeUnit pollUnit;
    private final String SEQUENTIAL_SEND_MODE = "sequential";
    private final String DEFAULT_CHANNEL = "";
    private final String DEFAULT_EVENT_TYPE = "";
    private final HttpEventCollectorSender sender;
    SplunkReporter reporter;

    public SplunkSink(Properties properties, MetricRegistry registry, SecurityManager manager) throws MalformedURLException, InvalidPropertiesFormatException {
        properties.list(System.out);
        this.pollPeriod = this.getPeriod(properties);
        this.pollUnit = this.getUnit(properties);
        this.token = properties.getProperty("token");
        this.url = properties.getProperty("url");
        this.validateProperties();
        Hashtable<String, String> metadata = this.getMetadata();
        this.sender = new HttpEventCollectorSender(this.url, this.token, "", "", 10000L, 10L, 10240L, "sequential", metadata);
        this.sender.disableCertificateValidation();
        this.reporter = SplunkReporter.forRegistry(registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).groupGauges(true).build(this.sender);
    }

    private Hashtable<String, String> getMetadata() {
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        try {
            String host = InetAddress.getLocalHost().getHostName();
            metadata.put("host", host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metadata;
    }

    private long getPeriod(Properties properties) {
        String v = properties.getProperty("period");
        return v == null ? 10L : Long.parseLong(v);
    }

    private TimeUnit getUnit(Properties properties) {
        String v = properties.getProperty("unit");
        return v == null ? TimeUnit.SECONDS : TimeUnit.valueOf(v.toUpperCase(Locale.US));
    }

    private void validateProperties() throws InvalidPropertiesFormatException {
        if (this.token == null || this.url == null) {
            throw new InvalidPropertiesFormatException("url and token are required fields");
        }
    }

    public void start() {
        this.reporter.start(this.pollPeriod, this.pollUnit);
    }

    public void stop() {
        this.reporter.stop();
    }

    public void report() {
        this.reporter.report();
    }
}

