/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.google.common.util.concurrent.FutureCallback;
import com.splunk.df.search.DFSSearchConstants;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class DFCCallable
implements Callable,
DFSSearchConstants,
FutureCallback {
    private static final Logger _logger = Logger.getLogger(DFCCallable.class);
    private boolean exit = true;

    public DFCCallable() {
    }

    public DFCCallable(boolean exitJVM) {
        this.exit = exitJVM;
    }

    public Object call() throws Exception {
        return this.runInternal();
    }

    public void onSuccess(Object result) {
        try {
            this.runOnSuccess(result);
        }
        catch (Throwable throwable) {
            _logger.error((Object)String.format("Error executing running task: %s", throwable.getMessage()), throwable);
        }
        finally {
            this.cleanup();
        }
    }

    public void onFailure(Throwable t) {
        try {
            this.runOnFailure(t);
        }
        catch (Throwable throwable) {
            _logger.error((Object)String.format("Error executing running task: %s", throwable.getMessage()), throwable);
            t.printStackTrace();
        }
        finally {
            if (this.exit) {
                _logger.error((Object)"Exiting DFC due to failure of one of the critical threads");
                System.exit(-1);
            }
        }
    }

    protected abstract Object runInternal() throws Exception;

    protected Object runOnSuccess(Object result) {
        return null;
    }

    protected Object runOnFailure(Throwable t) throws Exception {
        return null;
    }

    protected void cleanup() {
    }
}

