/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import org.json.JSONObject;

public class DFCParams {
    private final String dfcTitle;
    private final String dfcId;
    private final int dfcPort;
    private final int dfwReceivingDataPort;
    private final int dfwReceivingDataPortCount;
    private final int dfmMasterPort;
    private final String sid;
    private final int dfcNumCores;
    private final int dfcNumExecutors;
    private final int dfcExecutorMemMbs;
    private final int dfcDriverMemMbs;
    private final int dfcCoresPerExecutor;
    private final int dfcNumConcurrentSearches;
    private final long maxReducePartitionSize;
    private final String splunkConf;
    private final String splunkVersion;
    private final String extraKryoClasses;
    private final long maxSearchResultSize;
    private boolean isDfsInstrumentationEnabled;
    private int dfsInstrumentationMode;
    private String dfsInstrumentationHecEndpoint;
    private String dfsInstrumentationHecToken;
    private final long dfcLaunchTimeMillis;
    private final boolean lowLatencyMode;
    private final int dfcDriverCores;
    private final int dfwToDfcAuthRetryTimes;
    private final int sslConfigServerSocketBacklogSize;
    private final int rdinServerSocketBacklogSize;
    private final long dfsRemoteSearchTimeoutSec;

    public DFCParams(String dfcTitle, String dfcId, int dfcPort, long maxSearchResultSize, long maxReducePartitionSize, int dfwReceivingDataPort, int dfwReceivingDataPortCount, int dfmMasterPort, String sid, int dfcNumCores, int dfcNumExecutors, int dfcExecutorMemMbs, int dfcDriverMemMbs, int dfcCoresPerExecutor, int dfcNumConcurrentSearches, String splunkVersion, String extraKryoClasses, String splunkConf, boolean isDfsInstrumentationEnabled, int dfsInstrumentationMode, String dfsInstrumentationHecEndpoint, String dfsInstrumentationHecToken, long dfcLaunchTimeMillis, boolean lowLatencyMode, int dfcDriverCores, int dfwToDfcAuthRetryTimes, int sslConfigServerSocketBacklogSize, int rdinServerSocketBacklogSize, long dfsRemoteSearchTimeoutSec) {
        this.dfcTitle = dfcTitle;
        this.dfcId = dfcId;
        this.dfcPort = dfcPort;
        this.maxSearchResultSize = maxSearchResultSize;
        this.maxReducePartitionSize = maxReducePartitionSize;
        this.dfwReceivingDataPort = dfwReceivingDataPort;
        this.dfwReceivingDataPortCount = dfwReceivingDataPortCount;
        this.dfmMasterPort = dfmMasterPort;
        this.sid = sid;
        this.dfcNumCores = dfcNumCores;
        this.dfcNumExecutors = dfcNumExecutors;
        this.dfcExecutorMemMbs = dfcExecutorMemMbs;
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.dfcCoresPerExecutor = dfcCoresPerExecutor;
        this.dfcNumConcurrentSearches = dfcNumConcurrentSearches;
        this.splunkConf = splunkConf;
        this.splunkVersion = splunkVersion;
        this.extraKryoClasses = extraKryoClasses;
        this.isDfsInstrumentationEnabled = isDfsInstrumentationEnabled;
        this.dfsInstrumentationMode = dfsInstrumentationMode;
        this.dfsInstrumentationHecEndpoint = dfsInstrumentationHecEndpoint;
        this.dfsInstrumentationHecToken = dfsInstrumentationHecToken;
        this.dfcLaunchTimeMillis = dfcLaunchTimeMillis;
        this.lowLatencyMode = lowLatencyMode;
        this.dfcDriverCores = dfcDriverCores;
        this.dfwToDfcAuthRetryTimes = dfwToDfcAuthRetryTimes;
        this.sslConfigServerSocketBacklogSize = sslConfigServerSocketBacklogSize;
        this.rdinServerSocketBacklogSize = rdinServerSocketBacklogSize;
        this.dfsRemoteSearchTimeoutSec = dfsRemoteSearchTimeoutSec;
    }

    public String getExtraKryoClasses() {
        return this.extraKryoClasses;
    }

    public String getDfcTitle() {
        return this.dfcTitle;
    }

    public String getDfcId() {
        return this.dfcId;
    }

    public int getDfcPort() {
        return this.dfcPort;
    }

    public long getMaxReducePartitionSize() {
        return this.maxReducePartitionSize;
    }

    public int getDfwReceivingDataPort() {
        return this.dfwReceivingDataPort;
    }

    public int getDfwReceivingDataPortCount() {
        return this.dfwReceivingDataPortCount;
    }

    public int getDfmMasterPort() {
        return this.dfmMasterPort;
    }

    public String getSid() {
        return this.sid;
    }

    public int getDfcNumCores() {
        return this.dfcNumCores;
    }

    public int getDfcNumExecutors() {
        return this.dfcNumExecutors;
    }

    public int getDfcExecutorMemMbs() {
        return this.dfcExecutorMemMbs;
    }

    public int getDfcDriverMemMbs() {
        return this.dfcDriverMemMbs;
    }

    public int getDfcNumConcurrentSearches() {
        return this.dfcNumConcurrentSearches;
    }

    public long getDfcLaunchTimeMillis() {
        return this.dfcLaunchTimeMillis;
    }

    public boolean getLowLatencyMode() {
        return this.lowLatencyMode;
    }

    public int getDfcDriverCores() {
        return this.dfcDriverCores;
    }

    public String getSplunkConf() {
        return this.splunkConf;
    }

    public String getSplunkVersion() {
        return this.splunkVersion;
    }

    public long getMaxSearchResultSize() {
        return this.maxSearchResultSize;
    }

    public boolean isDfsInstrumentationEnabled() {
        return this.isDfsInstrumentationEnabled;
    }

    public int getDfsInstrumentationMode() {
        return this.dfsInstrumentationMode;
    }

    public String getDfsInstrumentationHecEndpoint() {
        return this.dfsInstrumentationHecEndpoint;
    }

    public String getDfsInstrumentationHecToken() {
        return this.dfsInstrumentationHecToken;
    }

    public int getDfwToDfcAuthRetryTimes() {
        return this.dfwToDfcAuthRetryTimes;
    }

    public int getSslConfigServerSocketBacklogSize() {
        return this.sslConfigServerSocketBacklogSize;
    }

    public int getRdinServerSocketBacklogSize() {
        return this.rdinServerSocketBacklogSize;
    }

    public long getDfsRemoteSearchTimeoutSec() {
        return this.dfsRemoteSearchTimeoutSec;
    }

    public String toString() {
        return String.format("{ dfcTitle:\"%s\", dfcId:\"%s\", dfcPort:%d, maxSearchResultSize: %d , maxReducePartitionSize: %d , dfwReceivingDataPort:%d, dfwReceivingDataPortCount:%d, dfmMasterPort:%d, sid:\"%s\", dfcNumCores:%d, dfcNumExecutors:%d, dfcExecutorMemMbs:%d, dfcDriverMemMbs: %d, dfcCoresPerExecutor: %d, dfcNumConcurrentSearches: %d , dfcLaunchTimeMillis: %d , splunkVersion:%s, lowLatencyMode:%b, dfcDriverCores:%d" + (this.hasExtraKryoClasses() ? ", extraKryoClasses:%s" : "%s") + ", " + "splunkConf" + ": %s, dfwToDfcAuthRetryTimes:%d, sslConfigServerSocketBacklogSize:%d, rdinServerSocketBacklogSize:%d, dfsRemoteSearchTimeoutSec:%d}", this.dfcTitle, this.dfcId, this.dfcPort, this.maxSearchResultSize, this.maxReducePartitionSize, this.dfwReceivingDataPort, this.dfwReceivingDataPortCount, this.dfmMasterPort, this.sid, this.dfcNumCores, this.dfcNumExecutors, this.dfcExecutorMemMbs, this.dfcDriverMemMbs, this.dfcCoresPerExecutor, this.dfcNumConcurrentSearches, this.dfcLaunchTimeMillis, this.splunkVersion, this.lowLatencyMode, this.dfcDriverCores, this.hasExtraKryoClasses() ? "\"" + this.extraKryoClasses + "\"" : "", this.splunkConf, this.dfwToDfcAuthRetryTimes, this.sslConfigServerSocketBacklogSize, this.rdinServerSocketBacklogSize, this.dfsRemoteSearchTimeoutSec);
    }

    public String toJson() {
        return this.toString();
    }

    public static DFCParams fromJson(String json) {
        JSONObject jsonObj = new JSONObject(json);
        String dfcTitle = jsonObj.getString("dfcTitle");
        String dfcId = jsonObj.getString("dfcId");
        int dfcPort = jsonObj.getInt("dfcPort");
        long maxSearchResultSize = jsonObj.getLong("maxSearchResultSize");
        long maxReducePartitionSize = jsonObj.getLong("maxReducePartitionSize");
        int dfwReceivingDataPort = jsonObj.getInt("dfwReceivingDataPort");
        int dfwReceivingDataPortCount = jsonObj.getInt("dfwReceivingDataPortCount");
        int dfmMasterPort = jsonObj.getInt("dfmMasterPort");
        String sid = jsonObj.getString("sid");
        int dfcNumCores = jsonObj.getInt("dfcNumCores");
        int dfcNumExecutors = jsonObj.getInt("dfcNumExecutors");
        int dfcExecutorMemMbs = jsonObj.getInt("dfcExecutorMemMbs");
        int dfcDriverMemMbs = jsonObj.getInt("dfcDriverMemMbs");
        int dfcCoresPerExecutor = jsonObj.getInt("dfcCoresPerExecutor");
        int dfcNumConcurrentSearches = jsonObj.getInt("dfcNumConcurrentSearches");
        long dfcLaunchTimeMillis = jsonObj.getLong("dfcLaunchTimeMillis");
        String splunkVersion = jsonObj.getString("splunkVersion");
        boolean lowLatencyMode = jsonObj.getBoolean("lowLatencyMode");
        int dfcDriverCores = jsonObj.getInt("dfcDriverCores");
        String extraKryoClasses = jsonObj.has("extraKryoClasses") ? jsonObj.getString("extraKryoClasses") : "";
        String splunkConf = jsonObj.getJSONObject("splunkConf").toString();
        int dfwToDfcAuthRetryTimes = jsonObj.getInt("dfwToDfcAuthRetryTimes");
        int sslConfigServerSocketBacklogSize = jsonObj.getInt("sslConfigServerSocketBacklogSize");
        int rdinServerSocketBacklogSize = jsonObj.getInt("rdinServerSocketBacklogSize");
        long dfsRemoteSearchTimeoutSec = jsonObj.getLong("dfsRemoteSearchTimeoutSec");
        JSONObject dfsExecution = jsonObj.getJSONObject("splunkConf").getJSONObject("limits").getJSONObject("dfs");
        boolean isDfsInstrumentionEnabled = dfsExecution.optBoolean("dfs_instrumentation_enabled", false);
        int dfsInstrumentationMode = dfsExecution.optInt("dfs_instrumentation_mode", -1);
        String dfsInstrumentationHecEndpoint = dfsExecution.optString("dfs_instrumentation_hec_endpoint", "");
        String dfsInstrumentationHecToken = dfsExecution.optString("dfs_instrumentation_hec_token", "");
        return new DFCParams(dfcTitle, dfcId, dfcPort, maxSearchResultSize, maxReducePartitionSize, dfwReceivingDataPort, dfwReceivingDataPortCount, dfmMasterPort, sid, dfcNumCores, dfcNumExecutors, dfcExecutorMemMbs, dfcDriverMemMbs, dfcCoresPerExecutor, dfcNumConcurrentSearches, splunkVersion, extraKryoClasses, splunkConf, isDfsInstrumentionEnabled, dfsInstrumentationMode, dfsInstrumentationHecEndpoint, dfsInstrumentationHecToken, dfcLaunchTimeMillis, lowLatencyMode, dfcDriverCores, dfwToDfcAuthRetryTimes, sslConfigServerSocketBacklogSize, rdinServerSocketBacklogSize, dfsRemoteSearchTimeoutSec);
    }

    private boolean hasExtraKryoClasses() {
        return this.extraKryoClasses != null && !"".equals(this.extraKryoClasses.trim());
    }
}

