/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.util.HashMap;
import java.util.Map;

public enum DFSExecutionState {
    LOCAL_ONLY(1),
    FEDERATED_ONLY(2),
    MIXED_MODE(3),
    UNKNOWN(4);

    public final int finalId;
    private static Map<Integer, DFSExecutionState> lookupCache;
    private static boolean isCacheFilled;

    private DFSExecutionState(int id) {
        this.finalId = id;
    }

    private static void lazyFillCache() {
        HashMap<Integer, DFSExecutionState> localC = new HashMap<Integer, DFSExecutionState>();
        for (DFSExecutionState searchStatus : DFSExecutionState.values()) {
            localC.put(searchStatus.finalId, searchStatus);
        }
        lookupCache = localC;
        isCacheFilled = true;
    }

    public static DFSExecutionState getSearchState(int lookupVal) {
        if (!isCacheFilled) {
            DFSExecutionState.lazyFillCache();
        }
        return lookupCache.get(lookupVal);
    }

    static {
        lookupCache = null;
        isCacheFilled = false;
    }
}

