/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.splunk.df.search.DFCCallable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DFSExecutorService {
    private final ListeningExecutorService executorService;

    public DFSExecutorService() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    public DFSExecutorService(int size) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(size));
    }

    public ListenableFuture submit(DFCCallable dfcCallable) {
        ListenableFuture listenableFuture = this.executorService.submit((Callable)dfcCallable);
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)dfcCallable);
        return listenableFuture;
    }
}

