/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.ast.JsonParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandOrderInfo;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.DedupCommand;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.NoOpCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.ReverseCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.TailCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.commons.visitors.ValidationVisitor;
import com.splunk.df.search.DFSExecutionState;
import com.splunk.df.search.DFSSidGenerator;
import com.splunk.df.search.FSHJobsMapInfo;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSVisitorUtil;
import com.splunk.df.util.SidMetaInfoUtil;
import com.splunk.df.util.Utils;
import com.splunk.df.visitors.ColumnOrderVisitor;
import com.splunk.df.visitors.DFSSearchValidationVisitor;
import com.splunk.df.visitors.FieldListAdditionVisitor;
import com.splunk.df.visitors.FunctionValidationVisitor;
import com.splunk.df.visitors.JobPartitionerVisitor;
import com.splunk.df.visitors.OrderInfoVisitor;
import com.splunk.df.visitors.PartitionExtractionVisitor;
import com.splunk.df.visitors.RequiredFieldsOrderVisitor;
import com.splunk.df.visitors.ScaleFederationUpdateVisitor;
import com.splunk.df.visitors.SortFieldsValidationVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DFSPhaseFacilitator
implements Serializable {
    static final Logger logger = Logger.getLogger(DFSPhaseFacilitator.class);
    private CommandNode searchQuery;
    private SplFormatter formatter;
    private CommandNode splunkSHJob;
    private CommandNode dfsJob;
    private ArrayList<CommandNode> rdinJobs;
    private ArrayList<CommandNode> internalJobs;
    private ArrayList<CommandOrderInfo> orderInfo;
    private ArrayList<String> columnOrder;
    private DFSSidGenerator dfsSidGenerator;
    private boolean shouldShortCircuit;
    private boolean startPaused;
    private boolean canExecuteInLowLatencyMode = true;
    private ArrayList<String> unsupportedCmdsInLowLatencyMode = new ArrayList();
    private boolean boostPartitions = false;
    private boolean errorState = false;
    private String errorMessage;
    private int numberOfRequiredFields;
    private DFSExecutionState currentDFSExecutionState;
    private HashMap<Integer, FederatedDataSetInfo> datasetInfoMap;
    private boolean headN;

    public DFSPhaseFacilitator(JSONObject astJsonObj) {
        try {
            this.searchQuery = (CommandNode)new JsonParser(false, false).parse(astJsonObj);
        }
        catch (Exception e) {
            logger.error((Object)("Search parser failed in library: " + e.getMessage()));
            throw new UnsupportedOperationException("DFS search failed because it is not supported by the search parser.");
        }
        this.init();
    }

    public boolean canExecuteInLowLatencyMode() {
        return this.canExecuteInLowLatencyMode;
    }

    public DFSPhaseFacilitator(CommandNode query) {
        this.searchQuery = query;
        this.init();
    }

    public DFSPhaseFacilitator(CommandNode query, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap) {
        this.searchQuery = query;
        this.datasetInfoMap = datasetInfoMap;
        this.init();
    }

    public DFSPhaseFacilitator(JSONObject astJsonObj, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap) {
        try {
            this.searchQuery = (CommandNode)new JsonParser(false, false).parse(astJsonObj);
        }
        catch (Exception e) {
            logger.error((Object)("Search parser failed in library: " + e.getMessage()));
            throw new UnsupportedOperationException("DFS search failed because it is not supported by the search parser.");
        }
        this.datasetInfoMap = datasetInfoMap;
        this.init();
    }

    private void init() {
        this.formatter = new SplFormatter();
        this.splunkSHJob = null;
        this.dfsJob = null;
        this.internalJobs = null;
        this.orderInfo = new ArrayList();
        this.columnOrder = new ArrayList();
        this.currentDFSExecutionState = DFSExecutionState.UNKNOWN;
        this.dfsSidGenerator = new DFSSidGenerator(SidMetaInfoUtil.getInstance().getShSignature(), SidMetaInfoUtil.getInstance().getSid(), SidMetaInfoUtil.getInstance().getSidOffSet());
        this.headN = false;
        this.numberOfRequiredFields = 0;
    }

    public int getNumberOfRequiredFields() {
        return this.numberOfRequiredFields;
    }

    public DFSExecutionState getCurrentDFSExecutionState() {
        return this.currentDFSExecutionState;
    }

    public ArrayList<CommandOrderInfo> getOrderForSearchPhases() {
        return this.orderInfo;
    }

    public ArrayList<String> getColumnOrder() {
        return this.columnOrder;
    }

    public void setHeadN(boolean headn) {
        this.headN = headn;
    }

    public boolean isInErrorState() {
        return this.errorState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ArrayList<CommandNode> getRemoteSearchCommandNode() {
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            assert (this.internalJobs == null);
            return null;
        }
        assert (!this.internalJobs.isEmpty());
        return this.internalJobs;
    }

    public String[] getRemoteSearchJobs() {
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            assert (this.internalJobs == null);
            return null;
        }
        assert (!this.internalJobs.isEmpty());
        String[] remoteSearches = new String[this.internalJobs.size()];
        int index = 0;
        for (CommandNode cn : this.internalJobs) {
            remoteSearches[index] = (String)cn.accept((NodeVisitor)this.formatter);
            logger.debug((Object)String.format("command node: %s, remote search: %s", cn.getCommandName(), cn.accept((NodeVisitor)this.formatter)));
            ++index;
        }
        return remoteSearches;
    }

    public int getNumberOfRemoteSearches() {
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            assert (this.internalJobs == null);
            return 0;
        }
        return this.internalJobs.size();
    }

    public String getSHSearchPhase() {
        return (String)this.splunkSHJob.accept((NodeVisitor)this.formatter);
    }

    public boolean isSHSearchPhasePresent() {
        return this.splunkSHJob != null;
    }

    public CommandNode getDFSPhase() {
        assert (this.dfsJob != null);
        return this.dfsJob;
    }

    public boolean isSearchStartPaused() {
        return this.shouldShortCircuit;
    }

    public boolean isShortCircuit() {
        return this.shouldShortCircuit;
    }

    public String getFSHBaseTriggerSid() {
        return this.dfsSidGenerator.getFshBaseSid();
    }

    public ArrayList<String> getToSendSidList() {
        return this.dfsSidGenerator.getToSendSidList();
    }

    public ArrayList<String> getRemoteSidList() {
        return this.dfsSidGenerator.getRemoteSidList();
    }

    public ArrayList<String> getFSHRemoteSidList() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.addAll(this.dfsSidGenerator.getFSHRemoteSidList());
        toReturn.addAll(this.dfsSidGenerator.getScaledFSHSidList());
        return toReturn;
    }

    public ArrayList<String> getFSHScaledToSendRemoteSidList() {
        return this.dfsSidGenerator.getScaledFSHToSendSidList();
    }

    public ArrayList<String> getFSHScaledSidList() {
        return this.dfsSidGenerator.getScaledFSHSidList();
    }

    public void generatePhasesForScaledExecution(FSHJobsMapInfo fshJobsMapInfo, HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap) {
        this.generatePhases(fshJobsMapInfo, inFlightScaledPhaseGenerationMap, false);
    }

    public void generatePhases(FSHJobsMapInfo fshJobsMapInfo, boolean fshSidGeneration) {
        this.generatePhases(fshJobsMapInfo, null, fshSidGeneration);
    }

    public void generatePhases(FSHJobsMapInfo fshJobsMapInfo) {
        this.generatePhases(fshJobsMapInfo, null, false);
    }

    public void generatePhases(FSHJobsMapInfo fshJobsMapInfo, HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap, boolean fshSidGeneration) {
        block8: {
            try {
                JobPartitionerVisitor partitionerVisitor = new JobPartitionerVisitor();
                CommandNode partitionedQuery = (CommandNode)this.searchQuery.accept((NodeVisitor)partitionerVisitor);
                logger.debug((Object)("After Job Partitioning=" + (String)partitionedQuery.accept((NodeVisitor)this.formatter)));
                DFSVisitorUtil.JobStatus lastStatus = this.getLastPartitionStatus(partitionedQuery);
                switch (lastStatus) {
                    case GENERATING_STATE: {
                        partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.DFS_STATE);
                        break;
                    }
                    case DFS_STATE: {
                        partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE);
                        break;
                    }
                    case FSH_STATE: {
                        partitionedQuery = this.appendJobPartition(partitionedQuery, DFSVisitorUtil.JobStatus.DFS_STATE);
                        break;
                    }
                    case SPLUNK_SH_STATE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Job Partitioner for the search query is in Illegal state:" + DFSVisitorUtil.JobStatus.UNDEFINED_STATE.toString());
                    }
                }
                logger.debug((Object)("Query being sent for partitionVisitor= " + (String)partitionedQuery.accept((NodeVisitor)this.formatter)));
                this.runExtractionPartitionVisitor(partitionedQuery, this.dfsSidGenerator, fshJobsMapInfo, inFlightScaledPhaseGenerationMap, fshSidGeneration);
                this.validateDFSSearch(fshSidGeneration);
                this.runColumnVisitor(fshJobsMapInfo);
                this.runOrderInfoVisitor();
                this.runReqFieldOrderVisitor();
                this.runFieldAddtionVisitor();
                this.runValidationVisitor();
                this.runSortFieldsValidationVisitor();
                this.runFunctionValidationVisitor();
                this.runLowLatencyModeValidator();
                this.runPartitionBoostDetector();
                logger.info((Object)"Phase generation completed at this point");
            }
            catch (Exception e) {
                this.errorState = true;
                this.errorMessage = String.format("%s", e.toString());
                if (fshSidGeneration) break block8;
                throw e;
            }
        }
    }

    private void runFieldAddtionVisitor() {
        if (this.internalJobs == null) {
            return;
        }
        ArrayList<Object> tempJob = new ArrayList<Object>(this.internalJobs.size());
        for (CommandNode remoteSearch : this.internalJobs) {
            logger.debug((Object)("Remote Search= " + remoteSearch.toString()));
            FieldListAdditionVisitor fieldListAdditionVisitor = new FieldListAdditionVisitor();
            tempJob.add(remoteSearch.accept((NodeVisitor)fieldListAdditionVisitor));
        }
        this.internalJobs.clear();
        this.internalJobs = tempJob;
    }

    private void runPartitionBoostDetector() {
        this.dfsJob.accept((NodeVisitor)new NodeVisitor<Object>(){

            public Object visit(Node cmd) {
                return null;
            }

            public Object visit(StatsCommand cmd) {
                for (AggregateNode aggrNode : cmd.getAggregates()) {
                    AggregateFunction aggrFunc = aggrNode.getFunction();
                    if (!Utils.requireDownProcessing(aggrFunc)) continue;
                    DFSPhaseFacilitator.this.boostPartitions = true;
                    logger.info((Object)String.format("query contains stats command with sub-operations which require partition count boost for handling pre-stats record expansion", new Object[0]));
                    break;
                }
                return null;
            }
        });
    }

    public boolean shouldBoostPartition() {
        return this.boostPartitions;
    }

    public List<String> getUnsupportedCmdsInLowLatencyMode() {
        return this.unsupportedCmdsInLowLatencyMode;
    }

    private void runLowLatencyModeValidator() {
        this.dfsJob.accept((NodeVisitor)new NodeVisitor<Object>(){

            public Object visit(Node cmd) {
                return null;
            }

            public Object visit(JoinCommand cmd) {
                DFSPhaseFacilitator.this.canExecuteInLowLatencyMode = false;
                DFSPhaseFacilitator.this.unsupportedCmdsInLowLatencyMode.add(cmd.getCommandName());
                return null;
            }

            public Object visit(UnionCommand cmd) {
                DFSPhaseFacilitator.this.canExecuteInLowLatencyMode = false;
                DFSPhaseFacilitator.this.unsupportedCmdsInLowLatencyMode.add(cmd.getCommandName());
                return null;
            }

            public Object visit(TailCommand cmd) {
                DFSPhaseFacilitator.this.canExecuteInLowLatencyMode = false;
                DFSPhaseFacilitator.this.unsupportedCmdsInLowLatencyMode.add(cmd.getCommandName());
                return null;
            }

            public Object visit(ReverseCommand cmd) {
                DFSPhaseFacilitator.this.canExecuteInLowLatencyMode = false;
                DFSPhaseFacilitator.this.unsupportedCmdsInLowLatencyMode.add(cmd.getCommandName());
                return null;
            }

            public Object visit(DedupCommand cmd) {
                DFSPhaseFacilitator.this.canExecuteInLowLatencyMode = false;
                DFSPhaseFacilitator.this.unsupportedCmdsInLowLatencyMode.add(cmd.getCommandName());
                return null;
            }
        });
    }

    private void runFunctionValidationVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        FunctionValidationVisitor functionValidationVisitor = new FunctionValidationVisitor();
        dfsSearchToRun.accept((NodeVisitor)functionValidationVisitor);
    }

    private void runColumnVisitor(FSHJobsMapInfo fshJobsMapInfo) {
        CommandNode dfsSearchToRun = this.dfsJob;
        HashMap<String, ArrayList<String>> fshRemoteSidToColumnOrderMap = this.getFshRemoteSidToColumnOrderMap(fshJobsMapInfo);
        ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor(fshRemoteSidToColumnOrderMap);
        dfsSearchToRun.accept((NodeVisitor)columnOrderVisitor);
        this.columnOrder = columnOrderVisitor.getColumnOrder();
    }

    private HashMap<String, ArrayList<String>> getFshRemoteSidToColumnOrderMap(FSHJobsMapInfo fshJobsMapInfo) {
        if (this.datasetInfoMap == null) {
            return null;
        }
        HashMap<String, ArrayList<String>> fshRemoteSidToColumnOrderMap = new HashMap<String, ArrayList<String>>();
        Iterator fshIterator = fshJobsMapInfo.getIterator();
        while (fshIterator.hasNext()) {
            Map.Entry fshMap = (Map.Entry)fshIterator.next();
            block1: for (Map.Entry entry : ((HashMap)fshMap.getValue()).entrySet()) {
                if (fshRemoteSidToColumnOrderMap.containsKey(entry.getKey())) continue;
                String dataSetName = (String)fshMap.getKey();
                for (FederatedDataSetInfo dataSetInfo : this.datasetInfoMap.values()) {
                    if (!dataSetInfo.getDatasetName().equals(dataSetName)) continue;
                    FederatedDataSetInfo fshInfo = this.datasetInfoMap.get(dataSetInfo.getId());
                    if (fshInfo == null) continue block1;
                    fshRemoteSidToColumnOrderMap.put((String)entry.getKey(), fshInfo.getColumnOrder());
                    continue block1;
                }
            }
        }
        return fshRemoteSidToColumnOrderMap;
    }

    private void runOrderInfoVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        OrderInfoVisitor orderInfoVisitor = new OrderInfoVisitor();
        dfsSearchToRun.accept((NodeVisitor)orderInfoVisitor);
        logger.debug((Object)("ORDERINFO ===>" + (String)dfsSearchToRun.accept((NodeVisitor)new SplFormatter())));
        this.orderInfo = orderInfoVisitor.getPipelineOrderInfo();
    }

    private void runSortFieldsValidationVisitor() {
        CommandNode dfsSearchToRun = this.dfsJob;
        SortFieldsValidationVisitor sortFieldsValidationVisitor = new SortFieldsValidationVisitor();
        this.dfsJob = (CommandNode)dfsSearchToRun.accept((NodeVisitor)sortFieldsValidationVisitor);
    }

    private void runReqFieldOrderVisitor() {
        RequiredFieldsOrderVisitor reqFieldsOrderVisitor;
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            return;
        }
        ArrayList<LinkedHashSet<Object>> dfsJobReqFieldsList = new ArrayList<LinkedHashSet<Object>>(this.internalJobs.size());
        for (CommandNode rdinSearch : this.rdinJobs) {
            logger.debug((Object)("rdinSearch : " + rdinSearch.toString()));
            LinkedHashSet<Object> toAddReqFields = new LinkedHashSet();
            reqFieldsOrderVisitor = new RequiredFieldsOrderVisitor();
            rdinSearch.accept((NodeVisitor)reqFieldsOrderVisitor);
            toAddReqFields = reqFieldsOrderVisitor.getRequiredFields();
            if (rdinSearch.getPipeline().ordinal() <= CommandType.SP_EVENTS.ordinal()) {
                toAddReqFields.addAll(new ArrayList<String>(Arrays.asList("source", "sourcetype", "host", "index", "_bkt", "_cd", "_si", "splunk_server", "_linecount", "*")));
            }
            if (this.numberOfRequiredFields < reqFieldsOrderVisitor.getNumberOfRequiredFields()) {
                this.numberOfRequiredFields = reqFieldsOrderVisitor.getNumberOfRequiredFields();
            }
            logger.debug((Object)("Req fields=" + Arrays.toString(toAddReqFields.toArray())));
            dfsJobReqFieldsList.add(toAddReqFields);
        }
        ArrayList<CommandNode> tempJob = new ArrayList<CommandNode>(this.internalJobs.size());
        for (CommandNode remoteSearch : this.internalJobs) {
            logger.debug((Object)("Remote Search= " + remoteSearch.toString()));
            reqFieldsOrderVisitor = new RequiredFieldsOrderVisitor(false);
            remoteSearch.accept((NodeVisitor)reqFieldsOrderVisitor);
            LinkedHashSet<String> toAddReqFields = new LinkedHashSet<String>();
            toAddReqFields.addAll(reqFieldsOrderVisitor.getRequiredFields());
            toAddReqFields.addAll((Collection)dfsJobReqFieldsList.get(tempJob.size()));
            logger.debug((Object)("Req fields=" + Arrays.toString(toAddReqFields.toArray())));
            tempJob.add(this.updateRemoteSearchWithRequiredFields(remoteSearch, toAddReqFields));
            logger.debug((Object)("Added " + tempJob.get(tempJob.size() - 1)));
        }
        this.internalJobs.clear();
        this.internalJobs = tempJob;
    }

    private CommandNode updateRemoteSearchWithRequiredFields(CommandNode remoteSearch, LinkedHashSet<String> toAddReqFields) {
        FieldsCommand fieldsCommand;
        FieldNode[] reqFields = new FieldNode[toAddReqFields.size()];
        int i = 0;
        for (String field : toAddReqFields) {
            reqFields[i] = new FieldNode(field);
            ++i;
        }
        CommandNode remoteSource = remoteSearch.getSource();
        if (remoteSource.getSources().length > 0 && remoteSource.getCommandType().ordinal() >= CommandType.SP_STREAM.ordinal()) {
            fieldsCommand = new FieldsCommand(remoteSource.getSource(), reqFields, false, true);
            CommandNode fieldParent = remoteSource.setSource(DFSVisitorUtil.rebuild((CommandNode)fieldsCommand));
            return remoteSearch.setSource(DFSVisitorUtil.rebuild(fieldParent));
        }
        fieldsCommand = new FieldsCommand(remoteSource, reqFields, false, true);
        return remoteSearch.setSource(DFSVisitorUtil.rebuild((CommandNode)fieldsCommand));
    }

    private void runExtractionPartitionVisitor(CommandNode partitionedQuery, DFSSidGenerator dfsSidGenerator, FSHJobsMapInfo fshJobsMapInfo, HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap, boolean fshSidGeneration) {
        PartitionExtractionVisitor partitioner = new PartitionExtractionVisitor(dfsSidGenerator, inFlightScaledPhaseGenerationMap, fshJobsMapInfo, fshSidGeneration);
        partitionedQuery.accept((NodeVisitor)partitioner);
        this.currentDFSExecutionState = partitioner.getCurrentDFSExecutionState();
        if (this.currentDFSExecutionState != DFSExecutionState.FEDERATED_ONLY) {
            this.internalJobs = partitioner.getSplunkRemoteJobs();
        }
        this.rdinJobs = partitioner.getRdinJobs();
        this.dfsJob = partitioner.getDFSJob();
        if (this.dfsJob.getCommandName().equalsIgnoreCase("rdin") && this.dfsJob.getSources().length == 0) {
            NoOpCommand noop = new NoOpCommand(this.dfsJob);
            this.dfsJob = noop;
        }
        this.splunkSHJob = partitioner.getSplunkSHJob();
    }

    private void runValidationVisitor() {
        ValidationVisitor vv = new ValidationVisitor(true);
        if (this.currentDFSExecutionState == DFSExecutionState.UNKNOWN) {
            throw new IllegalStateException("DFS Execution state unknown , query building failed.");
        }
        if (this.currentDFSExecutionState == DFSExecutionState.FEDERATED_ONLY) {
            return;
        }
        assert (this.internalJobs.size() > 0);
        this.internalJobs.get(0).accept((NodeVisitor)vv);
        this.shouldShortCircuit = vv.getShouldShortCircuit();
        this.startPaused = vv.isStartPaused();
    }

    private CommandNode appendJobPartition(CommandNode partitionedQuery, DFSVisitorUtil.JobStatus toState) {
        logger.debug((Object)("Desired State=" + toState.toString()));
        if (DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE == toState) {
            throw new DFSException(logger, "This search cannot run because it contains unsupported command.");
        }
        JobPartitionerCommand partitionerCommand = new JobPartitionerCommand(partitionedQuery, toState.toString());
        logger.debug((Object)("After append=" + (String)partitionerCommand.accept((NodeVisitor)this.formatter)));
        return partitionerCommand;
    }

    private DFSVisitorUtil.JobStatus getLastPartitionStatus(CommandNode partitionedQuery) {
        CommandNode itrNode = partitionedQuery;
        DFSVisitorUtil.JobStatus jobStatus = DFSVisitorUtil.JobStatus.UNDEFINED_STATE;
        if (itrNode.getCommandName().equalsIgnoreCase("jobpartition")) {
            return DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)itrNode).getJobPartitionName());
        }
        while (itrNode != null) {
            CommandNode[] sourceNodes = itrNode.getSources();
            if (sourceNodes.length >= 1) {
                itrNode = sourceNodes[0];
                if (!itrNode.getCommandName().equalsIgnoreCase("jobpartition")) continue;
                return DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)itrNode).getJobPartitionName());
            }
            itrNode = null;
        }
        return jobStatus;
    }

    public void updateRDoutWithListeners(List<HostPort> remoteSearchHPList) {
        ArrayList<CommandNode> tempList = new ArrayList<CommandNode>();
        for (int i = 0; i < this.internalJobs.size(); ++i) {
            CommandNode itr = this.internalJobs.get(i);
            RdOutCommand currentRdout = null;
            if (!(itr instanceof RdOutCommand)) {
                throw new IllegalStateException("Remote search should start a rdout processor, actual state:" + (String)itr.accept((NodeVisitor)new SplFormatter()));
            }
            currentRdout = (RdOutCommand)itr;
            logger.debug((Object)("Updating search=" + (String)itr.accept((NodeVisitor)new SplFormatter())));
            HostPort[] hp = new HostPort[remoteSearchHPList.size()];
            remoteSearchHPList.toArray(hp);
            CommandNode updatedRdout = currentRdout.setSource(currentRdout.getSource(), hp);
            tempList.add(updatedRdout);
        }
        this.internalJobs.clear();
        this.internalJobs = tempList;
    }

    public CommandNode getRdOutCommand(int idx) {
        return this.internalJobs.get(idx);
    }

    public JSONObject getResponseForScaledFSH(SearchResult cachedSRI, JSONArray remoteSearchList, JSONArray fshSidList, int maxFSHRemotePipeline, long maxFSHSriCntr) {
        JSONObject obj = new JSONObject();
        JSONObject dfsObject = new JSONObject();
        JSONArray sidList = new JSONArray();
        for (String string : this.dfsSidGenerator.getFSHRemoteSidList()) {
            sidList.put((Object)string);
        }
        dfsObject.put("remoteSID", (Object)fshSidList);
        JSONArray columnOrder = new JSONArray();
        for (String string : this.getColumnOrder()) {
            columnOrder.put((Object)string);
        }
        dfsObject.put("columnOrder", (Object)columnOrder);
        dfsObject.put("original_search", this.searchQuery.accept((NodeVisitor)this.formatter));
        dfsObject.put("remoteSearches", (Object)remoteSearchList);
        dfsObject.put("scaled_fsh_max_remote_pipeline", maxFSHRemotePipeline);
        dfsObject.put("scaled_fsh_max_sri_cntr", maxFSHSriCntr);
        JSONArray jSONArray = new JSONArray();
        for (CommandOrderInfo coInfo : this.getOrderForSearchPhases()) {
            JSONObject object = new JSONObject();
            object.put("field", (Object)coInfo.getOrderField());
            object.put("ASC", coInfo.getOrder());
            jSONArray.put((Object)object);
        }
        dfsObject.put("orderInfo", (Object)jSONArray);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isStartPaused", false);
        jSONObject.put("allowRemoteTimeLine", false);
        jSONObject.put("shouldShortCircuit", false);
        jSONObject.put("isPrevPhaseOrdered", true);
        jSONObject.put("remoteLogDownloadMode", true);
        jSONObject.put("timeCursored", false);
        jSONObject.put("sampleRatio", cachedSRI.getDataMap().get("sample_ratio"));
        jSONObject.put("startTime", cachedSRI.getDataMap().get("_startTime"));
        jSONObject.put("endTime", cachedSRI.getDataMap().get("_endTime"));
        dfsObject.put("metainfo", (Object)jSONObject);
        obj.put("fshScaledInfo", (Object)dfsObject);
        return obj;
    }

    public void updateWithScaledExecutions(HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap) {
        CommandNode dfsSearchToRun = this.dfsJob;
        ScaleFederationUpdateVisitor scaleFederationUpdateVisitor = new ScaleFederationUpdateVisitor(inFlightScaledPhaseGenerationMap);
        this.dfsJob = (CommandNode)dfsSearchToRun.accept((NodeVisitor)scaleFederationUpdateVisitor);
    }

    public void validateDFSSearch(boolean fshSidGeneration) {
        if (!fshSidGeneration || this.headN) {
            return;
        }
        DFSSearchValidationVisitor visitor = new DFSSearchValidationVisitor();
        this.dfsJob.accept((NodeVisitor)visitor);
        if (!visitor.isValid()) {
            throw new UnsupportedOperationException("DFS currently supports only transforming searches.");
        }
    }
}

