/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class DFSSidGenerator {
    static final Logger logger = Logger.getLogger(DFSSidGenerator.class);
    private ArrayList<String> toSendSidList;
    private LinkedHashSet<String> remoteSidList;
    private LinkedHashSet<String> fshSidList;
    private LinkedHashSet<String> fshRemoteSidList;
    private LinkedHashSet<String> toSendfshRemoteSidList;
    private int index;
    private String sid;
    private String shSignature;
    private String localSid;
    private String fshSid;
    private String fshBaseSid;
    private boolean isBaseFSHSidSet;

    public DFSSidGenerator(String shSig, String sid, String offset) {
        this.shSignature = shSig;
        this.localSid = sid;
        this.fshSid = offset + sid;
        this.sid = sid;
        this.toSendSidList = new ArrayList();
        this.remoteSidList = new LinkedHashSet();
        this.fshSidList = new LinkedHashSet();
        this.fshRemoteSidList = new LinkedHashSet();
        this.toSendfshRemoteSidList = new LinkedHashSet();
        this.index = 1;
        this.isBaseFSHSidSet = false;
    }

    public String getBaseSid() {
        return this.sid;
    }

    public String getNextSid(boolean fshSidGeneration) {
        if (fshSidGeneration) {
            return this.getFSHScaledSid();
        }
        return this.getRegularSid();
    }

    private String getFSHScaledSid() {
        if (!this.isBaseFSHSidSet) {
            this.isBaseFSHSidSet = true;
            this.fshBaseSid = String.format("fshScaled_%s", this.fshSid);
        }
        String remoteFSHSearch = String.format("remote_%s_fshScaled_prd.ph%d_%s", this.shSignature, this.index, this.fshSid);
        this.fshRemoteSidList.add(remoteFSHSearch);
        String toSendRemoteFSHSearch = String.format("%s_fshScaled_prd.ph%d_%s", this.shSignature, this.index, this.fshSid);
        this.toSendfshRemoteSidList.add(toSendRemoteFSHSearch);
        ++this.index;
        return remoteFSHSearch;
    }

    private String getRegularSid() {
        String remoteSearch = String.format("remote_%s_prd.ph%d_%s", this.shSignature, this.index, this.localSid);
        this.remoteSidList.add(remoteSearch);
        String toSendSid = String.format("prd.ph%d_%s", this.index, this.localSid);
        ++this.index;
        this.toSendSidList.add(toSendSid);
        return remoteSearch;
    }

    public String addUpdateFSHSid(String remoteSid) {
        logger.info((Object)("Incoming remoteSid --> " + remoteSid));
        String regularFshSid = "fsh_regular" + remoteSid.substring("remote_".length() - 1);
        int index = remoteSid.indexOf("prd");
        String toSend = remoteSid.substring(index);
        if (!this.toSendSidList.contains(toSend)) {
            throw new IllegalStateException(String.format("sid=%s should have been present but is missing, inconsistent state", remoteSid));
        }
        this.toSendSidList.remove(toSend);
        if (!this.remoteSidList.contains(remoteSid)) {
            throw new IllegalStateException(String.format("sid=%s should have been present but is missing, inconsistent state", remoteSid));
        }
        this.remoteSidList.remove(remoteSid);
        this.fshSidList.add(regularFshSid);
        return regularFshSid;
    }

    public ArrayList<String> getRemoteSidList() {
        return new ArrayList<String>(this.remoteSidList);
    }

    public ArrayList<String> getToSendSidList() {
        return this.toSendSidList;
    }

    public ArrayList<String> getFSHRemoteSidList() {
        return new ArrayList<String>(this.fshSidList);
    }

    public void reset() {
        this.index = 1;
        this.toSendSidList.clear();
        this.fshSidList.clear();
        this.remoteSidList.clear();
    }

    public ArrayList<String> getScaledFSHToSendSidList() {
        return new ArrayList<String>(this.toSendfshRemoteSidList);
    }

    public ArrayList<String> getScaledFSHSidList() {
        return new ArrayList<String>(this.fshRemoteSidList);
    }

    public void AddUpdatedFSHSidList(ArrayList<String> toUpdateList) {
        ArrayList<String> updatedFSH = new ArrayList<String>();
        for (int i = 0; i < toUpdateList.size(); ++i) {
            String updatedFSHSid = String.format("fsh_remote_%s_%s", this.shSignature, toUpdateList.get(i));
            updatedFSH.add(updatedFSHSid);
            if (this.fshSidList.contains(updatedFSHSid)) continue;
            this.fshSidList.add(updatedFSHSid);
        }
        toUpdateList.clear();
        toUpdateList.addAll(updatedFSH);
    }

    public void syncFSHSidList(String sid, ArrayList<String> scaledFshSidToSendList, ArrayList<String> scaledFshSidist) {
        this.removeSid(sid);
        this.toSendfshRemoteSidList.addAll(scaledFshSidToSendList);
        this.fshSidList.addAll(scaledFshSidist);
    }

    private void removeSid(String toRemove) {
        int index;
        String sidToDelete;
        if (this.remoteSidList.contains(toRemove)) {
            this.remoteSidList.remove(toRemove);
        }
        if (this.toSendSidList.contains(sidToDelete = toRemove.substring(index = toRemove.indexOf("prd")))) {
            this.toSendSidList.remove(sidToDelete);
        }
    }

    public String getFshBaseSid() {
        return this.fshBaseSid;
    }
}

