/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.DFSPhaseFacilitator;
import com.splunk.df.search.FSHSerializableJobsInfo;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class FSHJobsMapInfo
implements Serializable {
    static final Logger logger = Logger.getLogger(FSHJobsMapInfo.class);
    private HashMap<String, HashMap<String, ArrayList<CommandNode>>> fshJobsMapInfo = new HashMap();
    private HashMap<String, ArrayList<String>> baseFSHSidToRemoteFSHSidList = null;
    private HashMap<String, JSONObject> fshDatasetToInfo = new HashMap();
    private HashMap<String, ArrayList<String>> baseSidToRdinSid = null;

    public FSHJobsMapInfo() {
        this.baseFSHSidToRemoteFSHSidList = new HashMap();
        this.baseSidToRdinSid = new HashMap();
    }

    public HashMap<String, ArrayList<String>> getBaseSidToRdinSid() {
        return this.baseSidToRdinSid;
    }

    public HashMap<String, ArrayList<String>> getBaseFSHSidToRemoteFSHSidList() {
        return this.baseFSHSidToRemoteFSHSidList;
    }

    public HashMap<String, JSONObject> getFshDatasetToInfo() {
        return this.fshDatasetToInfo;
    }

    public boolean containsDataset(String dataset) {
        return this.fshJobsMapInfo.containsKey(dataset);
    }

    public boolean isEmpty() {
        return this.fshJobsMapInfo.isEmpty();
    }

    public Iterator getIterator() {
        return this.fshJobsMapInfo.entrySet().iterator();
    }

    public Iterator getBaseToSubSidIterator() {
        return this.baseFSHSidToRemoteFSHSidList.entrySet().iterator();
    }

    public boolean isSidCandidateForScaledExecution(String baseSid) {
        return this.baseSidToRdinSid.containsKey(baseSid);
    }

    public ArrayList<String> getSubSidsForRdin(String baseSid) {
        return this.baseSidToRdinSid.get(baseSid);
    }

    public ArrayList<String> getSubSidsForRemote(String baseSid) {
        return this.baseFSHSidToRemoteFSHSidList.get(baseSid);
    }

    public void addToFSHJobsMap(String dataset, String sid, CommandNode fshSearch) {
        logger.info((Object)String.format("Adding Dataset=%s sid=%s search=>%s", dataset, sid, fshSearch.accept((NodeVisitor)new SplFormatter())));
        if (this.fshJobsMapInfo.containsKey(dataset)) {
            HashMap<String, ArrayList<CommandNode>> sidToQuery = this.fshJobsMapInfo.get(dataset);
            if (sidToQuery.containsKey(sid)) {
                logger.warn((Object)String.format("Dataset=%s has already listed sid=%s, ignoring not adding anything to the FSH Map", dataset, sid));
                return;
            }
            ArrayList<CommandNode> fshSearchList = new ArrayList<CommandNode>();
            fshSearchList.add(fshSearch);
            sidToQuery.put(sid, fshSearchList);
            this.fshJobsMapInfo.put(dataset, sidToQuery);
        } else {
            ArrayList<CommandNode> fshSearchList = new ArrayList<CommandNode>();
            fshSearchList.add(fshSearch);
            HashMap<String, ArrayList<CommandNode>> sidToQuery = new HashMap<String, ArrayList<CommandNode>>();
            sidToQuery.put(sid, fshSearchList);
            this.fshJobsMapInfo.put(dataset, sidToQuery);
        }
    }

    public void addToFSHJobsMap(String dataset, String triggerBaseSid, ArrayList<String> scaledFshSidToSendList, ArrayList<String> fshSidToSendList, ArrayList<CommandNode> fshSearch) {
        StringBuilder sb = new StringBuilder();
        for (CommandNode commandNode : fshSearch) {
            sb.append((String)commandNode.accept((NodeVisitor)new SplFormatter()));
            sb.append("\n");
        }
        StringBuilder sb1 = new StringBuilder();
        for (String string : scaledFshSidToSendList) {
            sb1.append(string);
            sb1.append("\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String mysid : fshSidToSendList) {
            stringBuilder.append(mysid);
            stringBuilder.append("\n");
        }
        logger.info((Object)String.format("Dataset=%s\ntriggersid=%s\nscaledFshSidToSendList=%s \n fshSidToSendList =%s \nsearch=>%s", dataset, triggerBaseSid, sb1.toString(), stringBuilder.toString(), sb.toString()));
        if (this.fshJobsMapInfo.containsKey(dataset)) {
            HashMap<String, ArrayList<CommandNode>> hashMap = this.fshJobsMapInfo.get(dataset);
            if (hashMap.containsKey(triggerBaseSid)) {
                logger.warn((Object)String.format("Dataset=%s has already listed sid=%s, ignoring not adding anything to the FSH Map", dataset, triggerBaseSid));
                return;
            }
            ArrayList<CommandNode> fshSearchList = new ArrayList<CommandNode>();
            for (int i = 0; i < fshSearch.size(); ++i) {
                fshSearchList.add(fshSearch.get(i));
            }
            hashMap.put(triggerBaseSid, fshSearchList);
            this.fshJobsMapInfo.put(dataset, hashMap);
        } else {
            ArrayList<CommandNode> arrayList = new ArrayList<CommandNode>();
            for (int i = 0; i < fshSearch.size(); ++i) {
                arrayList.add(fshSearch.get(i));
            }
            HashMap<String, ArrayList<CommandNode>> sidToQuery = new HashMap<String, ArrayList<CommandNode>>();
            sidToQuery.put(triggerBaseSid, arrayList);
            this.fshJobsMapInfo.put(dataset, sidToQuery);
        }
        this.baseFSHSidToRemoteFSHSidList.put(triggerBaseSid, scaledFshSidToSendList);
        this.baseSidToRdinSid.put(triggerBaseSid, fshSidToSendList);
    }

    public void mergeToMap(FSHJobsMapInfo from) {
        if (from.isEmpty()) {
            return;
        }
        logger.error((Object)"Merge maps called");
        Iterator fromIterator = from.getIterator();
        while (fromIterator.hasNext()) {
            Map.Entry fromPair = (Map.Entry)fromIterator.next();
            String dataset = (String)fromPair.getKey();
            if (this.fshJobsMapInfo.containsKey(fromPair.getKey())) {
                HashMap hashMap = (HashMap)fromPair.getValue();
                HashMap<String, ArrayList<CommandNode>> toSidToQuery = this.fshJobsMapInfo.get(fromPair.getKey());
                toSidToQuery.putAll(hashMap);
                this.fshJobsMapInfo.put((String)fromPair.getKey(), toSidToQuery);
                continue;
            }
            this.fshJobsMapInfo.put((String)fromPair.getKey(), (HashMap<String, ArrayList<CommandNode>>)fromPair.getValue());
        }
        HashMap<String, ArrayList<String>> frombaseToRdinSidList = from.getBaseSidToRdinSid();
        for (Map.Entry entry : frombaseToRdinSidList.entrySet()) {
            this.baseSidToRdinSid.put((String)entry.getKey(), (ArrayList<String>)entry.getValue());
        }
        HashMap<String, ArrayList<String>> frombaseFSHSidToRemoteFSHSidList = from.getBaseFSHSidToRemoteFSHSidList();
        for (Map.Entry<String, ArrayList<String>> entry : frombaseFSHSidToRemoteFSHSidList.entrySet()) {
            this.baseFSHSidToRemoteFSHSidList.put(entry.getKey(), entry.getValue());
        }
    }

    public String[] getFederatedJobs() {
        ArrayList<Object> fshSearches = new ArrayList<Object>();
        for (Map.Entry<String, HashMap<String, ArrayList<CommandNode>>> entry : this.fshJobsMapInfo.entrySet()) {
            for (Map.Entry<String, ArrayList<CommandNode>> sidToQuery : entry.getValue().entrySet()) {
                for (int i = 0; i < sidToQuery.getValue().size(); ++i) {
                    fshSearches.add(sidToQuery.getValue().get(i).accept((NodeVisitor)new SplFormatter()));
                }
            }
        }
        return fshSearches.toArray(new String[fshSearches.size()]);
    }

    public int getNumberOfFederatedSearch() {
        int fshCount = 0;
        for (Map.Entry<String, HashMap<String, ArrayList<CommandNode>>> entry : this.fshJobsMapInfo.entrySet()) {
            for (Map.Entry<String, ArrayList<CommandNode>> sidToQuery : entry.getValue().entrySet()) {
                if (this.isSidCandidateForScaledExecution(sidToQuery.getKey())) {
                    fshCount += this.getSubSidsForRdin(sidToQuery.getKey()).size();
                    continue;
                }
                ++fshCount;
            }
        }
        return fshCount;
    }

    public void populateFederatedSearchInfo(HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap, SearchResult cachedSRI, HashMap<Integer, FederatedDataSetInfo> datasetInfoMap, HashMap<String, FederatedDeploymentInfo> deploymentInfoMap) {
        SplFormatter toSpl = new SplFormatter();
        for (Map.Entry<String, HashMap<String, ArrayList<CommandNode>>> entry : this.fshJobsMapInfo.entrySet()) {
            String dataset = entry.getKey();
            if (!this.isScaledFSH(entry.getValue())) continue;
            for (Map.Entry<String, ArrayList<CommandNode>> sidToQuery : entry.getValue().entrySet()) {
                JSONArray remoteSearchList = new JSONArray();
                for (int i = 0; i < sidToQuery.getValue().size(); ++i) {
                    String fshSearch = (String)sidToQuery.getValue().get(i).accept((NodeVisitor)toSpl);
                    remoteSearchList.put((Object)fshSearch);
                }
                ArrayList<String> toSendRemoteFSHSidList = this.baseFSHSidToRemoteFSHSidList.get(sidToQuery.getKey());
                JSONArray remoteSidList = new JSONArray();
                for (String sid : toSendRemoteFSHSidList) {
                    remoteSidList.put((Object)sid);
                }
                String deployment = Utils.getDeploymentForDataSet(dataset, datasetInfoMap);
                int maxFSHRemotePipeline = deploymentInfoMap.get(deployment).getFshMaxRemotePipeline();
                long maxFSHSriCntr = deploymentInfoMap.get(deployment).getFshMaxSriCntr();
                DFSPhaseFacilitator targetFacilitator = inFlightScaledPhaseGenerationMap.get(dataset);
                JSONObject fshInfoObject = targetFacilitator.getResponseForScaledFSH(cachedSRI, remoteSearchList, remoteSidList, maxFSHRemotePipeline, maxFSHSriCntr);
                this.fshDatasetToInfo.put(sidToQuery.getKey(), fshInfoObject);
            }
        }
    }

    public FSHSerializableJobsInfo getFSHSerializableJobsInfo() {
        HashMap<String, HashMap<String, ArrayList<String>>> fshJobMaptoSerializable = new HashMap<String, HashMap<String, ArrayList<String>>>();
        SplFormatter formatter = new SplFormatter();
        for (Map.Entry<String, HashMap<String, ArrayList<CommandNode>>> entry : this.fshJobsMapInfo.entrySet()) {
            String string = entry.getKey();
            HashMap serializedSidToQuery = new HashMap();
            for (Map.Entry<String, ArrayList<CommandNode>> sidToQuery : entry.getValue().entrySet()) {
                ArrayList<Object> remoteSearchList = new ArrayList<Object>();
                for (int i = 0; i < sidToQuery.getValue().size(); ++i) {
                    remoteSearchList.add(sidToQuery.getValue().get(i).accept((NodeVisitor)formatter));
                }
                serializedSidToQuery.put(sidToQuery.getKey(), remoteSearchList);
            }
            fshJobMaptoSerializable.put(string, serializedSidToQuery);
        }
        HashMap<String, String> fshInfoToSerializable = new HashMap<String, String>();
        for (Map.Entry<String, JSONObject> entry : this.fshDatasetToInfo.entrySet()) {
            fshInfoToSerializable.put(entry.getKey(), entry.getValue().toString());
        }
        FSHSerializableJobsInfo fSHSerializableJobsInfo = new FSHSerializableJobsInfo(fshJobMaptoSerializable, fshInfoToSerializable);
        return fSHSerializableJobsInfo;
    }

    public void dumpFSHMap() {
        StringBuilder sb = new StringBuilder();
        Iterator fshMapIterator = this.getIterator();
        SplFormatter formatter = new SplFormatter();
        logger.info((Object)"--------------------------------------------------------------------");
        logger.info((Object)"Start of FSH Map Dump");
        while (fshMapIterator.hasNext()) {
            Map.Entry fshIterator = (Map.Entry)fshMapIterator.next();
            logger.info((Object)String.format("Dataset Name=%s\n", fshIterator.getKey()));
            for (Map.Entry entry : ((HashMap)fshIterator.getValue()).entrySet()) {
                int i;
                logger.info((Object)("Base Sid=" + (String)entry.getKey()));
                ArrayList<String> remoteSid = this.baseFSHSidToRemoteFSHSidList.get(entry.getKey());
                if (remoteSid != null) {
                    logger.info((Object)("Scaled Remote sid size=" + remoteSid.size()));
                    for (i = 0; i < remoteSid.size(); ++i) {
                        logger.info((Object)("Remote sid=" + remoteSid.get(i)));
                    }
                } else {
                    logger.info((Object)"Regular fsh.");
                }
                logger.info((Object)("Number of remote searches=" + ((ArrayList)entry.getValue()).size()));
                for (i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                    logger.info((Object)("Search=" + (String)((CommandNode)((ArrayList)entry.getValue()).get(i)).accept((NodeVisitor)formatter)));
                }
            }
        }
        logger.info((Object)"--------------------------------------------------------------------");
        for (Map.Entry<String, ArrayList<String>> entry : this.baseSidToRdinSid.entrySet()) {
            logger.error((Object)("Base sid =" + entry.getKey()));
            for (int i = 0; i < entry.getValue().size(); ++i) {
                logger.info((Object)("The remote searches sid=" + entry.getValue().get(i)));
            }
        }
        logger.info((Object)"End of FSH Map Dump");
    }

    public void updateRDoutwithListenersForScaledFSH(List<HostPort> dfsListeners) {
        Map.Entry fromIterator;
        HashMap targetInfo = new HashMap();
        Iterator fshMapIterator = this.getIterator();
        logger.info((Object)"Inside updateRDoutwithListenersForScaledFSH");
        while (fshMapIterator.hasNext()) {
            int i;
            ArrayList<Object> withUpdates;
            HashMap updatedSidToCommandNode;
            fromIterator = (Map.Entry)fshMapIterator.next();
            logger.info((Object)("Dataset " + (String)fromIterator.getKey()));
            if (this.isScaledFSH((HashMap)fromIterator.getValue())) {
                updatedSidToCommandNode = new HashMap();
                logger.info((Object)("Number of trigger sid -->" + ((HashMap)fromIterator.getValue()).size()));
                for (Map.Entry entry : ((HashMap)fromIterator.getValue()).entrySet()) {
                    logger.info((Object)("trigger SID ==>" + (String)entry.getKey()));
                    withUpdates = new ArrayList();
                    for (i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                        CommandNode itr = (CommandNode)((ArrayList)entry.getValue()).get(i);
                        RdOutCommand currentRdout = null;
                        if (!(itr instanceof RdOutCommand)) {
                            throw new IllegalStateException("Remote search should start a rdout processor, actual state:" + (String)itr.accept((NodeVisitor)new SplFormatter()));
                        }
                        currentRdout = (RdOutCommand)itr;
                        logger.debug((Object)("Updating search=" + (String)itr.accept((NodeVisitor)new SplFormatter())));
                        HostPort[] hp = new HostPort[dfsListeners.size()];
                        dfsListeners.toArray(hp);
                        CommandNode updatedRdout = currentRdout.setSource(currentRdout.getSource(), hp);
                        withUpdates.add(updatedRdout);
                    }
                    logger.info((Object)("Adding sid =>" + (String)entry.getKey() + " with num searches -->" + withUpdates.size()));
                    updatedSidToCommandNode.put(entry.getKey(), withUpdates);
                }
                targetInfo.put(fromIterator.getKey(), updatedSidToCommandNode);
                continue;
            }
            updatedSidToCommandNode = new HashMap();
            for (Map.Entry entry : ((HashMap)fromIterator.getValue()).entrySet()) {
                logger.info((Object)("trigger SID ==>" + (String)entry.getKey()));
                withUpdates = new ArrayList<Object>();
                for (i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                    withUpdates.add(((ArrayList)entry.getValue()).get(i));
                }
                logger.info((Object)("Adding sid =>" + (String)entry.getKey() + " with num searches -->" + withUpdates.size()));
                updatedSidToCommandNode.put(entry.getKey(), withUpdates);
            }
            targetInfo.put(fromIterator.getKey(), updatedSidToCommandNode);
        }
        fshMapIterator = this.getIterator();
        while (fshMapIterator.hasNext()) {
            fromIterator = (Map.Entry)fshMapIterator.next();
            for (Map.Entry entry : ((HashMap)fromIterator.getValue()).entrySet()) {
                for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                    ((ArrayList)entry.getValue()).clear();
                }
            }
            ((HashMap)fromIterator.getValue()).clear();
        }
        this.fshJobsMapInfo.clear();
        for (Map.Entry fromIterator2 : targetInfo.entrySet()) {
            HashMap toSidToQuery = new HashMap();
            for (Map.Entry entry : ((HashMap)fromIterator2.getValue()).entrySet()) {
                ArrayList toCopy = new ArrayList();
                for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                    toCopy.add(((ArrayList)entry.getValue()).get(i));
                }
                toSidToQuery.put(entry.getKey(), toCopy);
            }
            this.fshJobsMapInfo.put((String)fromIterator2.getKey(), toSidToQuery);
        }
    }

    private boolean isScaledFSH(HashMap<String, ArrayList<CommandNode>> sidList) {
        int count = 0;
        for (Map.Entry<String, ArrayList<CommandNode>> entry : sidList.entrySet()) {
            if (!this.baseFSHSidToRemoteFSHSidList.containsKey(entry.getKey())) continue;
            ++count;
        }
        if (count == 0) {
            return false;
        }
        if (count == sidList.size()) {
            return true;
        }
        throw new DFSException(logger, String.format("Mismatch for the scaled FSH query plan, missing entry for base sid to remote sub search sids", new Object[0]));
    }

    public String lookupBaseSid(String baseSid) {
        for (Map.Entry<String, ArrayList<String>> entry : this.baseSidToRdinSid.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                if (!baseSid.equalsIgnoreCase(entry.getValue().get(i))) continue;
                return entry.getKey();
            }
        }
        return baseSid;
    }
}

