/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.ast.JsonParser;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSPhaseFacilitator;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.FSHJobsMapInfo;
import com.splunk.df.search.FSHSplunkConnectionHandler;
import com.splunk.df.search.FSHSplunkExecutionType;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDataSetInfoList;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSLogger;
import com.splunk.df.util.Utils;
import com.splunk.df.visitors.ColumnOrderVisitor;
import com.splunk.df.visitors.CursoredSearchVisitor;
import com.splunk.df.visitors.GeneratingSearchVisitor;
import com.splunk.df.visitors.HeadNVisitor;
import com.splunk.df.visitors.RemoteSearchSupportVisitor;
import com.splunk.df.visitors.RequiredFieldsOrderVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FSHMetaPhaseExecutor
implements Serializable,
DFSSearchConstants {
    static final Logger logger = DFSLogger.getLogger(FSHMetaPhaseExecutor.class);
    private boolean hasScaledExecution = false;

    public boolean checkIfScaledExecution() {
        return this.hasScaledExecution;
    }

    public DistributedDataset executeDistributedMetaPhase(DistributedDataset root, final HashMap<Integer, FederatedDataSetInfo> datasetInfoMap, HashMap<String, FederatedDeploymentInfo> deploymentInfoMap, final HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap, final long fshMetaPhaseExecTimeout) throws Exception {
        List<SearchResult> metaPlaceHolders = this.getMetaPlaceHolders(deploymentInfoMap);
        DistributedDataset metaPhaseExecutorDD = root.resetSearchResults(metaPlaceHolders, metaPlaceHolders.size());
        metaPhaseExecutorDD = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                SplunkSearchEndpoint sse = new SplunkSearchEndpoint(dInfo.getIP(), dInfo.getPort(), dInfo.getServiceAccount(), dInfo.getPassword(), dInfo.getApp());
                String connectionId = FSHSplunkConnectionHandler.getNewConnection(sse, fshMetaPhaseExecTimeout);
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.SPLUNK_SEARCH_HEAD, ComputeEngineConstants.FSH_CONNECTION_ID};
                Object[] vals = new Object[]{dInfo, sse, connectionId};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }

            @Override
            public String desc() {
                return "fshMetaPhaseExecutorProcessing";
            }
        });
        metaPhaseExecutorDD = metaPhaseExecutorDD.cacheMem();
        DistributedDataset metaPhaseVersionASTExecutorDD = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                ArrayList<FederatedDataSetInfo> updatedDatasetInfo = new ArrayList<FederatedDataSetInfo>();
                try {
                    SplunkReleaseVersion currentSplunkVersion = new SplunkReleaseVersion(FSHSplunkConnectionHandler.getVersion(connectionId));
                    logger.info((Object)String.format("Deployment %s has Splunk Version: %s", dInfo.getDeploymentName(), currentSplunkVersion.toString()));
                    if (currentSplunkVersion.compareTo(SplunkReleaseVersion.IVORY) < 0) {
                        throw new IllegalArgumentException(String.format("DFS FSH does not support Splunk version=%s for the remote deployment", currentSplunkVersion.toString()));
                    }
                    dInfo.setDeploymentVersion(currentSplunkVersion);
                    for (FederatedDataSetInfo dataSetInfo : datasetInfoMap.values()) {
                        if (!dataSetInfo.getDeploymentName().equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        String searchAstString = FSHSplunkConnectionHandler.getAST(connectionId, dataSetInfo.getSearch());
                        logger.info((Object)("The expanded search ==>" + searchAstString));
                        dataSetInfo.setSearchExpanedToAST(searchAstString);
                        logger.info((Object)("In workers datasetInfo -->" + dataSetInfo.toString()));
                        updatedDatasetInfo.add(dataSetInfo);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH metaphase execution (AST expansion stage), details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.FSH_DATASET_LIST, ComputeEngineConstants.FSH_CONNECTION_ID};
                FederatedDataSetInfoList fdInfoList = new FederatedDataSetInfoList(updatedDatasetInfo);
                Object[] vals = new Object[]{dInfo, fdInfoList, connectionId};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }

            @Override
            public String desc() {
                return "fshMetaPhaseExecutorProcessing";
            }
        });
        Iterator<SearchResult> versionASTResultsItr = metaPhaseVersionASTExecutorDD.retrieve();
        ArrayList<Thread> metaPhaseExecutorThreadList = new ArrayList<Thread>();
        final HashMap deploymentTodataSet = new HashMap();
        while (versionASTResultsItr.hasNext()) {
            SearchResult sr = versionASTResultsItr.next();
            final FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
            deploymentInfoMap.get(dInfo.getDeploymentName()).setDeploymentVersion(dInfo.getDeploymentVersion());
            FederatedDataSetInfoList federatedDataSetInfoList = (FederatedDataSetInfoList)sr.getDataMap().get(ComputeEngineConstants.FSH_DATASET_LIST);
            final ArrayList<FederatedDataSetInfo> dataSetInfoArrayList = federatedDataSetInfoList.getDataSetInfoArrayList();
            final String[] error = new String[]{""};
            Thread metaPhaseParallelizer = new Thread(new DFCRunnable(){

                @Override
                protected void runInternal() throws Exception {
                    for (int i = 0; i < dataSetInfoArrayList.size(); ++i) {
                        CommandNode fshCommandNode;
                        logger.info((Object)String.format("The dataset Info=%s", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).toString()));
                        JSONObject jsonObject = new JSONObject(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearchExpandToAST());
                        logger.info((Object)String.format("The expanded search in AST is %s.", jsonObject.toString()));
                        JsonParser jsonParser = new JsonParser(true, false);
                        try {
                            fshCommandNode = (CommandNode)jsonParser.parse(jsonObject);
                        }
                        catch (Exception e) {
                            error[0] = String.format("FSH remote dataset='%s' with search=%s is not supported in federated execution of DFS.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearch());
                            return;
                        }
                        RemoteSearchSupportVisitor remoteSearchSupportVisitor = new RemoteSearchSupportVisitor();
                        fshCommandNode.accept((NodeVisitor)remoteSearchSupportVisitor);
                        if (!remoteSearchSupportVisitor.isFSHSupported()) {
                            error[0] = String.format("FSH remote dataset='%s' with search=%s is not supported in federated execution of DFS.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearch());
                            return;
                        }
                        SplFormatter splFormatter = new SplFormatter();
                        ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setExpandedSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setExpandedSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                        SplunkReleaseVersion deploymentVersion = dInfo.getDeploymentVersion();
                        int headN = ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getHeadN();
                        if (headN > 0) {
                            CommandNode newfshCommandNode;
                            HeadNVisitor samplingVisitor = new HeadNVisitor(headN);
                            fshCommandNode = newfshCommandNode = (CommandNode)fshCommandNode.accept((NodeVisitor)samplingVisitor);
                            ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setHeadNSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                            ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setHeadNSearch((String)fshCommandNode.accept((NodeVisitor)splFormatter));
                        } else {
                            CursoredSearchVisitor cursoredSearchVisitor = new CursoredSearchVisitor();
                            fshCommandNode.accept((NodeVisitor)cursoredSearchVisitor);
                            if (cursoredSearchVisitor.isCursored()) {
                                error[0] = String.format("FSH remote search='%s' is not a transforming search. DFS only supports transforming searches currently for remote deployments.", fshCommandNode.accept((NodeVisitor)splFormatter));
                                return;
                            }
                            GeneratingSearchVisitor detectIndexForEstimation = new GeneratingSearchVisitor();
                            fshCommandNode.accept((NodeVisitor)detectIndexForEstimation);
                            StringBuilder estimatedSearch = new StringBuilder();
                            int numberOfPredicates = detectIndexForEstimation.getPredicates().size();
                            if (numberOfPredicates == 0) {
                                error[0] = String.format("FSH dataset =%s failed to generate the estimation query", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName());
                                return;
                            }
                            if (deploymentVersion.compareTo(SplunkReleaseVersion.IVORY) >= 0 && deploymentVersion.compareTo(SplunkReleaseVersion.KIMONO) < 0) {
                                if (numberOfPredicates > 1) {
                                    error[0] = String.format("FSH dataset=%s is not supported for Splunk version=%s.", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), dInfo.getDeploymentVersion().toString());
                                    return;
                                }
                                estimatedSearch.append(String.format("| tstats count where %s", detectIndexForEstimation.getPredicates().get(0)));
                            } else {
                                estimatedSearch.append("| union ");
                                for (int j = 0; j < detectIndexForEstimation.getPredicates().size(); ++j) {
                                    estimatedSearch.append(String.format("[| tstats count where %s]", detectIndexForEstimation.getPredicates().get(j)));
                                }
                                if (deploymentVersion.compareTo(SplunkReleaseVersion.QUAKE) >= 0) {
                                    estimatedSearch.append(" | noop tstats_multiple_timeranges_warn_only=true ");
                                }
                            }
                            ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setSearchForEstimation(estimatedSearch.toString());
                            ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setSearchForEstimation(estimatedSearch.toString());
                            logger.info((Object)String.format("For Dataset %s the estimation search %s", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getSearchForEstimation()));
                        }
                        if (deploymentVersion.compareTo(SplunkReleaseVersion.QUAKE) >= 0 && !dInfo.getExecutionType().equals(FSHSplunkExecutionType.SH)) {
                            logger.info((Object)"Scaled FSH execution query building in progress.");
                            DFSPhaseFacilitator fshPhaseFacilitator = new DFSPhaseFacilitator(fshCommandNode);
                            fshPhaseFacilitator.setHeadN(headN > 0);
                            FSHJobsMapInfo fshJobsMapInfo = new FSHJobsMapInfo();
                            fshPhaseFacilitator.generatePhases(fshJobsMapInfo, true);
                            if (fshPhaseFacilitator.isInErrorState()) {
                                error[0] = String.format("FSH Dataset=%s failed=%s", ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), fshPhaseFacilitator.getErrorMessage());
                                return;
                            }
                            assert (fshJobsMapInfo.isEmpty());
                            inFlightScaledPhaseGenerationMap.put(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName(), fshPhaseFacilitator);
                            int numberOfRemoteSearches = fshPhaseFacilitator.getNumberOfRemoteSearches();
                            int numFields = 0;
                            logger.info((Object)String.format("The number of remote searches=%d for dataset=%s", numberOfRemoteSearches, ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getDatasetName()));
                            for (int cntr = 0; cntr < numberOfRemoteSearches; ++cntr) {
                                numFields = Math.max(numFields, Utils.getPartitionKeys((RdOutCommand)fshPhaseFacilitator.getRdOutCommand(cntr)).size());
                            }
                            ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setNumFields(numFields);
                            ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor();
                            fshCommandNode.accept((NodeVisitor)columnOrderVisitor);
                            ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setColumnOrder(columnOrderVisitor.getColumnOrder());
                            FSHMetaPhaseExecutor.this.hasScaledExecution = true;
                            continue;
                        }
                        logger.info((Object)"Regular FSH execution in progress.");
                        RequiredFieldsOrderVisitor requiredFieldsOrderVisitor = new RequiredFieldsOrderVisitor(false);
                        fshCommandNode.accept((NodeVisitor)requiredFieldsOrderVisitor);
                        ((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).setNumFields(requiredFieldsOrderVisitor.getNumberOfRequiredFields());
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setNumFields(requiredFieldsOrderVisitor.getNumberOfRequiredFields());
                        ColumnOrderVisitor columnOrderVisitor = new ColumnOrderVisitor();
                        fshCommandNode.accept((NodeVisitor)columnOrderVisitor);
                        ((FederatedDataSetInfo)datasetInfoMap.get(((FederatedDataSetInfo)dataSetInfoArrayList.get(i)).getId())).setColumnOrder(columnOrderVisitor.getColumnOrder());
                    }
                    deploymentTodataSet.put(dInfo.getDeploymentName(), dataSetInfoArrayList);
                }
            });
            metaPhaseExecutorThreadList.add(metaPhaseParallelizer);
            metaPhaseParallelizer.start();
            for (Thread metaPhaseThread : metaPhaseExecutorThreadList) {
                metaPhaseThread.join();
            }
            if (error[0].isEmpty()) continue;
            throw new DFSException(error[0]);
        }
        DistributedDataset metaPhaseEstimationExecutor = metaPhaseExecutorDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                ArrayList<FederatedDataSetInfo> updatedDaatasetInfo = new ArrayList<FederatedDataSetInfo>();
                try {
                    for (Map.Entry entry : deploymentTodataSet.entrySet()) {
                        if (!((String)entry.getKey()).equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                            long estimatedCount = 0L;
                            estimatedCount = ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getHeadN() > 0 && !((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getSearch(true).isEmpty() ? (long)((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getHeadN() : FSHSplunkConnectionHandler.getEstimatedEventCount(connectionId, ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getSearchForEstimation());
                            ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).setEstimatedEventCount(estimatedCount);
                            logger.info((Object)String.format("For Dataset %s the estimation Count is %d", ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getDatasetName(), ((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i)).getEstimatedEventCount()));
                            updatedDaatasetInfo.add((FederatedDataSetInfo)((ArrayList)entry.getValue()).get(i));
                        }
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH metaphase execution (event count estimation stage), details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT, ComputeEngineConstants.FSH_DATASET_LIST};
                FederatedDataSetInfoList fdInfoList = new FederatedDataSetInfoList(updatedDaatasetInfo);
                Object[] vals = new Object[]{dInfo, fdInfoList};
                SearchResult updatedSR = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return updatedSR;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }

            @Override
            public String desc() {
                return "fshMetaPhaseExecutorProcessing";
            }
        });
        logger.info((Object)"Estimation Done");
        Iterator<SearchResult> srItr = metaPhaseEstimationExecutor.retrieve();
        long eventCount = 0L;
        while (srItr.hasNext()) {
            SearchResult sr = srItr.next();
            if (sr.isEmpty()) continue;
            FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getDataMap().get(ComputeEngineConstants.FSH_DEPLOYMENT);
            FederatedDataSetInfoList federatedDataSetInfoList = (FederatedDataSetInfoList)sr.getDataMap().get(ComputeEngineConstants.FSH_DATASET_LIST);
            ArrayList<FederatedDataSetInfo> dataSetInfos = federatedDataSetInfoList.getDataSetInfoArrayList();
            for (int i = 0; i < dataSetInfos.size(); ++i) {
                eventCount += dataSetInfos.get(i).getEstimatedEventCount().longValue();
                datasetInfoMap.get(dataSetInfos.get(i).getId()).setEstimatedEventCount(dataSetInfos.get(i).getEstimatedEventCount());
            }
        }
        if (eventCount == 0L) {
            for (Map.Entry<Integer, FederatedDataSetInfo> entry : datasetInfoMap.entrySet()) {
                entry.getValue().setEstimatedEventCount(1000L);
                entry.getValue().setNumFields(1);
            }
        }
        return metaPhaseExecutorDD;
    }

    private List<SearchResult> getMetaPlaceHolders(HashMap<String, FederatedDeploymentInfo> deploymentInfoMap) {
        ArrayList<SearchResult> metaPlaceHolder = new ArrayList<SearchResult>();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_DEPLOYMENT};
        for (FederatedDeploymentInfo deplyInfo : deploymentInfoMap.values()) {
            Object[] vals = new Object[]{deplyInfo};
            metaPlaceHolder.add(SearchResultFactory.getInstance().createSearchResult(fields, vals));
        }
        return metaPlaceHolder;
    }
}

