/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.Job;
import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.FSHSearchResultShuffler;
import com.splunk.df.search.FSHSerializableJobsInfo;
import com.splunk.df.search.FSHSidToPeerList;
import com.splunk.df.search.FSHSplunkConnectionHandler;
import com.splunk.df.search.FSHSplunkExecutionType;
import com.splunk.df.search.FederatedDataSetInfo;
import com.splunk.df.search.FederatedDeploymentInfo;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.DFSLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FSHTriggerDDFactory
implements DFSSearchConstants {
    static final Logger logger = DFSLogger.getLogger(FSHTriggerDDFactory.class);

    public static HashMap<String, Integer> executeFSHTrigger(DistributedDataset fshTriggerDD, final HashMap<Integer, FederatedDataSetInfo> dataSetInfoMap, final FSHSerializableJobsInfo fshSerializableJobsInfo, List<HostPort> toIPList, final String originalUser, final long dfsRemoteSearchTimeout) {
        StringBuilder sb = new StringBuilder();
        for (HostPort hp : toIPList) {
            sb.append(String.format("%s-", hp.toString()));
        }
        final String hpListString = sb.toString();
        DistributedDataset fshTriggerExecutor = fshTriggerDD.transform(new Mapper(){

            @Override
            public SearchResult map(SearchResult sr) {
                FederatedDeploymentInfo dInfo = (FederatedDeploymentInfo)sr.getFieldValue(ComputeEngineConstants.FSH_DEPLOYMENT);
                String connectionId = (String)sr.getFieldValue(ComputeEngineConstants.FSH_CONNECTION_ID);
                SplunkSearchEndpoint sse = (SplunkSearchEndpoint)sr.getFieldValue(ComputeEngineConstants.SPLUNK_SEARCH_HEAD);
                String[] hpList = hpListString.split("-");
                ArrayList<HostPort> toSendIPList = new ArrayList<HostPort>();
                for (int j = 0; j < hpList.length; ++j) {
                    String[] hp = hpList[j].split(":");
                    HostPort hostPort = new HostPort(hp[0], Integer.parseInt(hp[1]));
                    toSendIPList.add(hostPort);
                }
                String remoteSidForRemote = null;
                HashMap<String, Integer> sidToNumPeer = new HashMap<String, Integer>();
                HashSet<String> triggeredRemoteSid = new HashSet<String>();
                try {
                    for (FederatedDataSetInfo dataSetInfo : dataSetInfoMap.values()) {
                        logger.info((Object)("The deployment name:" + dInfo.getDeploymentName()));
                        if (!dataSetInfo.getDeploymentName().equalsIgnoreCase(dInfo.getDeploymentName())) continue;
                        Iterator fshMapIterator = fshSerializableJobsInfo.getIterator();
                        while (fshMapIterator.hasNext()) {
                            Map.Entry fshMapPair = (Map.Entry)fshMapIterator.next();
                            logger.info((Object)("Dataset from the fshjobsmap --> " + (String)fshMapPair.getKey()));
                            String dataSetName = (String)fshMapPair.getKey();
                            if (!dataSetName.equalsIgnoreCase(dataSetInfo.getDatasetName())) continue;
                            SplunkReleaseVersion currentSplunkVersion = dInfo.getDeploymentVersion();
                            logger.info((Object)String.format("The Splunk version for deployment=%s is %s", dInfo.getDeploymentName(), currentSplunkVersion.toString()));
                            HashMap triggerSidToQuery = new HashMap();
                            FSHSplunkExecutionType executionType = this.getFederatedExecutionMode(currentSplunkVersion, dInfo);
                            logger.info((Object)String.format("FSH Execution type=%s for dataset=%s", executionType.toString(), dataSetName));
                            for (Map.Entry sidToSearch : ((HashMap)fshMapPair.getValue()).entrySet()) {
                                String remoteSid = (String)sidToSearch.getKey();
                                if (remoteSid == null) {
                                    throw new IllegalArgumentException("Invalid remote sid for fsh");
                                }
                                logger.info((Object)String.format("For triggering remote sid=%s.", remoteSid));
                                if (triggeredRemoteSid.contains(remoteSid)) continue;
                                int numPeer = 1;
                                triggeredRemoteSid.add(remoteSid);
                                switch (executionType) {
                                    case SH: {
                                        logger.info((Object)"Executing non-partitioned execution.");
                                        Pair<String, Job> npe = FSHSplunkConnectionHandler.triggerNonPartitionedQuery(remoteSid, connectionId, dataSetInfo.getSearch(true));
                                        FSHSearchResultShuffler.getInstance().handleNonPartitionedExecution(connectionId, npe.first(), npe.second(), toSendIPList, sse, dataSetInfo.getSearch(true), dfsRemoteSearchTimeout);
                                        remoteSidForRemote = npe.first();
                                        break;
                                    }
                                    case SH_SHUFFLE: {
                                        logger.info((Object)"Executing partitioned execution.");
                                        Pair<String, Job> pe = FSHSplunkConnectionHandler.triggerPartitionedQuery(remoteSid, originalUser, connectionId, dataSetInfo.getSearch(true), toSendIPList);
                                        FSHSearchResultShuffler.getInstance().handlePartitionedExecution(connectionId, pe.first(), pe.second(), toSendIPList, sse, dataSetInfo.getSearch(true), dfsRemoteSearchTimeout);
                                        remoteSidForRemote = pe.first();
                                        break;
                                    }
                                    case SH_SHUFFLE_FROM_QUAKE: {
                                        logger.info((Object)"Executing partitioned execution for Quake and beyond.");
                                        Pair<String, Job> peQuake = FSHSplunkConnectionHandler.triggerPartitionedQueryForQuake(remoteSid, originalUser, connectionId, dataSetInfo.getSearch(true), toSendIPList);
                                        FSHSearchResultShuffler.getInstance().handlePartitionedExecution(connectionId, peQuake.first(), peQuake.second(), toSendIPList, sse, dataSetInfo.getSearch(true), dfsRemoteSearchTimeout);
                                        remoteSidForRemote = peQuake.first();
                                        break;
                                    }
                                    case FABRIC: {
                                        logger.info((Object)"Executing scaled execution.");
                                        Pair<Integer, Job> se = FSHSplunkConnectionHandler.triggerScaledQuery(remoteSid, originalUser, connectionId, dataSetInfo.getSearch(true), fshSerializableJobsInfo.getFederatedSearchInfo(remoteSid));
                                        numPeer = se.first();
                                        FSHSearchResultShuffler.getInstance().handleScaledExecutions(connectionId, remoteSid, se.second(), toSendIPList, sse, dataSetInfo.getSearch(true));
                                        remoteSidForRemote = remoteSid;
                                        break;
                                    }
                                    default: {
                                        logger.error((Object)"Inside undefined or default");
                                        throw new IllegalStateException();
                                    }
                                }
                                sidToNumPeer.put(remoteSidForRemote, numPeer);
                                logger.info((Object)String.format("Search id(sid)=%s and number of remote peers=%d for the sid.", remoteSidForRemote, numPeer));
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failure during FSH trigger execution, details=%s", t.toString()));
                }
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[]{ComputeEngineConstants.FSH_SID_TO_NUM_PEER_MAP};
                FSHSidToPeerList fshSidToPeerList = new FSHSidToPeerList(sidToNumPeer);
                Object[] vals = new Object[]{fshSidToPeerList};
                SearchResult sidMap = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                return sidMap;
            }

            private FSHSplunkExecutionType getFederatedExecutionMode(SplunkReleaseVersion currentSplunkVersion, FederatedDeploymentInfo dInfo) {
                logger.info((Object)String.format("Remote deployment current version=%s", currentSplunkVersion.toString()));
                if (currentSplunkVersion.compareTo(SplunkReleaseVersion.QUAKE) >= 0) {
                    if (dInfo.getExecutionType().equals(FSHSplunkExecutionType.UNDEFINED) || dInfo.getExecutionType().equals(FSHSplunkExecutionType.FABRIC)) {
                        return FSHSplunkExecutionType.FABRIC;
                    }
                    if (dInfo.getExecutionType().equals(FSHSplunkExecutionType.SH)) {
                        return FSHSplunkExecutionType.SH_SHUFFLE_FROM_QUAKE;
                    }
                    return dInfo.getExecutionType();
                }
                if (currentSplunkVersion.compareTo(SplunkReleaseVersion.ORANGESWIRL) >= 0 && currentSplunkVersion.compareTo(SplunkReleaseVersion.QUAKE) < 0) {
                    return FSHSplunkExecutionType.SH_SHUFFLE;
                }
                if (currentSplunkVersion.compareTo(SplunkReleaseVersion.IVORY) >= 0 && currentSplunkVersion.compareTo(SplunkReleaseVersion.ORANGESWIRL) < 0) {
                    return FSHSplunkExecutionType.SH;
                }
                return FSHSplunkExecutionType.UNDEFINED;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return null;
            }

            @Override
            public String desc() {
                return "fshTriggerDDFactoryProcessing";
            }
        });
        HashMap<String, Integer> sidToNumPeerMap = new HashMap<String, Integer>();
        Iterator<SearchResult> resultsItr = fshTriggerExecutor.retrieve();
        while (resultsItr.hasNext()) {
            SearchResult sr = resultsItr.next();
            if (sr == null || sr.isEmpty()) continue;
            FSHSidToPeerList perSRSidToNumPeerList = (FSHSidToPeerList)sr.getDataMap().get(ComputeEngineConstants.FSH_SID_TO_NUM_PEER_MAP);
            HashMap<String, Integer> perSRSidToNumPeer = perSRSidToNumPeerList.getSidToNumPeer();
            if (perSRSidToNumPeer == null || perSRSidToNumPeer.size() == 0) {
                logger.warn((Object)"sid to number of peers one entry is missing.");
                continue;
            }
            sidToNumPeerMap.putAll(perSRSidToNumPeer);
        }
        return sidToNumPeerMap;
    }
}

