/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.FSHSplunkExecutionType;
import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class FederatedDeploymentInfo
implements Serializable {
    static final Logger logger = Logger.getLogger(FederatedDeploymentInfo.class);
    private final String ip;
    private final int port;
    private final String deploymentName;
    private final String serviceAccount;
    private final String password;
    private final String app;
    private SplunkReleaseVersion deploymentVersion;
    private final FSHSplunkExecutionType executionType;
    private final int fshMaxRemotePipeline;
    private final long fshMaxSriCntr;

    public String getIP() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getPassword() {
        return this.password;
    }

    public String getApp() {
        return this.app;
    }

    public int getFshMaxRemotePipeline() {
        return this.fshMaxRemotePipeline;
    }

    public FSHSplunkExecutionType getExecutionType() {
        return this.executionType;
    }

    public SplunkReleaseVersion getDeploymentVersion() {
        return this.deploymentVersion;
    }

    public void setDeploymentVersion(SplunkReleaseVersion version) {
        this.deploymentVersion = version;
    }

    public long getFshMaxSriCntr() {
        return this.fshMaxSriCntr;
    }

    public FederatedDeploymentInfo(String ip, Integer port, String deploymentName, String serviceAccount, String password, String app, int fshMaxRemotePipeline, FSHSplunkExecutionType executionType, long fshMaxSriCntr) {
        this.ip = ip;
        this.port = port;
        this.deploymentName = deploymentName;
        this.serviceAccount = serviceAccount;
        this.password = password;
        this.app = app;
        this.deploymentVersion = SplunkReleaseVersion.INVALID;
        this.fshMaxRemotePipeline = fshMaxRemotePipeline;
        this.executionType = executionType;
        this.fshMaxSriCntr = fshMaxSriCntr;
    }

    public FederatedDeploymentInfo(String ip, Integer port, String deploymentName, String serviceAccount, String password, String app, SplunkReleaseVersion version, int fshMaxRemotePipeline, FSHSplunkExecutionType executionType, long fshMaxSriCntr) {
        this.ip = ip;
        this.port = port;
        this.deploymentName = deploymentName;
        this.serviceAccount = serviceAccount;
        this.password = password;
        this.app = app;
        this.deploymentVersion = version;
        this.fshMaxRemotePipeline = fshMaxRemotePipeline;
        this.executionType = executionType;
        this.fshMaxSriCntr = fshMaxSriCntr;
    }

    public static void write(OutputStream os, FederatedDeploymentInfo federatedDeploymentInfo) throws IOException {
        Utils.write(os, federatedDeploymentInfo.ip);
        Utils.write(os, federatedDeploymentInfo.port);
        Utils.write(os, federatedDeploymentInfo.deploymentName);
        Utils.write(os, federatedDeploymentInfo.serviceAccount);
        Utils.write(os, federatedDeploymentInfo.password);
        Utils.write(os, federatedDeploymentInfo.app);
        SplunkReleaseVersion.write(os, federatedDeploymentInfo.deploymentVersion);
        FSHSplunkExecutionType.write(os, federatedDeploymentInfo.executionType);
        Utils.write(os, federatedDeploymentInfo.fshMaxRemotePipeline);
        Utils.write(os, federatedDeploymentInfo.fshMaxSriCntr);
    }

    public static FederatedDeploymentInfo read(InputStream is) throws IOException {
        String deserIP = Utils.readString(is);
        int deserPort = Utils.readInt(is);
        String deserDeploymentName = Utils.readString(is);
        String deserServiceAccount = Utils.readString(is);
        String deserPassword = Utils.readString(is);
        String deserApp = Utils.readString(is);
        SplunkReleaseVersion deserVersion = SplunkReleaseVersion.read(is);
        FSHSplunkExecutionType deserFSHSplunkExecutionType = FSHSplunkExecutionType.read(is);
        int deserFshMaxRemotePipeline = Utils.readInt(is);
        long deserFshMaxSriCntr = Utils.readLong(is);
        return new FederatedDeploymentInfo(deserIP, deserPort, deserDeploymentName, deserServiceAccount, deserPassword, deserApp, deserVersion, deserFshMaxRemotePipeline, deserFSHSplunkExecutionType, deserFshMaxSriCntr);
    }
}

