/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.io.Serializable;

public class RemoteSearchInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sid;
    private final String scaledFshBaseSid;
    private int numPeers;
    private final boolean isScaledFSH;
    private final boolean isFSH;

    public RemoteSearchInfo(String sid, int numPeers) {
        this.sid = sid;
        this.numPeers = numPeers;
        this.isFSH = false;
        this.isScaledFSH = false;
        this.scaledFshBaseSid = null;
    }

    public RemoteSearchInfo(String sid, int numPeers, boolean isFSH, boolean isScaledFSH, String baseSid) {
        this.sid = sid;
        this.numPeers = numPeers;
        this.isFSH = isFSH;
        this.isScaledFSH = isScaledFSH;
        this.scaledFshBaseSid = baseSid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String sid() {
        return this.sid;
    }

    public boolean isSearchFederated() {
        return this.sid.startsWith("fsh");
    }

    public String getSidForFSHMetrics() {
        return this.scaledFshBaseSid == null ? this.sid : this.scaledFshBaseSid;
    }

    public int numPeers() {
        return this.numPeers;
    }

    public void setNumPeers(int numPeers) {
        this.numPeers = numPeers;
    }

    public boolean isScaledFSH() {
        return this.isScaledFSH;
    }

    public boolean isFSH() {
        return this.isFSH;
    }
}

