/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.ChunkToDispatch;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.compute.SearchResult;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SearchResultInfoUtils
implements DFSSearchConstants {
    static Logger logger = Logger.getLogger(SearchResultInfoUtils.class);
    private SearchResult searchResultInfo;
    private final SearchResult errorSRI;
    private OutputStream splunkOutputStream;
    private SearchResult.FieldMeta[] sriKeys = null;

    public SearchResultInfoUtils(OutputStream writetoSplunkSearchProces, SearchResult sr) {
        this.splunkOutputStream = writetoSplunkSearchProces;
        this.errorSRI = this.searchResultInfo = sr;
    }

    public SearchResult getSRI() {
        return this.searchResultInfo;
    }

    public void sendEndofSearchErrorSRI(Thread t, Throwable e) {
        logger.error((Object)("Sending error response to splunk search process on thread=" + t.getName() + " exception=" + ExceptionUtils.getFullStackTrace((Throwable)e)));
        this.errorSRI.getDataMap().put(REMOTE_SEARCH_QUERY_FINISHED, 1);
        this.errorSRI.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msgType"), "ERROR");
        this.errorSRI.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msg"), e.toString());
        this.errorSRI.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msgInfo"), "{}");
        try {
            ChunkToDispatch chunkToDispatch = this.getPayload(this.errorSRI);
            String payload = String.format("%s\n%s", chunkToDispatch.getHeader(), chunkToDispatch.getSri());
            logger.debug((Object)("PAYLOAD=" + payload));
            int sizeOfPayload = payload.length();
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(sizeOfPayload);
            byte[] sizebuff = bb.array();
            ArrayUtils.reverse((byte[])sizebuff);
            this.splunkOutputStream.write(sizebuff);
            this.splunkOutputStream.write(payload.getBytes());
            this.splunkOutputStream.flush();
        }
        catch (IOException ioe) {
            logger.error((Object)"IO Exception in sending error containing SRI to Splunk Search Process");
        }
    }

    public void sendAckError(Thread t, Throwable e) {
        SearchResultInfoUtils.sendAckError(t, this.splunkOutputStream, e);
    }

    public static void sendAckError(Thread t, OutputStream o, Throwable e) {
        logger.error((Object)("Sending error response to splunk search process exception=" + ExceptionUtils.getFullStackTrace((Throwable)e)));
        String payload = String.format("%s,%s\n", DFSProtocolConstants.PROTO_DFS_FAILED.toString(), e.getMessage());
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(o));
        try {
            bw.write(payload);
            bw.flush();
        }
        catch (IOException ioerror) {
            logger.error((Object)("IO Exception in sending error containing Ack to Splunk Search Process :" + ioerror.getMessage()));
        }
    }

    private static String[] convert(SearchResult.FieldMeta[] fields) {
        String[] strFields = new String[fields.length];
        for (int i = 0; i < strFields.length; ++i) {
            strFields[i] = fields[i].fieldName();
        }
        return strFields;
    }

    public ChunkToDispatch getPayload(SearchResult sri) throws IOException {
        SearchResult.FieldMeta[] sriKeys = this.getSriKeys(sri);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter chunkWriter = new BufferedWriter(new OutputStreamWriter(baos));
        CSVPrinter csvPrinter = CSVFormat.DEFAULT.withHeader(SearchResultInfoUtils.convert(sriKeys)).print((Appendable)chunkWriter);
        Object[] sriValues = new Object[sriKeys.length];
        System.arraycopy(sri.getDataMap().values().toArray(), 0, sriValues, 0, sriKeys.length);
        csvPrinter.printRecord(sriValues);
        csvPrinter.printRecord(sriValues);
        csvPrinter.flush();
        String sriPayload = new String(baos.toByteArray());
        return new ChunkToDispatch(sriPayload, new String());
    }

    public SearchResult.FieldMeta[] getSriKeys(SearchResult sri) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> sriData = sri.getDataMap();
        Object[] sriKeysObj = sriData.keySet().toArray();
        this.sriKeys = new SearchResult.FieldMeta[sriKeysObj.length];
        System.arraycopy(sriKeysObj, 0, this.sriKeys, 0, this.sriKeys.length);
        logger.debug((Object)("SRI Header " + Arrays.toString(this.sriKeys)));
        return this.sriKeys;
    }

    public void addWarning(String message) {
        this.searchResultInfo.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msgType"), "WARN");
        this.searchResultInfo.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msg"), message);
        this.searchResultInfo.getDataMap().put(SearchResult.FieldMeta.newFieldMeta("msgInfo"), "{}");
    }
}

