/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.compute.SearchResult;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.log4j.Logger;

public class SearchResultsWriter {
    static Logger logger = null;

    public static void write(Iterator<SearchResult> srs, SearchResult.FieldMeta[] fields, Writer w) {
        try {
            CSVPrinter csvp = CSVFormat.DEFAULT.withHeader(SearchResultsWriter.convert(fields)).print((Appendable)w);
            while (srs.hasNext()) {
                SearchResult sr = srs.next();
                Object[] vals = SearchResultsWriter.getFieldValues(fields, sr);
                csvp.printRecord(vals);
            }
            csvp.flush();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error writing search results: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("error serializing search results: %s", t.getMessage()), t);
        }
    }

    public static String[] convert(SearchResult.FieldMeta[] fields) {
        String[] strFields = new String[fields.length];
        for (int i = 0; i < strFields.length; ++i) {
            if (fields[i] == null) continue;
            strFields[i] = fields[i].fieldName();
        }
        return strFields;
    }

    private static Object[] getFieldValues(SearchResult.FieldMeta[] fields, SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = sr.getDataMap();
        int len = fields.length;
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            SearchResult.FieldMeta field = fields[i];
            Object val = ((HashMap)data).get(field);
            values[i] = val;
        }
        return values;
    }

    static {
        logger = Logger.getLogger(SearchResultsWriter.class);
    }
}

