/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import au.com.bytecode.opencsv.CSVParser;
import com.splunk.df.search.CsvSplunkEventIterable;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

@Deprecated
public class SplunkEventChunk
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Logger logger = null;
    private long startTime;
    private long endTime;
    private String source;
    private int numEvents;
    private boolean lastChunk;
    private String compressedData = null;
    private String compressedInfoCsv = null;
    private String sparkLookupCode = null;

    public SplunkEventChunk(String source, long startTime, long endTime, String compressedData, int numEvents, String compressedInfoCsv, String sparkLookupCode, boolean lastChunk) {
        if (startTime < 0L || endTime < 0L) {
            logger.error((Object)"Start time or end time not positive");
            throw new IllegalArgumentException("Start time and end time needs to be positive");
        }
        this.numEvents = numEvents;
        this.source = source;
        this.startTime = startTime;
        this.endTime = endTime;
        this.compressedData = compressedData;
        this.compressedInfoCsv = compressedInfoCsv;
        this.sparkLookupCode = sparkLookupCode;
        this.lastChunk = lastChunk;
    }

    public SplunkEventChunk(String header, String compressedData, String compressedInfoCsv, String sparkLookupCode) throws IOException {
        String source;
        CSVParser parser = new CSVParser(',', '\"');
        String[] splits = parser.parseLine(header);
        this.source = source = splits[0];
        String startTimeStr = splits[1];
        this.startTime = Long.valueOf(startTimeStr);
        String endTimeStr = splits[2];
        this.endTime = Long.valueOf(endTimeStr);
        String numEventsStr = splits[3];
        String lastChunkStr = splits[4];
        this.numEvents = Integer.valueOf(numEventsStr);
        this.compressedData = compressedData;
        this.compressedInfoCsv = compressedInfoCsv;
        this.sparkLookupCode = sparkLookupCode;
        this.lastChunk = Boolean.valueOf(lastChunkStr);
    }

    public SplunkEventChunk(String source, List<SplunkEvent> events, String compressedInfoCsv, String sparkLookupCode, boolean lastChunk) {
        long start = System.currentTimeMillis();
        StringBuilder data = new StringBuilder();
        boolean first = true;
        long startTime = 0L;
        long endTime = Long.MAX_VALUE;
        int numEvents = events.size();
        long start1 = System.currentTimeMillis();
        SplunkEvent lastEvent = null;
        for (int i = 0; i < numEvents; ++i) {
            SplunkEvent event = events.get(i);
            if (first) {
                String metadata = event.getMetadata();
                data.append(metadata + "\n");
                startTime = event.getTime();
                first = false;
            }
            event.getData(data);
            data.append("\n");
            lastEvent = event;
        }
        if (lastEvent != null) {
            endTime = lastEvent.getTime();
        }
        logger.debug((Object)("Profiling: chunk processing: time taken to create event payload: " + (System.currentTimeMillis() - start1) + " millis"));
        try {
            long start2 = System.currentTimeMillis();
            String compressed = Utils.compressAndEncode(data.toString());
            logger.debug((Object)("Profiling: chunk processing: time taken to compress the event payload: " + (System.currentTimeMillis() - start2)));
            data = null;
            this.source = source;
            this.startTime = startTime;
            this.endTime = endTime;
            this.compressedData = compressed;
            this.numEvents = numEvents;
            this.lastChunk = lastChunk;
            this.compressedInfoCsv = compressedInfoCsv;
            this.sparkLookupCode = sparkLookupCode;
            logger.debug((Object)("Created event chunk: " + this));
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create event chunk: " + t.getMessage()), t);
            throw new RuntimeException("Error creating event chunk: " + t.getMessage(), t);
        }
        long elapsed = System.currentTimeMillis() - start;
        logger.debug((Object)("Time taken to create a chunk: " + elapsed + " millis"));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getSource() {
        return this.source;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public String getCompressedData() {
        return this.compressedData;
    }

    public String getCompressedInfoCsv() {
        return this.compressedInfoCsv;
    }

    public String getSparkLookupCode() {
        return this.sparkLookupCode;
    }

    public String toString() {
        return "event chunk=> source: " + this.source + ", startTime: " + this.startTime + ", endTime: " + this.endTime + ", numEvents: " + this.numEvents + ", lastChunk: " + this.lastChunk + ", startTime: " + this.startTime;
    }

    public boolean isLastChunk() {
        return this.lastChunk;
    }

    public Iterator<SplunkEvent> getEvents() {
        String decompressed = null;
        try {
            long start = System.currentTimeMillis();
            decompressed = Utils.decodeAndDecompress(this.compressedData);
            logger.debug((Object)("Profiling chunk processing: time to decompress data: " + (System.currentTimeMillis() - start)));
            BufferedReader br = new BufferedReader(new StringReader(decompressed));
            Iterator<SplunkEvent> ei = new CsvSplunkEventIterable(br).iterator();
            return ei;
        }
        catch (Throwable t) {
            logger.error((Object)("Error processing event chunk: " + t.getMessage()), t);
            logger.error((Object)decompressed);
            return new ArrayList().iterator();
        }
    }

    public String getHeader() {
        return "\"" + this.source + "\",\"" + this.startTime + "\",\"" + this.endTime + "\",\"" + this.numEvents + "\",\"" + this.lastChunk + "\"";
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("DFS_HOME") + "/spark-1.6.0-bin-hadoop2.6/conf/log4j.properties"));
        logger = Logger.getLogger(SplunkEventChunk.class);
    }
}

