/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

public class SplunkSearchResultsIterator {
    static final Logger logger = Logger.getLogger(SplunkSearchResultsIterator.class);

    public static Pair<SearchResult, Iterator<SearchResult>> iterator(BufferedReader br) {
        try {
            ChunkIterator ci;
            String chunkHeader = null;
            chunkHeader = br.readLine();
            if (chunkHeader == null) {
                return null;
            }
            if ((chunkHeader = chunkHeader.trim()).isEmpty()) {
                return null;
            }
            CSVParser parser = new CSVParser((Reader)new StringReader(chunkHeader), CSVFormat.DEFAULT);
            Iterator recs = parser.iterator();
            if (!recs.hasNext()) {
                parser.close();
                return null;
            }
            CSVRecord header = (CSVRecord)recs.next();
            if (header.size() != 4) {
                logger.error((Object)String.format("Header received is corrupt: %s", chunkHeader));
                parser.close();
                return null;
            }
            header.get(0);
            String currentSid = header.get(1);
            Integer query_finished = Integer.parseInt(header.get(2));
            if (query_finished != 0 && query_finished != 1) {
                parser.close();
                throw new RuntimeException(String.format("invalid query finished value in the payload header: %d", (int)query_finished));
            }
            SearchResult sri = SearchResultFactory.getInstance().emptyResult();
            sri.getDataMap().put(DFSSearchConstants.SRI_SID_KEY, currentSid);
            sri.getDataMap().put(DFSSearchConstants.REMOTE_SEARCH_QUERY_FINISHED, query_finished);
            int chunkSize = Integer.parseInt(header.get(3));
            if (chunkSize < 0) {
                parser.close();
                logger.warn((Object)String.format("Invalid chunk size: %d", chunkSize));
                return null;
            }
            ChunkIterator chunkIter = chunkSize > 0 ? (ci = new ChunkIterator(br)) : new ArrayList().iterator();
            parser.close();
            return new Pair<SearchResult, Iterator<SearchResult>>(sri, chunkIter);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error processing splunk search results", t);
        }
    }

    private static class ChunkIterator
    implements Iterator<SearchResult> {
        private SearchResult nextResult = null;
        private CSVParser parser = null;
        private SearchResult.FieldMeta[] header = null;
        private Iterator<CSVRecord> recs;
        private Reader r;

        ChunkIterator(Reader r) throws IOException {
            this.r = r;
            this.parser = new CSVParser(r, CSVFormat.DEFAULT);
            this.recs = this.parser.iterator();
            CSVRecord headerRec = this.recs.next();
            int size = headerRec.size();
            SearchResult.FieldMeta[] localHeader = new SearchResult.FieldMeta[size];
            for (int i = 0; i < size; ++i) {
                String fieldName = headerRec.get(i);
                SearchResult.FieldMeta field = SearchResult.FieldMeta.newFieldMeta(fieldName);
                SearchResult.FieldType type = SearchResultFactory.getType(field);
                field.setType(type);
                field.setSequence(i);
                localHeader[i] = field;
            }
            this.header = localHeader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextResult != null) {
                return true;
            }
            try {
                if (!this.recs.hasNext()) {
                    if (this.parser != null) {
                        try {
                            this.r.close();
                            this.parser.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                CSVRecord rec = this.recs.next();
                this.nextResult = SearchResultFactory.getInstance().createSearchResult(this.header, rec);
                return true;
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Could not parse the input chunk, reason: %s", t.getMessage()), t);
                try {
                    this.r.close();
                    this.parser.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new RuntimeException(t);
            }
        }

        @Override
        public SearchResult next() {
            SearchResult ret = this.nextResult;
            this.nextResult = null;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

