/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.SearchResultsWriter;
import com.splunk.df.search.compute.SearchResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DatasetExport {
    static final Logger logger = Logger.getLogger(DatasetExport.class);
    private Iterator<SearchResult> srs;

    public DatasetExport(Iterator<SearchResult> srs) {
        this.srs = srs;
    }

    private static SearchResult.FieldMeta[] getUniqueFields(SearchResult.FieldMeta[] fields) {
        HashSet<SearchResult.FieldMeta> unique = new HashSet<SearchResult.FieldMeta>();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            unique.add(fields[i]);
        }
        SearchResult.FieldMeta[] uniqueflds = new SearchResult.FieldMeta[unique.size()];
        return unique.toArray(uniqueflds);
    }

    public void exportToFile(String file) {
        try {
            File ofile;
            while ((ofile = new File(file)).exists()) {
                file = String.format("%s__nextgen", file);
                logger.warn((Object)String.format("file already exists, hence will attempt exporting to file: %s", file));
            }
            logger.info((Object)String.format("file to be used for export: %s", file));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            boolean first = true;
            SearchResult.FieldMeta[] fields = null;
            ArrayList<SearchResult> results = new ArrayList<SearchResult>();
            while (this.srs.hasNext()) {
                SearchResult sr = this.srs.next();
                fields = sr.getFieldNames();
                if (first) {
                    fields = DatasetExport.getUniqueFields(fields);
                    first = false;
                }
                results.add(sr);
            }
            SearchResultsWriter.write(results.iterator(), fields, bw);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("error exporting to file: %s", t.getMessage()), t);
        }
    }
}

