/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LocalShuffleManager
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(LocalShuffleManager.class);
    private static LocalShuffleManager singleton = new LocalShuffleManager();
    private HashMap<Integer, BufferedOutputStream> partitionStreams = new HashMap();
    private ArrayList<Integer> partitionIds = new ArrayList();
    private final String streamFileNamePrefix;

    private LocalShuffleManager() {
        boolean success;
        String partitionFilesRoot = System.getProperty("PARTITION_FILES_ROOT");
        if (partitionFilesRoot == null) {
            throw new RuntimeException(String.format("partition files root not found", new Object[0]));
        }
        File root = new File(partitionFilesRoot);
        if (!root.exists() && !(success = root.mkdirs())) {
            throw new RuntimeException(String.format("could not create partition files root: %s", partitionFilesRoot));
        }
        this.streamFileNamePrefix = root.getAbsolutePath();
    }

    public static LocalShuffleManager getInstance() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPartitionStream(int partitionId) throws IOException {
        if (this.partitionStreams.containsKey(partitionId)) {
            return;
        }
        HashMap<Integer, BufferedOutputStream> hashMap = this.partitionStreams;
        synchronized (hashMap) {
            if (this.partitionStreams.containsKey(partitionId)) {
                return;
            }
            String partitionFilePath = String.format("%s/%d.partition", this.streamFileNamePrefix, partitionId);
            File partitionFile = new File(partitionFilePath);
            if (!partitionFile.exists()) {
                partitionFile.createNewFile();
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(partitionFilePath));
            this.partitionStreams.put(partitionId, bos);
            this.partitionIds.add(partitionId);
        }
    }

    public void shuffle(Iterator<SearchResult> srs) {
        int numPars = this.partitionStreams.size();
        if (numPars == 0) {
            return;
        }
        HashMap<Integer, ArrayList> hashPartitioned = new HashMap<Integer, ArrayList>();
        while (srs.hasNext()) {
            ArrayList bucket;
            int targetPartitionId;
            SearchResult sr = srs.next();
            int hashCode = sr.hashCode();
            int targetPartitionIdx = numPars % hashCode;
            if (targetPartitionIdx < 0) {
                targetPartitionIdx *= -1;
            }
            if (!hashPartitioned.containsKey(targetPartitionId = this.partitionIds.get(targetPartitionIdx).intValue())) {
                bucket = new ArrayList();
                bucket.add(sr);
                hashPartitioned.put(targetPartitionId, bucket);
                continue;
            }
            bucket = (ArrayList)hashPartitioned.get(targetPartitionId);
            bucket.add(sr);
        }
    }
}

