/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public interface SearchResult
extends Serializable,
ComputeEngineConstants,
Comparable {
    public static final FieldMeta _TIME_FIELD_META = new FieldMeta("_time", -1, FieldType.UNKNOWN, false);

    public FieldMeta[] getFieldNames();

    public Object[] getFieldValues();

    public SRHashMap<FieldMeta, Object> getDataMap();

    public LinkedHashMap<FieldMeta, Object> getLinkedDataMap();

    public Object getFieldValue(FieldMeta var1);

    public int getSize();

    public boolean containsField(FieldMeta var1);

    public void updateField(FieldMeta var1, Object var2);

    public void setField(FieldMeta var1, Object var2);

    public void unsetField(FieldMeta var1);

    public boolean isEmpty();

    public void setSeed(long var1);

    public Long seed();

    public void renameField(FieldMeta var1, FieldMeta var2);

    public void setSid(String var1);

    public String sid();

    public SearchResult filterMVs();

    public void setContext(SRContext var1);

    public SRContext getContext();

    public static class FieldMeta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final int hashCode;
        private int sequence;
        private FieldType type;
        private final boolean intermediary;
        private FieldMeta mvName = null;
        private FieldMeta prestatsCountName;
        private FieldMeta prestatsSumName;
        private FieldMeta prestatsSumSquaredName;
        private FieldMeta prestatsMVFieldName;
        private FieldMeta prestatsPercName;
        private FieldMeta prestatsEarliestTimeName;
        private FieldMeta prestatsLatestTimeName;
        private FieldMeta prestatsSparklineName;
        private FieldMeta prestatsListName;
        private FieldMeta prestatsThresholdMin;
        private FieldMeta prestatsThresholdMax;
        private FieldMeta prestatsThresholdMinStr;
        private FieldMeta prestatsThresholdMaxStr;
        private FieldMeta prestatsThresholdFirst;
        private FieldMeta prestatsThresholdLast;

        public FieldMeta() {
            this.fieldName = null;
            this.hashCode = -1;
            this.intermediary = false;
        }

        public FieldMeta(String fieldName, int sequence, FieldType type, boolean intermediary) {
            this.fieldName = fieldName;
            this.hashCode = fieldName.hashCode();
            this.sequence = sequence;
            this.type = type;
            this.intermediary = intermediary;
        }

        public FieldMeta getPrestatsListName() {
            if (this.prestatsListName == null) {
                this.prestatsListName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_li_", this.fieldName));
            }
            return this.prestatsListName;
        }

        public FieldMeta getPrestatsSparklineName() {
            if (this.prestatsSparklineName == null) {
                this.prestatsSparklineName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_sl_", this.fieldName));
            }
            return this.prestatsSparklineName;
        }

        public FieldMeta getPrestatsEarliestTimeName() {
            if (this.prestatsEarliestTimeName == null) {
                this.prestatsEarliestTimeName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_et_", this.fieldName));
            }
            return this.prestatsEarliestTimeName;
        }

        public FieldMeta getPrestatsLatestTimeName() {
            if (this.prestatsLatestTimeName == null) {
                this.prestatsLatestTimeName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_lt_", this.fieldName));
            }
            return this.prestatsLatestTimeName;
        }

        public FieldMeta getPrestatsPercName() {
            if (this.prestatsPercName == null) {
                this.prestatsPercName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_rd_", this.fieldName));
            }
            return this.prestatsPercName;
        }

        public FieldMeta getPrestatsMVFieldName() {
            if (this.prestatsMVFieldName == null) {
                this.prestatsMVFieldName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_vm_", this.fieldName));
            }
            return this.prestatsMVFieldName;
        }

        public FieldMeta getPrestatsSumSquaredName() {
            if (this.prestatsSumSquaredName == null) {
                this.prestatsSumSquaredName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_ss_", this.fieldName));
            }
            return this.prestatsSumSquaredName;
        }

        public FieldMeta getMvName() {
            if (this.mvName == null) {
                this.mvName = FieldMeta.newFieldMeta(String.format("%s%s", "__mv_", this.fieldName));
            }
            return this.mvName;
        }

        public FieldMeta getPrestatsCountName() {
            if (this.prestatsCountName == null) {
                this.prestatsCountName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_nc_", this.fieldName));
            }
            return this.prestatsCountName;
        }

        public FieldMeta getPrestatsSumName() {
            if (this.prestatsSumName == null) {
                this.prestatsSumName = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_sm_", this.fieldName));
            }
            return this.prestatsSumName;
        }

        public static FieldMeta newFieldMeta(String fieldName) {
            return new FieldMeta(fieldName, -1, FieldType.UNKNOWN, false);
        }

        public static FieldMeta newFieldMeta_(String fieldName, boolean intermediary) {
            return new FieldMeta(fieldName, -1, FieldType.UNKNOWN, intermediary);
        }

        public FieldMeta setIsIntermediary(boolean intermediary) {
            return new FieldMeta(this.fieldName, this.sequence, this.type, intermediary);
        }

        public boolean isIntermediary() {
            return this.intermediary;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int sequence() {
            return this.sequence;
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }

        public FieldType type() {
            return this.type;
        }

        public void setType(FieldType type) {
            this.type = type;
        }

        public int length() {
            return this.fieldName.length();
        }

        public char charAt(int idx) {
            return this.fieldName.charAt(idx);
        }

        public FieldMeta concat(FieldMeta rhs) {
            return new FieldMeta(String.format("%s%s", this.fieldName(), rhs.fieldName()), -1, FieldType.UNKNOWN, this.intermediary);
        }

        public boolean equals(Object rhs) {
            return this.fieldName.equals(((FieldMeta)rhs).fieldName());
        }

        public FieldMeta prepend(String prefix) {
            return new FieldMeta(String.format("%s%s", prefix, this.fieldName), this.sequence, this.type, this.intermediary);
        }

        public FieldMeta reset(String newFieldName) {
            return new FieldMeta(newFieldName, this.sequence, this.type, this.intermediary);
        }

        public String toString() {
            return this.fieldName;
        }

        public FieldMeta getPrestatsThresholdMin() {
            if (this.prestatsThresholdMin == null) {
                this.prestatsThresholdMin = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_nn_", this.fieldName));
            }
            return this.prestatsThresholdMin;
        }

        public FieldMeta getPrestatsThresholdMax() {
            if (this.prestatsThresholdMax == null) {
                this.prestatsThresholdMax = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_nx_", this.fieldName));
            }
            return this.prestatsThresholdMax;
        }

        public FieldMeta getPrestatsThresholdMinStr() {
            if (this.prestatsThresholdMinStr == null) {
                this.prestatsThresholdMinStr = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_sn_", this.fieldName));
            }
            return this.prestatsThresholdMinStr;
        }

        public FieldMeta getPrestatsThresholdMaxStr() {
            if (this.prestatsThresholdMaxStr == null) {
                this.prestatsThresholdMaxStr = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_sx_", this.fieldName));
            }
            return this.prestatsThresholdMaxStr;
        }

        public FieldMeta getPrestatsThresholdFirst() {
            if (this.prestatsThresholdFirst == null) {
                this.prestatsThresholdFirst = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_fi_", this.fieldName));
            }
            return this.prestatsThresholdFirst;
        }

        public FieldMeta getPrestatsThresholdLast() {
            if (this.prestatsThresholdLast == null) {
                this.prestatsThresholdLast = FieldMeta.newFieldMeta(String.format("%s%s", "psrsvd_la_", this.fieldName));
            }
            return this.prestatsThresholdLast;
        }
    }

    public static class SRHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;

        public SRHashMap(int size) {
            super(size);
        }

        public SRHashMap() {
        }

        public SRHashMap(int size, float ratio) {
            super(size, ratio);
        }

        public SRHashMap(Map<K, V> rhs) {
            super(rhs);
        }

        @Override
        public V get(Object field) {
            return super.get(field);
        }

        @Override
        public V put(K field, V value) {
            return super.put(field, value);
        }

        @Override
        public V remove(Object field) {
            return super.remove(field);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return super.remove(key, value);
        }

        @Override
        public V replace(K key, V value) {
            return super.replace(key, value);
        }
    }

    public static class SRContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long numSrsInPartiton = 0L;

        public SRContext(int parId) {
        }

        public void addSrsInPartition() {
            ++this.numSrsInPartiton;
        }

        public long getSrsInPartition() {
            return this.numSrsInPartiton;
        }
    }

    public static enum FieldType {
        TIME_FIELD,
        STR_FIELD,
        UNKNOWN;

    }
}

