/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.commons.ast.nodes.IOrdering;
import com.splunk.commons.ast.nodes.expressions.SortNode;
import com.splunk.commons.ast.nodes.expressions.SortOrder;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import java.io.Serializable;
import java.util.Comparator;

public class SearchResultComparator
implements Comparator<SearchResult>,
Serializable {
    private static final long serialVersionUID = 1L;
    private SearchResult.FieldMeta[] sortFields;
    private int[] sortOrders;

    public SearchResultComparator(IOrdering[] fields) {
        this.init(fields);
    }

    private void init(IOrdering[] fields) {
        int len = fields.length;
        this.sortFields = new SearchResult.FieldMeta[len];
        this.sortOrders = new int[len];
        for (int i = 0; i < len; ++i) {
            IOrdering field = fields[i];
            String fieldName = field.getField().getFieldName();
            SortOrder sortOrder = field.getSortOrder();
            int ordering = sortOrder == SortOrder.ASC ? 1 : -1;
            this.sortFields[i] = SearchResult.FieldMeta.newFieldMeta(fieldName);
            this.sortOrders[i] = ordering;
        }
    }

    public SearchResultComparator(SearchResult.FieldMeta[] sFields, SortOrder sortOrder) {
        IOrdering[] fields = new IOrdering[sFields.length];
        for (int i = 0; i < sFields.length; ++i) {
            fields[i] = new SortNode(sFields[i].fieldName(), sortOrder);
        }
        this.init(fields);
    }

    @Override
    public int compare(SearchResult lhs, SearchResult rhs) {
        int len = this.sortFields.length;
        for (int i = 0; i < len; ++i) {
            int ret;
            SearchResult.FieldMeta fieldName = this.sortFields[i];
            int ordering = this.sortOrders[i];
            Object lhsVal = lhs.getFieldValue(fieldName);
            Object rhsVal = rhs.getFieldValue(fieldName);
            if (lhsVal == null && rhsVal == null) continue;
            if (lhsVal != null && rhsVal == null) {
                return 1 * ordering;
            }
            if (lhsVal == null && rhsVal != null) {
                return -1 * ordering;
            }
            if (lhsVal == null || rhsVal == null || (ret = SearchResultFactory.getInstance().compareTo(lhsVal, rhsVal)) == 0) continue;
            return ret * ordering;
        }
        Long lhsSeed = lhs.seed();
        Long rhsSeed = rhs.seed();
        if (lhsSeed != null && rhsSeed != null) {
            return lhsSeed.compareTo(rhsSeed);
        }
        return 0;
    }
}

