/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.Transformer;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TransformerRegistry
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(TransformerRegistry.class);
    private HashMap<String, Transformer> registry = new HashMap();

    public void registerTransformer(String cmdName, Transformer dg) {
        this.registry.put(cmdName, dg);
    }

    public Transformer getTransformer(CommandNode cmdn) {
        Transformer t = null;
        if (cmdn instanceof UnknownCommand) {
            t = this.registry.get("unknown");
            logger.error((Object)String.format("Transformer associated with unknown command node: %s, command name: %s", t.name(), cmdn.getCommandName()));
        } else {
            t = this.registry.get(cmdn.getCommandName());
        }
        if (t == null) {
            String message = String.format("Transformer not found for command node: %s, class %s", cmdn.getCommandName(), cmdn.getClass().getName());
            logger.error((Object)message);
            throw new RuntimeException(message);
        }
        return t;
    }
}

