/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.compute.spark.DFSKryoRegistrator;
import com.splunk.df.search.compute.spark.KryoRegisteredClassHolder;
import com.splunk.df.util.Utils;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.SparkStatusTracker;
import org.apache.spark.api.java.JavaSparkContext;
import org.json.JSONObject;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;

public class SparkUtils
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(SparkUtils.class);
    public static String sparkHome = null;

    static List<String> updateExecutors(SparkContext sc, int requested) {
        logger.debug((Object)String.format("received request for %d executors", requested));
        int required = Math.max(1, requested);
        required = Math.min(Utils.getMaxSupportedWorkers(), required);
        int currExecutors = SparkUtils.numExecutors(sc);
        if (required <= currExecutors) {
            logger.debug((Object)String.format("requested num executors: %d, already present: %d", required, currExecutors));
            return SparkUtils.getExecutorAddresses(sc);
        }
        boolean ret = sc.requestExecutors(required -= currExecutors);
        logger.info((Object)String.format("requested spark cluster manager for additional executors: %d, request accepted: %b, actual requested: %d", required, ret, requested));
        return SparkUtils.getExecutorAddresses(sc);
    }

    static int numExecutors(SparkContext sc) {
        return sc.getExecutorMemoryStatus().size();
    }

    static List<String> getExecutorAddresses(SparkContext sc) {
        Map executorStats = sc.getExecutorMemoryStatus();
        Iterator executorAddrs = executorStats.keysIterator();
        ArrayList<String> ret = new ArrayList<String>();
        while (executorAddrs.hasNext()) {
            String executorAddr = (String)executorAddrs.next();
            ret.add(executorAddr);
        }
        return ret;
    }

    static void printExecutorDetails(SparkContext sc) {
        Map executorStats = sc.getExecutorMemoryStatus();
        Iterator executorAddrs = executorStats.keysIterator();
        logger.info((Object)String.format("print details 1: number of executors: %d", executorStats.size()));
        while (executorAddrs.hasNext()) {
            String executorAddr = (String)executorAddrs.next();
            Tuple2 info = (Tuple2)executorStats.get((Object)executorAddr).get();
            long maxCacheMem = (Long)info._1();
            long remainingCacheMem = (Long)info._2();
            long usedCacheMem = maxCacheMem - remainingCacheMem;
            logger.info((Object)String.format("executor: %s, max cache size: %d bytes, remaining cache size: %d bytes, used cache size: %d bytes", executorAddr, maxCacheMem, remainingCacheMem, usedCacheMem));
        }
    }

    static void printExecutorDetails1(SparkContext sc) {
        SparkStatusTracker sst = sc.statusTracker();
        SparkExecutorInfo[] seis = sst.getExecutorInfos();
        logger.info((Object)String.format("print details 2: number of executors: %d", seis.length));
        for (int i = 0; i < seis.length; ++i) {
            SparkExecutorInfo sei = seis[i];
            logger.info((Object)String.format("executor: %d, cache size: %d bytes, host: %s, port: %d, running tasks: %d", i, sei.cacheSize(), sei.host(), sei.numRunningTasks(), sei.port()));
        }
    }

    private static int getLocalityWaitTimeSecs() {
        int localityWaitSecs = 7200;
        String localityWaitSecsStr = System.getenv("DFS_TASK_LOCALITY_WAIT_SECS");
        if (localityWaitSecsStr != null) {
            try {
                localityWaitSecs = Integer.parseInt(localityWaitSecsStr);
                logger.info((Object)String.format("task locality wait time set based on envvar: %d seconds", localityWaitSecs));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not set task locality wait timeout seconds: %s, reason: %s", localityWaitSecsStr, t.getMessage()));
            }
        }
        logger.info((Object)String.format("task locality timeout set to: %d seconds", localityWaitSecs));
        return localityWaitSecs;
    }

    private static boolean getEnableHistory() {
        boolean enable = false;
        String enableStr = System.getenv("ENABLE_HISTORY");
        if (enableStr != null) {
            try {
                enable = Boolean.valueOf(enableStr);
                logger.info((Object)String.format("enable history overridden via envvar: %b", enable));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("error parsing envvar: %s, value: %s into boolean", "ENABLE_HISTORY", enableStr));
            }
        }
        logger.info((Object)String.format("enable history set to: %b", enable));
        return enable;
    }

    private static double getMinStartupExecutorRatio() {
        double ratio = 1.0;
        String ratioStr = System.getenv("DFS_MIN_STARTUP_EXECUTOR_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("min startup executor ratio set to %.2f using envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar to double", "DFS_MIN_STARTUP_EXECUTOR_RATIO"));
            }
        }
        logger.info((Object)String.format("min startup executor ratio set to: %.2f", ratio));
        return ratio;
    }

    private static int getKryoSerializerMaxBufferSize() {
        int maxBuffMb = 256;
        String maxBuffStr = System.getenv("MAX_KRYO_BUFFER_SIZE_MB");
        if (maxBuffStr != null && !maxBuffStr.trim().isEmpty()) {
            try {
                maxBuffMb = Integer.parseInt(maxBuffStr);
                logger.info((Object)String.format("kryo serializer max buffer size set to: %d mbs through envvar", maxBuffMb));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse kryo serializer max buffer size to int: %s", maxBuffStr));
            }
        }
        logger.info((Object)String.format("max kryo buffer size set at: %d mbs", maxBuffMb));
        return maxBuffMb;
    }

    private static boolean isShuffleCompressed() {
        boolean compress = true;
        String compressStr = System.getenv("DFS_SHUFFLE_COMPRESS");
        if (compressStr != null && !compressStr.trim().isEmpty()) {
            try {
                compress = Boolean.valueOf(compressStr);
                logger.info((Object)String.format("shuffle compress set to: %b based on envvar", compress));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("shuffle compress envvar value could not be parsed to boolean: %s", compressStr));
            }
        }
        logger.info((Object)String.format("shuffle compress set to: %b", compress));
        return compress;
    }

    private static boolean showConsoleProgress() {
        return System.getenv("SHOW_DFC_CONSOLE_PROGRESS") != null ? Boolean.valueOf(System.getenv("SHOW_DFC_CONSOLE_PROGRESS")) : true;
    }

    private static long getWorkerIdleTimeoutSecs() {
        long timeout = 60L;
        String timeoutStr = System.getenv("DFS_WORKER_IDLE_TIMEOUT");
        if (timeoutStr != null && !timeoutStr.trim().isEmpty()) {
            try {
                timeout = Long.valueOf(timeoutStr);
                logger.info((Object)String.format("worker idle timeout updated through envvar: %d secs", timeout));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse worker timeout %s into long", timeoutStr));
            }
        }
        logger.info((Object)String.format("worker idle timeout set to: %d secs", timeout));
        return timeout;
    }

    public static JavaSparkContext createJavaSparkContext(DFCParams dfcParamsObj) {
        String dfcAppName = dfcParamsObj.getDfcTitle();
        String extraKryoClasses = dfcParamsObj.getExtraKryoClasses();
        SparkConf conf = new SparkConf().setAppName(dfcAppName);
        if (SparkUtils.showConsoleProgress()) {
            conf.set("spark.ui.showConsoleProgress", "true");
        } else {
            conf.set("spark.ui.showConsoleProgress", "false");
        }
        conf.set("spark.task.maxFailures", "1");
        logger.info((Object)String.format("is execution elastic: %s", String.valueOf(Utils.isDfsElasticModeEnabled())));
        if (Utils.isDfsElasticModeEnabled()) {
            conf.set("spark.shuffle.service.enabled", "true");
            conf.set("spark.dynamicAllocation.enabled", "true");
            conf.set("spark.dynamicAllocation.executorIdleTimeout", String.format("%ds", SparkUtils.getWorkerIdleTimeoutSecs()));
            conf.set("spark.dynamicAllocation.minExecutors", String.valueOf(Utils.getElasticStartNumWorkers()));
            conf.set("spark.dynamicAllocation.maxExecutors", String.valueOf(Utils.getElasticStartNumWorkers()));
        }
        int localityWaitSecs = SparkUtils.getLocalityWaitTimeSecs();
        localityWaitSecs = Math.max(1, localityWaitSecs);
        conf.set("spark.locality.wait", String.format("%ds", localityWaitSecs));
        double mrrr = SparkUtils.getMinStartupExecutorRatio();
        mrrr = Math.min(1.0, mrrr);
        conf.set("spark.scheduler.minRegisteredResourcesRatio", String.format("%.2f", mrrr));
        conf.set("spark.driver.maxResultSize", String.format("%dg", SparkUtils.getMaxDriverResultsSize()));
        String sparkLocalDir = Utils.createScratchDirectory();
        conf.set("spark.local.dir", sparkLocalDir);
        SparkUtils.configureHistory(conf);
        SparkUtils.configureSerdes(conf, extraKryoClasses);
        SparkUtils.configureNetworkSettings(conf);
        SparkUtils.configureShuffle(conf, dfcParamsObj);
        long start = System.currentTimeMillis();
        JavaSparkContext sc = new JavaSparkContext(conf);
        logger.info((Object)String.format("time taken to start spark context: %d millis", System.currentTimeMillis() - start));
        SparkUtils.printSparkConfWithoutSecurityInfo(sc);
        return sc;
    }

    private static int getMaxDriverResultsSize() {
        int size = 24;
        String sizeStr = System.getenv("DFS_MAX_DRIVER_RESULTS_SIZE_GIGS");
        if (sizeStr != null && !sizeStr.trim().isEmpty()) {
            try {
                size = Integer.valueOf(sizeStr);
                logger.info((Object)String.format("max driver results size set to: %d gigs by envvar", size));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max driver results size to int: %s", sizeStr));
            }
        }
        logger.info((Object)String.format("max driver results size set to: %d gigs", size));
        return size;
    }

    private static int getMaxShuffleRequestsPerExecutor() {
        int requests = 1000;
        String requestsStr = System.getenv("DFS_MAX_SHUFFLE_REQUESTS_PER_EXECUTOR");
        if (requestsStr != null && !requestsStr.trim().isEmpty()) {
            try {
                requests = Integer.valueOf(requestsStr);
                logger.info((Object)String.format("max shuffle requests per executor set at: %d through envvar", requests));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max shuffle requests per executor to int: %s", requestsStr));
            }
        }
        logger.info((Object)String.format("max shuffle requests per executor set at: %d", requests));
        return requests;
    }

    private static void configureShuffle(SparkConf conf, DFCParams params) {
        conf.set("spark.shuffle.io.preferDirectBufs", "true");
        conf.set("spark.shuffle.spill.compress", String.format("%b", SparkUtils.isShuffleCompressed()));
        conf.set("spark.shuffle.compress", String.format("%b", SparkUtils.isShuffleCompressed()));
        int numExecutors = params.getDfcNumExecutors();
        numExecutors = Math.max(1, numExecutors);
        int numReqsInFlight = numExecutors * SparkUtils.getMaxShuffleRequestsPerExecutor();
        conf.set("spark.reducer.maxReqsInFlight", String.format("%d", numReqsInFlight));
    }

    private static boolean supportPoorNetwork() {
        boolean poor = false;
        String poorStr = System.getenv("DFS_SUPPORT_POOR_NETWORK");
        if (poorStr != null && !poorStr.trim().isEmpty()) {
            try {
                poor = Boolean.valueOf(poorStr);
                logger.info((Object)String.format("support for poor network set to: %b via envvar", poor));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse support poor network envar to boolean: %s", poorStr));
            }
        }
        logger.info((Object)String.format("support for poor network set to: %b", poor));
        return poor;
    }

    private static int getNetworkTimeoutSecs() {
        int timeout = 1800;
        String timeoutStr = System.getenv("DFS_NETWORK_TIMEOUT_SECS");
        if (timeoutStr != null && !timeoutStr.trim().isEmpty()) {
            try {
                timeout = Integer.valueOf(timeoutStr);
                logger.info((Object)String.format("network timeout set to: %d secs based on envvar", timeout));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse network timeout secs from %s", timeoutStr));
            }
        }
        logger.info((Object)String.format("network timeout set to: %d secs", timeout));
        return timeout;
    }

    private static void configureNetworkSettings(SparkConf conf) {
        conf.set("spark.rpc.message.maxSize", String.format("%d", SparkUtils.getRpcMessageMaxSize()));
        int networkTimeout = SparkUtils.getNetworkTimeoutSecs();
        if (SparkUtils.supportPoorNetwork()) {
            conf.set("spark.network.timeout", String.format("%ds", 10 * networkTimeout));
            conf.set("spark.executor.heartbeatInterval", String.format("%ds", 300));
            conf.set("spark.rpc.retry.wait", String.format("%ds", 60));
            conf.set("spark.rpc.numRetries", String.format("%d", 10));
        } else {
            conf.set("spark.network.timeout", String.format("%ds", networkTimeout));
        }
    }

    private static String getDefaultSerializer() {
        String ser = "kryoser";
        String serStr = System.getenv("DFS_EXECUTION_SERIALIZER");
        boolean setViaEnvvar = false;
        if (serStr != null) {
            ser = serStr;
            setViaEnvvar = true;
        }
        String ret = "org.apache.spark.serializer.KryoSerializer";
        if (ser.equals("javaser")) {
            ret = "org.apache.spark.serializer.JavaSerializer";
        } else if (ser.equals("kryoser")) {
            ret = "org.apache.spark.serializer.KryoSerializer";
        } else {
            logger.info((Object)String.format("unsupported execution serializer tag: %s, will default to: %s", ser, ret));
        }
        logger.info((Object)String.format("default execution serializer set to: %s, set via envvar: %b", ret, setViaEnvvar));
        return ret;
    }

    private static void configureSerdes(SparkConf conf, String extraKryoClasses) {
        String serializer = SparkUtils.getDefaultSerializer();
        conf.set("spark.serializer", serializer);
        if (SparkUtils.useFastSerdes()) {
            DFSKryoRegistrator.extraKryoClasses = extraKryoClasses;
            conf.set("spark.kryo.registrator", "com.splunk.df.search.compute.spark.DFSKryoRegistrator");
        } else if (serializer.equals("org.apache.spark.serializer.KryoSerializer")) {
            int maxBuffMb = SparkUtils.getKryoSerializerMaxBufferSize();
            conf.set("spark.kryoserializer.buffer.max", String.format("%dm", maxBuffMb));
            conf.set("spark.kryo.referenceTracking", "false");
            conf.set("spark.kryo.unsafe", "true");
            conf.set("spark.kryo.registrationRequired", "true");
            conf.registerKryoClasses(KryoRegisteredClassHolder.getClasses(extraKryoClasses));
        }
    }

    private static int getRpcMessageMaxSize() {
        int size = 1280;
        String sizeStr = System.getenv("DFS_RPC_MESSAGE_MAX_SIZE_MBS");
        if (sizeStr != null && !sizeStr.trim().isEmpty()) {
            try {
                size = Integer.valueOf(sizeStr);
                logger.info((Object)String.format("rpc message max size set to: %d mbs by envvar", size));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse rpc message max size to int: %s", sizeStr));
            }
        }
        logger.info((Object)String.format("rpc message max size set to: %d mbs", size));
        return size;
    }

    private static void configureHistory(SparkConf conf) {
        boolean enableHistory = SparkUtils.getEnableHistory();
        if (enableHistory) {
            String sparkHome = System.getenv("SPARK_HOME");
            if (sparkHome != null) {
                File eventLogDir = new File(Paths.get(String.format("%s/eventlog/", sparkHome), new String[0]).toString());
                if (!eventLogDir.exists()) {
                    if (eventLogDir.mkdirs()) {
                        logger.info((Object)String.format("created event log directory since it did not exist: %s", eventLogDir.getAbsolutePath()));
                    } else {
                        logger.warn((Object)String.format("could not create event log directory: %s hence disabling history", eventLogDir.getAbsolutePath()));
                        enableHistory = false;
                    }
                } else {
                    logger.info((Object)String.format("event log directory already exists: %s", eventLogDir.getAbsolutePath()));
                }
                if (enableHistory) {
                    conf.set("spark.eventLog.dir", "file://" + eventLogDir.toString());
                }
            } else {
                logger.info((Object)String.format("could not enable dfc execution history since SPARK_HOME is not set as envvar hence disabling history", new Object[0]));
                enableHistory = false;
            }
        }
        if (enableHistory) {
            conf.set("spark.eventLog.enabled", "true");
            logger.info((Object)String.format("enabled history since all configurations could bet set correctly", new Object[0]));
        }
    }

    private static boolean useFastSerdes() {
        boolean fast = false;
        String fastStr = System.getenv("DFS_ENABLE_FAST_SERDES");
        if (fastStr != null && !fastStr.trim().isEmpty()) {
            try {
                fast = Boolean.valueOf(fastStr);
                logger.info((Object)String.format("fast serdes mode set to: %b using envvar", fast));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse fast serdes mode to boolean: %s", fastStr));
            }
        }
        logger.info((Object)String.format("fast serdes mode set to: %b", fast));
        return fast;
    }

    private static void printSparkConfWithoutSecurityInfo(JavaSparkContext sc) {
        String version = sc.version();
        SparkConf sparkConfWithoutPassword = sc.getConf().clone();
        Tuple2[] authenticateConfs = sparkConfWithoutPassword.getAllWithPrefix("spark.authenticate");
        Tuple2[] sslConfs = sparkConfWithoutPassword.getAllWithPrefix("spark.ssl");
        if (authenticateConfs != null && authenticateConfs.length != 0) {
            for (Tuple2 t : authenticateConfs) {
                sparkConfWithoutPassword.remove(String.format("%s%s", "spark.authenticate", t._1()));
            }
        }
        if (sslConfs != null && sslConfs.length != 0) {
            for (Tuple2 t : sslConfs) {
                sparkConfWithoutPassword.remove(String.format("%s%s", "spark.ssl", t._1()));
            }
        }
        logger.info((Object)String.format("Created dfs context, with conf: %s\nSpark Core Version: %s", sparkConfWithoutPassword.toDebugString(), version));
    }

    public static String getSparkHome(String splunkConf) {
        sparkHome = new JSONObject(splunkConf).getJSONObject("server").getString("spark_home");
        logger.debug((Object)String.format("Spark Home (spark_home): %s", sparkHome));
        return sparkHome;
    }
}

