/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.splunkcompute.Flushable;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSerdes
implements Serdes,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(JsonSerdes.class);

    @Override
    public void write(Flushable flushable, Iterator<SplunkRecord> srs) throws IOException {
        BufferedWriter bw = (BufferedWriter)flushable.source();
        String json = JsonSerdes.toJson(srs);
        bw.write(json);
    }

    @Override
    public Iterator<SplunkRecord> read(Flushable flushable, InputStream is) throws IOException {
        final BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return new Iterator<SplunkRecord>(){
            private SplunkRecord sr;
            private boolean eof = false;

            @Override
            public boolean hasNext() {
                try {
                    if (this.sr != null) {
                        return true;
                    }
                    if (this.eof) {
                        return false;
                    }
                    String currLine = br.readLine();
                    if (currLine == null) {
                        this.eof = true;
                        br.close();
                        return false;
                    }
                    StringBuilder rec = new StringBuilder();
                    rec.append(currLine);
                    while ((currLine = br.readLine()) != null && (currLine.isEmpty() || currLine.length() != "$$EOR$$".length() || currLine.charAt(0) != '$' || currLine.charAt(1) != '$' || !currLine.equals("$$EOR$$"))) {
                        rec.append(currLine);
                    }
                    String recStr = rec.toString();
                    JSONObject recJson = new JSONObject(recStr);
                    SearchResult keySr = null;
                    if (recJson.has("key")) {
                        JSONObject keyJson = recJson.getJSONObject("key");
                        keySr = JsonSerdes.this.fromJson(keyJson);
                    }
                    JSONObject valJson = recJson.getJSONObject("value");
                    SearchResult valSr = JsonSerdes.this.fromJson(valJson);
                    this.sr = keySr != null ? new SplunkKVRecord(keySr, valSr) : new SplunkRecord(valSr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
                return true;
            }

            @Override
            public SplunkRecord next() {
                if (this.sr == null && !this.hasNext()) {
                    logger.error((Object)String.format("no records available in temp", new Object[0]));
                    throw new RuntimeException(String.format("no records available in temp", new Object[0]));
                }
                SplunkRecord ret = this.sr;
                this.sr = null;
                return ret;
            }
        };
    }

    private static Type getType(Object val) {
        if (val instanceof String) {
            return Type.STRING;
        }
        if (val instanceof Long) {
            return Type.LONG;
        }
        if (val instanceof Integer) {
            return Type.INTEGER;
        }
        throw new RuntimeException(String.format("unsuppoted type: %s", val.getClass().getName()));
    }

    private static String toJson(Iterator<SplunkRecord> srs) {
        StringBuilder sb = new StringBuilder();
        while (srs.hasNext()) {
            SplunkRecord sr = srs.next();
            String srJson = JsonSerdes.toJson(sr);
            sb.append(srJson).append("\n").append("$$EOR$$").append("\n");
        }
        return sb.toString();
    }

    private static String toJson(SearchResult sr) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SearchResult.FieldMeta[] fieldNames = sr.getFieldNames();
        Object[] fieldValues = sr.getFieldValues();
        int len = fieldNames.length;
        for (int i = 0; i < len; ++i) {
            String fieldName = fieldNames[i].fieldName();
            Object fieldValue = fieldValues[i];
            sb.append("\"").append(fieldName).append("\":[\"").append(fieldValue.toString()).append("\",").append(JsonSerdes.getType(fieldValue).ordinal()).append("]");
            if (i >= len - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String toJson(SplunkRecord sr) {
        StringBuilder sb = new StringBuilder();
        if (sr instanceof SplunkKVRecord) {
            SplunkKVRecord kvSr = (SplunkKVRecord)sr;
            sb.append("{ key: ").append(JsonSerdes.toJson(kvSr.getKey())).append(", value: ").append(JsonSerdes.toJson(kvSr.getVal())).append("}");
        } else {
            sb.append("{ value: ").append(JsonSerdes.toJson(sr.getVal())).append("}");
        }
        return sb.toString();
    }

    private SearchResult fromJson(JSONObject json) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        ArrayList<SearchResult.FieldMeta> fields = new ArrayList<SearchResult.FieldMeta>();
        ArrayList<Object> vals = new ArrayList<Object>();
        Iterator keyStrs = json.keys();
        while (keyStrs.hasNext()) {
            String keyStr = (String)keyStrs.next();
            SearchResult.FieldMeta field = SearchResult.FieldMeta.newFieldMeta(keyStr);
            JSONArray valArr = json.getJSONArray(keyStr);
            String valStr = valArr.getString(0);
            int type = valArr.getInt(1);
            Object val = JsonSerdes.convertToType(type, valStr);
            fields.add(field);
            vals.add(val);
            data.put(field, val);
        }
        return SearchResultFactory.getInstance().createSearchResult(data, fields, vals);
    }

    private static Object convertToType(int typeInt, String valStr) {
        if (typeInt == Type.LONG.ordinal()) {
            return Long.valueOf(valStr);
        }
        return valStr;
    }

    @Override
    public void end(Flushable flushable) {
    }

    @Override
    public Flushable createWriter(OutputStream os) {
        final BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        return new Flushable(){
            boolean ended = false;

            @Override
            public void flush() throws IOException {
                if (this.ended) {
                    return;
                }
                bw.flush();
            }

            @Override
            public Object source() {
                return bw;
            }

            @Override
            public void end() {
                if (this.ended) {
                    throw new RuntimeException(String.format("cannot end a flushable which is already ended", new Object[0]));
                }
                this.ended = true;
            }

            @Override
            public boolean ended() {
                return this.ended;
            }
        };
    }

    public static void main(String[] args) {
        SearchResult.FieldMeta keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1");
        String keyVal1 = "KeyVal1";
        SearchResult.FieldMeta keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2");
        Integer keyVal2 = 10;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> keyData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] keyFields = new SearchResult.FieldMeta[2];
        Object[] keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        SearchResult.FieldMeta valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        String valVal1 = "ValVal1";
        SearchResult.FieldMeta valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        Integer valVal2 = 20;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> valData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] valFields = new SearchResult.FieldMeta[2];
        Object[] valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        SearchResult valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        ArrayList<SplunkKVRecord> kvSrs = new ArrayList<SplunkKVRecord>();
        SplunkKVRecord kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1_1");
        keyVal1 = "KeyVal1_1";
        keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2_1");
        keyVal2 = 30;
        keyData = new SearchResult.SRHashMap();
        keyFields = new SearchResult.FieldMeta[2];
        keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        valVal1 = "ValVal1";
        valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        valVal2 = 40;
        valData = new SearchResult.SRHashMap();
        valFields = new SearchResult.FieldMeta[2];
        valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonSerdes sd = new JsonSerdes();
            Flushable flushable = sd.createWriter(baos);
            sd.write(flushable, kvSrs.iterator());
            sd.end(flushable);
            flushable.flush();
            byte[] serData = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serData);
            Iterator<SplunkRecord> srsIter = sd.read(flushable, bais);
            while (srsIter.hasNext()) {
                SplunkKVRecord locKvSr = (SplunkKVRecord)srsIter.next();
                System.out.println(String.format("deser key: %s, value: %s", locKvSr.getKey().toString(), locKvSr.getVal().toString()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static enum Type {
        STRING,
        LONG,
        INTEGER;

    }
}

