/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.splunkcompute.HashPartitioner;
import com.splunk.df.search.compute.splunkcompute.MapPartitionFunction;
import com.splunk.df.search.compute.splunkcompute.Partition;
import com.splunk.df.search.compute.splunkcompute.Partitioner;
import com.splunk.df.search.compute.splunkcompute.RangePartitioner;
import com.splunk.df.search.compute.splunkcompute.SplunkComparator;
import com.splunk.df.search.compute.splunkcompute.SplunkComputeConstants;
import com.splunk.df.search.compute.splunkcompute.SplunkComputer;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkReducer;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Logger;

public class PartitionedDataset
implements SplunkComputeConstants {
    static final Logger logger = Logger.getLogger(PartitionedDataset.class);
    private final List<Partition> partitions;
    private final SplunkComputer computer;
    private String name;
    private String uuid;
    private boolean isNewStage;
    private final PartitionedDataset ancestor;
    private final boolean ordered;
    private final String workDir;

    public PartitionedDataset(String workDir, PartitionedDataset ancestor, SplunkComputer computer, String name, boolean isNewStage, boolean ordered) {
        this.partitions = new ArrayList<Partition>();
        this.computer = computer;
        this.name = name;
        this.workDir = workDir;
        this.isNewStage = isNewStage;
        this.ancestor = ancestor;
        this.ordered = ordered;
        this.setUuid();
    }

    private void setUuid() {
        UUID uuid = UUID.randomUUID();
        this.uuid = String.format("kvdataset_%s_%s", uuid.toString(), this.name);
        for (Partition par : this.partitions) {
            par.setUUID(this.uuid);
        }
    }

    protected List<Partition> partitions() {
        return this.partitions;
    }

    public PartitionedDataset(String workDir, PartitionedDataset ancestor, SplunkComputer computer, List<Partition> partitions, String name, boolean isNewStage, boolean ordered) {
        this.partitions = partitions;
        this.computer = computer;
        this.name = name;
        this.workDir = workDir;
        UUID uuid = UUID.randomUUID();
        this.uuid = String.format("kvdataset_%s_%s", uuid.toString(), name);
        for (Partition par : partitions) {
            par.setUUID(this.uuid);
        }
        this.isNewStage = isNewStage;
        this.ancestor = ancestor;
        this.ordered = ordered;
    }

    public PartitionedDataset mapPartitions(MapPartitionFunction func, String name) {
        Iterator<Partition> parIter = this.partitions.iterator();
        ArrayList<Partition> ret = new ArrayList<Partition>();
        while (parIter.hasNext()) {
            Partition par = parIter.next();
            par = par.mapPartition(func);
            ret.add(par);
        }
        return new PartitionedDataset(this.workDir, this, this.computer, ret, name, false, this.ordered);
    }

    public PartitionedDataset mapPartitions(MapPartitionFunction func, String name, boolean ordered) {
        Iterator<Partition> parIter = this.partitions.iterator();
        ArrayList<Partition> ret = new ArrayList<Partition>();
        while (parIter.hasNext()) {
            Partition par = parIter.next();
            par = par.mapPartition(func);
            ret.add(par);
        }
        return new PartitionedDataset(this.workDir, this, this.computer, ret, name, false, ordered);
    }

    public PartitionedDataset repartition(int numPars) {
        int i;
        numPars = Math.max(1, numPars);
        logger.info((Object)String.format("repartitiong to: %d", numPars));
        ArrayList<Partition> ret = new ArrayList<Partition>(numPars);
        int existingPars = this.partitions.size();
        for (i = 0; i < numPars; ++i) {
            if (i < existingPars) {
                ret.add(this.partitions.get(i).setPartitionId(i));
                continue;
            }
            ret.add(new Partition(this.workDir, this.uuid, i));
        }
        Partition firstPartition = (Partition)ret.get(0);
        while (i < existingPars) {
            Partition remaining = this.partitions.get(i);
            firstPartition = firstPartition.merge(remaining).setPartitionId(0);
            ret.set(0, firstPartition);
            ++i;
        }
        return new PartitionedDataset(this.workDir, this, this.computer, ret, "repartitioned", false, false);
    }

    public long count() {
        long start = System.currentTimeMillis();
        PartitionedDataset countPd = this.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                long partitionCount = 0L;
                while (srs.hasNext()) {
                    srs.next();
                    ++partitionCount;
                }
                SearchResult sr = SearchResultFactory.getInstance().createSearchResult(SearchResult.FieldMeta.newFieldMeta("partitionCount"), partitionCount);
                ArrayList<SplunkRecord> ret = new ArrayList<SplunkRecord>();
                ret.add(new SplunkRecord(sr));
                return ret.iterator();
            }

            @Override
            public String desc() {
                return new Throwable("partition counter lambda").getStackTrace()[0].toString();
            }
        }, "perPartitionCount");
        Iterator<SplunkRecord> partitionCounts = countPd.iterator(-1L);
        logger.info((Object)"retrieved records from dataset");
        long totalCount = 0L;
        int numRecs = 0;
        while (partitionCounts.hasNext()) {
            SplunkRecord rec = partitionCounts.next();
            SearchResult sr = rec.getVal();
            long partitionCount = (Long)sr.getFieldValue(SearchResult.FieldMeta.newFieldMeta("partitionCount"));
            totalCount += partitionCount;
            ++numRecs;
        }
        logger.info((Object)String.format("number of partition counter records fetched: %d", numRecs));
        logger.info((Object)String.format("total count %d, time taken: %d millis", totalCount, System.currentTimeMillis() - start));
        return totalCount;
    }

    protected Iterator<SplunkRecord> iterator(long limit) {
        if (this.ancestor != null) {
            this.ancestor.computeStage();
        }
        if (this.partitions.isEmpty()) {
            return new ArrayList().iterator();
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        final LinkedBlockingDeque queue = new LinkedBlockingDeque(1000);
        final int numPars = this.partitions.size();
        logger.info((Object)String.format("partitioned dataset iterator: will retrieve from dataset with %d partitions", numPars));
        Iterator<Partition> pars = this.partitions.iterator();
        ArrayList parHdls = new ArrayList();
        final LinkedBlockingDeque status = new LinkedBlockingDeque();
        final int chunkSize = 100;
        int idx = 0;
        final Integer coord = 1;
        final boolean[] stop = new boolean[]{false};
        final Throwable[] error = new Throwable[1];
        logger.info((Object)String.format("ordered fetch: %b", this.ordered));
        while (pars.hasNext()) {
            final Partition par = pars.next();
            final int parIdx = idx++;
            Future<?> parHdl = this.computer.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (stop[0] || error[0] != null) {
                            return;
                        }
                        Iterator<SplunkRecord> srs = par.iterator();
                        ArrayList<SplunkRecord> chunk = new ArrayList<SplunkRecord>(chunkSize);
                        if (PartitionedDataset.this.ordered && parIdx > 0) {
                            while (status.isEmpty() || (Integer)status.peekLast() < parIdx - 1) {
                                Utils.wait(coord, 10L);
                                if (!stop[0] && error[0] == null) continue;
                                return;
                            }
                        }
                        while (srs.hasNext()) {
                            SplunkRecord sr = srs.next();
                            chunk.add(sr);
                            if (chunk.size() < chunkSize) continue;
                            while (!queue.offer(chunk)) {
                                Utils.wait(coord, 10L);
                                if (!stop[0] && error[0] == null) continue;
                                return;
                            }
                            Utils.notifyAll(coord);
                            chunk = new ArrayList(chunkSize);
                        }
                        if (!chunk.isEmpty()) {
                            while (!queue.offer(chunk)) {
                                Utils.wait(coord, 10L);
                                if (!stop[0] && error[0] == null) continue;
                                return;
                            }
                        }
                        status.offerLast(parIdx);
                        Utils.notifyAll(coord);
                    }
                    catch (Throwable t) {
                        logger.info((Object)String.format("error retrieving records from partition: %d, in dataset: %s, reason: %s", parIdx, PartitionedDataset.this.name, t.getMessage()), t);
                        error[0] = t;
                    }
                }
            });
            parHdls.add(parHdl);
        }
        final long tempLimit = limit;
        return new Iterator<SplunkRecord>(){
            Iterator<SplunkRecord> chunk;
            long remaining;
            {
                this.remaining = tempLimit;
            }

            @Override
            public boolean hasNext() {
                if (error[0] != null) {
                    logger.error((Object)String.format("error occurred during partition executions: %s", error[0].getMessage()), error[0]);
                    throw new RuntimeException(error[0]);
                }
                if (this.remaining == 0L) {
                    return false;
                }
                while (true) {
                    if (this.chunk != null && this.chunk.hasNext()) {
                        return true;
                    }
                    if (!queue.isEmpty()) {
                        this.chunk = ((ArrayList)queue.poll()).iterator();
                        Utils.notifyAll(coord);
                        return true;
                    }
                    if (status.size() >= numPars) break;
                    Utils.wait(coord, 10L);
                }
                if (!queue.isEmpty()) {
                    this.chunk = ((ArrayList)queue.poll()).iterator();
                    return true;
                }
                return false;
            }

            @Override
            public SplunkRecord next() {
                SplunkRecord sr = this.chunk.next();
                --this.remaining;
                if (this.remaining == 0L) {
                    stop[0] = true;
                }
                return sr;
            }
        };
    }

    public int numPartitions() {
        return this.partitions.size();
    }

    public SplunkComputer computer() {
        return this.computer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Iterator<Partition> pars = this.partitions.iterator();
        ArrayList parHdls = new ArrayList();
        final Integer coord = 0;
        while (pars.hasNext()) {
            final Partition partition = pars.next();
            Future<?> parHdl = this.computer.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator<SplunkRecord> srs = partition.iterator();
                    while (srs.hasNext()) {
                        srs.next();
                    }
                    Object object = coord;
                    synchronized (object) {
                        coord.notifyAll();
                    }
                }
            });
            parHdls.add(parHdl);
        }
        block6: for (Future<?> parHdl : parHdls) {
            while (true) {
                Integer n = coord;
                synchronized (n) {
                    try {
                        coord.wait(10L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (parHdl.isDone()) continue block6;
            }
        }
    }

    public void computeStage() {
        if (this.ancestor != null) {
            this.ancestor.computeStage();
        }
        if (this.isNewStage) {
            logger.info((Object)String.format("will execute dataset: %s since it has been marked as new stage", this.name));
            long start = System.currentTimeMillis();
            this.execute();
            this.isNewStage = false;
            logger.info((Object)String.format("dataset: %s executed and ready for next stage, time taken: %d millis", this.name, System.currentTimeMillis() - start));
        }
    }

    public List<SplunkRecord> retrieve(long count) {
        long start = System.currentTimeMillis();
        ArrayList<SplunkRecord> ret = new ArrayList<SplunkRecord>();
        Iterator<SplunkRecord> srs = this.iterator(count);
        while (srs.hasNext()) {
            ret.add(srs.next());
        }
        logger.info((Object)String.format("partitioned dataset retrieve: time taken to retrieve records: %d millis", System.currentTimeMillis() - start));
        return ret;
    }

    public boolean isNewStage() {
        return this.isNewStage;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isEmpty() {
        long count = this.count();
        return count <= 0L;
    }

    public void setName(String name) {
        this.name = name;
        this.setUuid();
    }

    public PartitionedDataset cache() {
        final ArrayList<Partition> postCache = new ArrayList<Partition>();
        int numPars = this.partitions.size();
        for (int i = 0; i < numPars; ++i) {
            Partition par = new Partition(this.workDir, this.uuid, i, new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                    return new ArrayList().iterator();
                }

                @Override
                public String desc() {
                    return new Throwable("post temp holder lambda").getStackTrace()[0].toString();
                }
            });
            postCache.add(par);
        }
        ArrayList<Partition> ret = new ArrayList<Partition>(this.partitions.size());
        int i = 0;
        while (i < numPars) {
            Partition par = this.partitions.get(i);
            final int tempParIdx = i++;
            Partition transformed = par.mapPartition(new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                    Partition postCachePar = (Partition)postCache.get(tempParIdx);
                    postCachePar.temp(srs);
                    return srs;
                }

                @Override
                public String desc() {
                    return new Throwable("temping lambda").getStackTrace()[0].toString();
                }
            });
            ret.add(transformed);
        }
        PartitionedDataset postCacheStage = new PartitionedDataset(this.workDir, this, this.computer, ret, String.format("%s_%s", this.name, "cacheTemped"), true, this.ordered);
        Iterator pars = postCache.iterator();
        ret = new ArrayList();
        int parIdx = 0;
        while (pars.hasNext()) {
            final Partition cached = (Partition)pars.next();
            int tempParIdx = parIdx++;
            Partition readFromTemp = new Partition(this.workDir, this.uuid, cached.partitionId(), new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                    return cached.readFromTemp();
                }

                @Override
                public String desc() {
                    return new Throwable("temp reader lambda").getStackTrace()[0].toString();
                }
            });
            ret.add(readFromTemp);
        }
        return new PartitionedDataset(this.workDir, postCacheStage, this.computer, ret, String.format("%s_%s", this.name, "cachedReadFromTemp"), false, this.ordered);
    }

    public String workDir() {
        return this.workDir;
    }

    public String name() {
        return this.name;
    }

    public boolean ordered() {
        return this.ordered;
    }

    public String uuid() {
        return this.uuid;
    }

    public PartitionedDataset ancestor() {
        return this.ancestor;
    }

    public void shuffle(Iterator<SplunkRecord> kvSrs, List<Partition> shuffleDest, Partitioner p) {
        HashMap<Integer, ArrayList<SplunkKVRecord>> tempKvSrs = new HashMap<Integer, ArrayList<SplunkKVRecord>>();
        while (kvSrs.hasNext()) {
            SplunkKVRecord kvSr = (SplunkKVRecord)kvSrs.next();
            int destPartitionId = p.partition(kvSr);
            ArrayList<SplunkKVRecord> chunk = (ArrayList<SplunkKVRecord>)tempKvSrs.get(destPartitionId);
            if (chunk == null) {
                chunk = new ArrayList<SplunkKVRecord>();
                tempKvSrs.put(destPartitionId, chunk);
            }
            chunk.add(kvSr);
        }
        for (Map.Entry chunk : tempKvSrs.entrySet()) {
            int destPartitionId = (Integer)chunk.getKey();
            ArrayList tempChunk = (ArrayList)chunk.getValue();
            Partition partition = shuffleDest.get(destPartitionId);
            partition.temp(tempChunk.iterator());
        }
    }

    public PartitionedDataset partitionBy(final Partitioner p) {
        Partition shuffled;
        final ArrayList<Partition> postShuffle = new ArrayList<Partition>();
        int numPars = this.partitions.size();
        for (int i = 0; i < numPars; ++i) {
            Partition par = new Partition(this.workDir(), this.uuid(), i, new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> kvSrs) {
                    return new ArrayList().iterator();
                }

                @Override
                public String desc() {
                    return Utils.toString(new Throwable("temp file holder lambda"));
                }
            });
            postShuffle.add(par);
        }
        Iterator<Partition> pars = this.partitions.iterator();
        ArrayList<Partition> ret = new ArrayList<Partition>(this.partitions.size());
        int parIdx = 0;
        while (pars.hasNext()) {
            Partition source = pars.next();
            shuffled = source.mapPartition(new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> kvSrs) {
                    PartitionedDataset.this.shuffle(kvSrs, postShuffle, p);
                    return new ArrayList().iterator();
                }

                @Override
                public String desc() {
                    return new Throwable("temping lambda").getStackTrace()[0].toString();
                }
            });
            ret.add(shuffled);
            ++parIdx;
        }
        PartitionedDataset postShuffleStage = new PartitionedDataset(this.workDir(), this, this.computer(), ret, String.format("%s_%s", this.name, "partitionedShuffleWritten"), true, false);
        pars = postShuffle.iterator();
        ret = new ArrayList();
        parIdx = 0;
        while (pars.hasNext()) {
            shuffled = pars.next();
            int tempParIdx = parIdx++;
            Partition readFromTemp = new Partition(this.workDir(), this.uuid(), shuffled.partitionId(), new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> kvSrs) {
                    return shuffled.readFromTemp();
                }

                @Override
                public String desc() {
                    return new Throwable("temp reader lambda").getStackTrace()[0].toString();
                }
            });
            ret.add(readFromTemp);
        }
        return new PartitionedDataset(this.workDir(), postShuffleStage, this.computer(), ret, String.format("%s_%s", this.name, "partitionedShuffledRead"), false, false);
    }

    private static List<SplunkRecord> calculateRanges(Iterator<SplunkRecord> srs, final SplunkComparator comparator, int numPars) {
        HashMap<SearchResult, SplunkKVRecord> unique = new HashMap<SearchResult, SplunkKVRecord>();
        long count = 0L;
        while (srs.hasNext()) {
            SplunkKVRecord sr = (SplunkKVRecord)srs.next();
            SearchResult key = sr.getKey();
            unique.put(key, sr);
            ++count;
        }
        logger.info((Object)String.format("calculate ranges: number of input srs: %d, number of distinct srs: %d", count, unique.size()));
        ArrayList srsList = new ArrayList();
        srsList.addAll(unique.values());
        Collections.sort(srsList, new Comparator<SplunkRecord>(){

            @Override
            public int compare(SplunkRecord lhs, SplunkRecord rhs) {
                return comparator.compare(lhs, rhs);
            }
        });
        double sampleLen = srsList.size();
        int bucketSize = (int)Math.floor(sampleLen / (double)numPars);
        bucketSize = Math.max(1, bucketSize);
        ArrayList<SplunkRecord> ranges = new ArrayList<SplunkRecord>();
        int bucketCounter = 0;
        int i = 0;
        while ((double)i < sampleLen) {
            SplunkRecord sr = (SplunkRecord)srsList.get(i);
            if (bucketCounter == bucketSize - 1) {
                ranges.add(sr);
                bucketCounter = 0;
                if (ranges.size() == numPars - 1) {
                    break;
                }
            } else {
                ++bucketCounter;
            }
            ++i;
        }
        logger.info((Object)String.format("calculate ranges: unique srses: %d, bucket size: %d, number of ranges: %d", (int)sampleLen, bucketSize, ranges.size()));
        if (logger.isDebugEnabled()) {
            logger.info((Object)String.format("range values: %s", ranges.toString()));
        }
        return ranges;
    }

    public PartitionedDataset reduceByKey(SplunkReducer reducer, String name, boolean preReduceShuffled) {
        ArrayList<Partition> ret;
        Iterator<Partition> pars;
        PartitionedDataset preReducedAndShuffled = this;
        if (!preReduceShuffled) {
            logger.info((Object)String.format("partitioned dataset reduce by key: will pre-reduce and then shuffle since the dataset is not pre-processed: %s", this.name()));
            pars = this.partitions.iterator();
            ret = new ArrayList(this.partitions.size());
            while (pars.hasNext()) {
                Partition source = pars.next();
                Partition partialReduced = source.reduceByKey(reducer);
                ret.add(partialReduced);
            }
            PartitionedDataset partiallyReducedDataset = new PartitionedDataset(this.workDir(), this, this.computer(), ret, String.format("%s_preshuffleReduced", name), false, false);
            preReducedAndShuffled = partiallyReducedDataset.partitionBy(new HashPartitioner(this.partitions.size()));
        }
        pars = preReducedAndShuffled.partitions.iterator();
        ret = new ArrayList<Partition>();
        while (pars.hasNext()) {
            Partition shuffledPar = pars.next();
            Partition finalReduce = shuffledPar.reduceByKey(reducer);
            ret.add(finalReduce);
        }
        return new PartitionedDataset(this.workDir(), preReducedAndShuffled, this.computer(), ret, String.format("%s_postShuffleReduced", name), false, false);
    }

    private static long getSortSampleSizePerPartition() {
        long sample = 10L;
        String sampleStr = System.getenv("DFS_SORT_SAMPLE_PER_PARTITION");
        if (sampleStr != null && !sampleStr.trim().isEmpty()) {
            try {
                sample = Long.valueOf(sampleStr);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse sort sample size per partition: %s to long", sampleStr));
            }
        }
        logger.info((Object)String.format("sort sample records per partition: %d", sample));
        return sample;
    }

    public PartitionedDataset sample(final long numRecs, String name) {
        ArrayList<Partition> ret = new ArrayList<Partition>();
        for (Partition par : this.partitions()) {
            Partition samplePar = par.mapPartition(new MapPartitionFunction(){

                @Override
                public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                    return new Iterator<SplunkRecord>(){
                        int count = 0;
                        SplunkRecord sr;

                        @Override
                        public boolean hasNext() {
                            if (this.sr != null) {
                                return true;
                            }
                            if ((long)this.count >= numRecs) {
                                return false;
                            }
                            if (srs.hasNext()) {
                                this.sr = (SplunkRecord)srs.next();
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public SplunkRecord next() {
                            SplunkRecord ret = this.sr;
                            this.sr = null;
                            return ret;
                        }
                    };
                }

                @Override
                public String desc() {
                    return Utils.toString(new Throwable("sampler lambda"));
                }
            });
            ret.add(samplePar);
        }
        return new PartitionedDataset(this.workDir(), this, this.computer(), ret, String.format("%s_sampled", name), false, false);
    }

    public PartitionedDataset sortByKey(final SplunkComparator comparator, String name) {
        PartitionedDataset cached = this.cache();
        PartitionedDataset sampledDataset = cached.sample(PartitionedDataset.getSortSampleSizePerPartition(), "sortSampled");
        long start = System.currentTimeMillis();
        Iterator<SplunkRecord> sampleSrs = sampledDataset.iterator(-1L);
        logger.info((Object)String.format("partitioned dataset: sort by key: time to sample dataset: %s, %d millis", name, System.currentTimeMillis() - start));
        List<SplunkRecord> ranges = PartitionedDataset.calculateRanges(sampleSrs, comparator, this.partitions.size());
        RangePartitioner p = new RangePartitioner(comparator, ranges);
        PartitionedDataset shuffledDataset = cached.partitionBy(p);
        PartitionedDataset sortedPerPartitionDataset = shuffledDataset.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> kvSrs) {
                ArrayList<SplunkRecord> ret = new ArrayList<SplunkRecord>();
                while (kvSrs.hasNext()) {
                    ret.add(kvSrs.next());
                }
                Collections.sort(ret, new Comparator<SplunkRecord>(){

                    @Override
                    public int compare(SplunkRecord lhs, SplunkRecord rhs) {
                        return comparator.compare(lhs, rhs);
                    }
                });
                return ret.iterator();
            }

            @Override
            public String desc() {
                return new Throwable("sort within partition lambda").getStackTrace()[0].toString();
            }
        }, String.format("%s_sortedWithinPartitions", name), true);
        return sortedPerPartitionDataset;
    }
}

