/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.splunkcompute.PartitionedDataset;
import com.splunk.df.search.compute.splunkcompute.SplunkComputer;
import com.splunk.df.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class PartitionedDatasetFactory {
    static final Logger logger = Logger.getLogger(PartitionedDatasetFactory.class);
    private static PartitionedDatasetFactory singleton = new PartitionedDatasetFactory();
    private ArrayList<ExecutorService> computers = new ArrayList();

    public static PartitionedDatasetFactory getInstance() {
        return singleton;
    }

    public PartitionedDataset getNewPartitionedDataset(String workDir, final int numCores, final String name) {
        File workDirDir = new File(workDir);
        if (!workDirDir.exists()) {
            throw new RuntimeException(String.format("work directory does not exist: %s", workDir));
        }
        if (!workDirDir.isDirectory()) {
            throw new RuntimeException(String.format("work directory exists but is not a directory: %s", workDir));
        }
        final ExecutorService computer = Executors.newFixedThreadPool(numCores, new ThreadFactory(){
            private Integer id = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable r) {
                int newId;
                Thread t = new Thread(r);
                Integer n = this.id;
                synchronized (n) {
                    newId = this.id;
                    Integer n2 = this.id;
                    Integer n3 = this.id = Integer.valueOf(this.id + 1);
                }
                t.setName(String.format("computation thread: %d for partitioned dataset: %s", newId, name));
                return t;
            }
        });
        this.computers.add(computer);
        logger.info((Object)String.format("created thread pool with %d threads for computation", numCores));
        PartitionedDataset ret = new PartitionedDataset(workDir, null, new SplunkComputer(){

            @Override
            public int numThreads() {
                return numCores;
            }

            @Override
            public Future<?> submit(Runnable r) {
                return computer.submit(r);
            }

            @Override
            public void shutdown() {
                computer.shutdown();
            }

            @Override
            public boolean isShutdown() {
                return computer.isTerminated();
            }
        }, name, false, false);
        return ret;
    }

    public void close() {
        logger.info((Object)String.format("splunk computers for processing partitioned datasets will be shutdown: %d", this.computers.size()));
        long start = System.currentTimeMillis();
        Iterator<ExecutorService> iter = this.computers.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            ExecutorService computer = iter.next();
            computer.shutdown();
            while (!computer.isShutdown()) {
                Utils.sleep(10L);
            }
            logger.info((Object)String.format("computer %d shutdown", counter));
            ++counter;
        }
        logger.info((Object)String.format("time taken to shutdown splunk %d computers: %d millis", counter, System.currentTimeMillis() - start));
    }
}

